package DTF.modules;

//import java.util.Queue;

/*
 * Not a full pattern matcher in the traditional Robocode sense. Just finds the closest
 * single-sample match (rather than matching ~7 samples), and returns the position X turns after that match.
 */

import DTF.Util;
import robocode.AdvancedRobot;

public class PatternMatcher {
	public static final int bin_size=256; //thought I could get by with less, but performance drops noticeably if I try.
	public static final int num_bins=61; //should be a prime number, or at least not divisible by (currently) 2 or 5
	
	public static int match_threshold=4000;
	
	private Pattern current;
	
	private PatternBin[] bins;
	
	//private AdvancedRobot me;
	
	private int round=-1;
	
	private int pruneLimit;
	
	//when connecting current.next to following, be careful not to connect between rounds. Maybe reset current to null at start of each round
	
	//todo future: have a queue of new patterns waiting to bin, to avoid overwriting useful patterns before the new ones become useful
	
	public PatternMatcher() {
		
		bins=new PatternBin[num_bins];
		for(int i=0;i<num_bins;i++) {
			bins[i]=new PatternBin(bin_size);
		}
		
		
	}
	
	//public void newGame() {
//		current=null;
	//}
	
	private void prune() {
		for(int i=0;i<num_bins;i++) {
			bins[i].pruneAfter(pruneLimit);
		}
	}
	
	
	//call before calling predictFromCurrent
	public void addPattern(Pattern p) {
		if(Util.getMe().getRoundNum()!=round) {
			//not in constructor because it was getting called before util.me was set
			//estimate most turns we could possibly want to trace after a sample.
			pruneLimit=(int)(Util.distance(Util.getMe().getBattleFieldHeight(),Util.getMe().getBattleFieldWidth())/11.0+10.0);
			
			
			//break linked list between rounds
			round=Util.getMe().getRoundNum();
			current=null;

			prune();
		} else if(p.turns%pruneLimit==0) {
			prune();
		}
		if(current!=null) current.next=p;
		current=p;
		bins[p.getBin()].addPattern(p);
	}
	
	public Pattern predictFromCurrent(int turnNum) {
		return predictFrom(turnNum,current);
	}
	
	public Pattern predictFrom(int turnNum, Pattern base) {
		if(base==null) return null;
		int turnsAhead=turnNum-base.turns;
		
		//todo cache similar until current changes
		Pattern similar = bins[base.getBin()].findNearest(base, turnsAhead, match_threshold);

		
		if(similar==null) return null;
		
		return similar.predict(turnsAhead, base);
	}
}
