(function() {
	$set(
		(function() {
			var rv = [];

			var events = function() {
				Array.prototype.slice.call(arguments).forEach(function(name) {
					rv.push({ name: name, as: "event" });
				})
			};

			var awtEvents = function() {
				Array.prototype.slice.call(arguments).forEach(function(name) {
					rv.push({ name: name, as: "awtEvent" });
				})
			};

			var awtDebug = function(name) {
				rv.push({ name: name, as: "awtDebug" });
			}

			var getter = function(name) {
				return "get" + name.substring(0,1).toUpperCase() + name.substring(1);
			}
			
			var booleanGetter = function(name) {
				return "is" + name.substring(0,1).toUpperCase() + name.substring(1);
			}

			var setter = function(name) {
				return "set" + name.substring(0,1).toUpperCase() + name.substring(1);
			}

			var readOnlyProperty = function(name, type) {
				rv.push({ name: name, as: "property", type: type, readonly: true });
				rv.push({ name: getter(name), as: "getter", type: type });
			};

			var query = function(name, types, returns) {
				if (name.substring(0,3) == "get") {
					rv.push({ name: name.substring(3,4).toLowerCase() + name.substring(4), as: "omit" });
				}
				rv.push({ name: name, as: "query", types: types, returns: returns });
			}

			var property = function(name, type, deprecated) {
				rv.push({ name: name, as: "property", type: type, deprecated: deprecated });
				rv.push({ name: (type == "boolean") ? booleanGetter(name) : getter(name), as: "getter", type: type, deprecated: deprecated });
				rv.push({ name: setter(name), as: "command", type: type, deprecated: deprecated });
			};

			var provide = function(name) {
				rv.push({ name: name, as: "is" });
			}

			var command = function(name, type, deprecated) {
				rv.push({ name: name, as: "command", type: type, deprecated: deprecated });
			}

			var set = function(name, type) {
				if (arguments.length == 2) {
					rv.push({ name: name, as: "set", type: type, deprecated: false });
					rv.push({ name: name.substring(3,4).toLowerCase() + name.substring(4), as: "omit" });
				} else if (arguments.length > 2) {
					rv.push({ name: name, as: "set", types: Array.prototype.slice.call(arguments).slice(1), deprecated: false });
					rv.push({ name: name.substring(3,4).toLowerCase() + name.substring(4), as: "omit" });
				} else if (arguments.length == 1) {
					rv.push({ name: name, as: "set" });					
					rv.push({ name: name.substring(3,4).toLowerCase() + name.substring(4), as: "omit" });
				}
			};

			var implement = function(name) {
				rv.push({ name: name, as: "implement" });
			}

			var omit = function() {
				Array.prototype.slice.call(arguments).forEach(function(name) {
					rv.push({ name: name, as: "omit" });
				});
			};

			var java = function() {
				Array.prototype.slice.call(arguments).forEach(function(name) {
					rv.push({ name: name, as: "java" });
				});
			}

			events(
				"onStatus", "onDeath", "onSkippedTurn", "onBulletHit", "onBulletHitBullet", "onBulletMissed", "onHitByBullet",
				"onHitRobot", "onHitWall", "onRobotDeath", "onWin", "onRoundEnded", "onBattleEnded", "onScannedRobot",
				"onCustomEvent"
			)

			awtEvents(
				"onKeyPressed", "onKeyReleased", "onKeyTyped", "onMouseClicked", "onMouseEntered", "onMouseExited", "onMousePressed",
				"onMouseReleased", "onMouseMoved", "onMouseDragged", "onMouseWheelMoved"
			);

			awtDebug(
				"onPaint"
			);

			readOnlyProperty("width", "double");
			readOnlyProperty("height", "double");

			readOnlyProperty("numRounds", "int");
			readOnlyProperty("battleFieldWidth", "double");
			readOnlyProperty("battleFieldHeight", "double");

			readOnlyProperty("roundNum", "int");

			readOnlyProperty("time", "long");

			readOnlyProperty("energy", "double");

			readOnlyProperty("x", "double");
			readOnlyProperty("y", "double");

			readOnlyProperty("heading", "double");
			readOnlyProperty("headingRadians", "double");
			readOnlyProperty("headingDegrees", "double", true);
			readOnlyProperty("velocity", "double");

			readOnlyProperty("radarHeading", "double");
			readOnlyProperty("radarHeadingRadians", "double");
			readOnlyProperty("radarHeadingDegrees", "double", true);

			readOnlyProperty("gunHeading", "double");
			readOnlyProperty("gunHeadingRadians", "double");
			readOnlyProperty("gunHeadingDegrees", "double", true);

			readOnlyProperty("gunHeat", "double");
			readOnlyProperty("gunCoolingRate", "double");

			readOnlyProperty("turnRemaining", "double");
			readOnlyProperty("turnRemainingRadians", "double");

			readOnlyProperty("radarTurnRemaining", "double");
			readOnlyProperty("radarTurnRemainingRadians", "double");

			readOnlyProperty("gunTurnRemaining", "double");
			readOnlyProperty("gunTurnRemainingRadians", "double");

			readOnlyProperty("distanceRemaining", "double");
			readOnlyProperty("dataQuotaAvailable", "long");

			readOnlyProperty("others", "int");
			readOnlyProperty("numSentries", "int");

			readOnlyProperty("sentryBorderSize", "int");

			readOnlyProperty("numBattles", "int", true);
			readOnlyProperty("life", "double", true);
			readOnlyProperty("gunCharge", "double", true);
			readOnlyProperty("battleNum", "int", true);
			readOnlyProperty("maxWaitCount", "int", true);
			readOnlyProperty("waitCount", "int", true);

			readOnlyProperty("allEvents", "java.util.Vector");
			readOnlyProperty("bulletHitBulletEvents", "java.util.Vector");
			readOnlyProperty("bulletHitEvents", "java.util.Vector");
			readOnlyProperty("bulletMissedEvents", "java.util.Vector");
			readOnlyProperty("hitByBulletEvents", "java.util.Vector");
			readOnlyProperty("hitRobotEvents", "java.util.Vector");
			readOnlyProperty("hitWallEvents", "java.util.Vector");
			readOnlyProperty("robotDeathEvents", "java.util.Vector");
			readOnlyProperty("scannedRobotEvents", "java.util.Vector");
			readOnlyProperty("statusEvents", "java.util.Vector");

			readOnlyProperty("dataDirectory", "java.io.File");
			query("getDataFile", ["java.lang.String"], "java.io.File");

			readOnlyProperty("graphics", "java.awt.Graphics2D");

			query("getEventPriority", ["java.lang.String"], "int");

			property("adjustRadarForRobotTurn", "boolean");
			property("adjustRadarForGunTurn", "boolean");
			property("adjustGunForRobotTurn", "boolean");

			//	TODO	convert these to JavaScript strings
			property("gunImageName", "java.lang.String", true);
			property("radarImageName", "java.lang.String", true);
			property("robotImageName", "java.lang.String", true);

			//	TODO	looks like command() and set() could be generalized and combined

			//	Should pure commands be write-only properties? Maybe properties that return their last set value?
			set("setMaxTurnRate", "double");
			set("setMaxVelocity", "double");
			set("setBodyColor", "java.awt.Color");
			set("setRadarColor", "java.awt.Color");
			set("setGunColor", "java.awt.Color");
			set("setScanColor", "java.awt.Color");
			set("setBulletColor", "java.awt.Color");
			set("setAllColors", "java.awt.Color");
			set("setInterruptible", "boolean");
			set("setDebugProperty", "java.lang.String", "java.lang.String");
			set("setEventPriority", "java.lang.String", "int");
			set("setColors"); // overloaded so we leave types blank, which causes them not to be verified

			command("doNothing");
			command("scan");
			command("clearAllEvents");
			command("ahead", "double");
			command("setAhead", "double");
			command("back", "double");
			command("setBack", "double");
			//	setStop and stop are overloaded so we do not provide argument types
			command("stop");
			command("setStop");
			command("resume");
			command("setResume");
			command("turnLeft", "double");
			command("turnRight", "double");
			command("turnLeftRadians", "double");
			command("turnRightRadians", "double");
			command("turnLeftDegrees", "double", true);
			command("turnRightDegrees", "double", true);
			command("setTurnLeft", "double");
			command("setTurnRight", "double");
			command("setTurnLeftRadians", "double");
			command("setTurnRightRadians", "double");
			command("setTurnLeftDegrees", "double", true);
			command("setTurnRightDegrees", "double", true);

			command("turnRadarLeft", "double");
			command("turnRadarRight", "double");
			command("turnRadarLeftRadians", "double");
			command("turnRadarRightRadians", "double");
			command("turnRadarLeftDegrees", "double", true);
			command("turnRadarRightDegrees", "double", true);
			command("setTurnRadarLeft", "double");
			command("setTurnRadarRight", "double");
			command("setTurnRadarLeftRadians", "double");
			command("setTurnRadarRightRadians", "double");
			command("setTurnRadarLeftDegrees", "double", true);
			command("setTurnRadarRightDegrees", "double", true);

			command("turnGunLeft", "double");
			command("turnGunRight", "double");
			command("turnGunLeftRadians", "double");
			command("turnGunRightRadians", "double");
			command("turnGunLeftDegrees", "double", true);
			command("turnGunRightDegrees", "double", true);
			command("setTurnGunLeft", "double");
			command("setTurnGunRight", "double");
			command("setTurnGunLeftRadians", "double");
			command("setTurnGunRightRadians", "double");
			command("setTurnGunLeftDegrees", "double", true);
			command("setTurnGunRightDegrees", "double", true);
			command("fire", "double");
			command("setFire", "double");

			command("addCustomEvent", "robocode.Condition");
			command("removeCustomEvent", "robocode.Condition");
			command("waitFor", "robocode.Condition");

			command("fireBullet", "double");
			command("setFireBullet", "double");

			command("execute");
			command("endTurn", void(0), true);

			provide("out");
			implement("run");

			//	TODO	possible automatic verification of deprecation?

			// rv.setInterruptible = { as: "command", type: "boolean" };
			// rv.setFire = { as: "command", type: "double" };

			//	IBasicRobot documentation says to omit these
			omit("peer", "setPeer");
			omit("setOut");

			//	AdvancedRobot documentation says to omit these
			omit("getAdvancedEventListener");

			//	TODO	is there a reason we need this?
			omit("name", "getName");

			java("getClass","notifyAll","notify","equals","hashCode","toString","wait");
			omit("class");

			//	These are final, used by the engine
			omit("robotRunnable", "getRobotRunnable");
			omit("basicEventListener", "getBasicEventListener");
			omit("advancedEventListener", "getAdvancedEventListener");
			omit("interactiveEventListener", "getInteractiveEventListener");
			omit("paintEventListener", "getPaintEventListener");

			return rv;
		})()	
	);
})($set)
