package brainfade.utils;
import robocode.*;
import java.awt.*;
import java.util.*;
import java.awt.geom.*;
import brainfade.gun.*;

public class Enemy extends Point2D.Double
{
    //Standard Variables
    final double pi = Math.PI;
    Enemy target;
    
    //Basic target variables
    public double distance = 0;
    public double bearing = 0;
    public double heading = 0;
    public double velocity = 0;
    public double energy = 100;
    public double energyChange = 0;
    public double time = 0;
    public double lateralVelocity = 0;
    public double advancingVelocity = 0;
    public int direction = 1;
    public double acceleration;
    public boolean isAlive = true;
    public double firepower = 3;
    public long nextMoveTime = -1;
    public double lastBearing = 0;
    public double lastLastBearing = 0;
    public long fireTime = -10;
    public Point2D lastPosition;
    public double maxAngle;
    
    //Segmentation variables
    
    //Gun variables
    final double GUESS_FACTORS = 25D;
    //public Guess[][] stats = new Guess[5][(int)GUESS_FACTORS];
    Vector waves = new Vector();
    
    public int segmentCount = 1;
    public int magicNumber = 1;
    
    //Random variables
    AdvancedRobot AR;
    
    public Enemy()
    {
        
    }
    
    public void init(AdvancedRobot AR, Enemy target)
    {
        this.AR = AR;
        this.target = target;
        /*if(AR.getRoundNum()==0)
        {
            for(int j=0; j<5; j++)
            {
                for(int i=0; i<25; i++)
                {
                    stats[j][i] = new Guess(this);
                    stats[j][i].index = i;
                    stats[j][i].value = 1;
                }
            }
        }*/
    }
    
    public void update(ScannedRobotEvent e)
    {
        distance = e.getDistance();
        heading = e.getHeadingRadians();
        velocity = e.getVelocity();
        bearing = robocode.util.Utils.normalAbsoluteAngle(e.getBearingRadians() + AR.getHeadingRadians());
        time = AR.getTime();
        energyChange = e.getEnergy() - energy;
        energy = e.getEnergy();
        lateralVelocity = velocity*Math.sin(heading-bearing);
        lastPosition = new Point2D.Double(getX(), getY());
        this.setLocation(AR.getX()+(distance*Math.sin(bearing)), AR.getY()+(distance*Math.cos(bearing)));
        direction = sign(lateralVelocity);
        
        if(hasFired())
        {
            setFirePower(firepower());
            fireTime = AR.getTime();
        }
      
        //Wave2 wave = new Wave2(AR, target.firepower, stats[getDistanceIndex()], this);
        //AR.addCustomEvent(wave);
    }
    
    public double bulletV (double shotPower) 
    {
        return (20 - (3 * shotPower));
    }
    
    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) 
    {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
    }
    
    public int sign(double value)
    {
        if(value<0) return -1;
        return 1;
    }
    
    public double getShootAngle()
    { 
        //Guess bestVal = ((Guess)Collections.max(Arrays.asList(stats[getDistanceIndex()])));
        //int bestIndex = bestVal.index;
        return bearing;//(robocode.util.Utils.normalAbsoluteAngle(getGuessAngle(bestIndex, firepower)+bearing));         
    }
    
    public double getGuessAngle(int guessIndex, double firePower) 
    {
        System.out.println("SHOOTING AT: " + guessIndex);
        if (energy == 0.0) return 0.0;
        return (guessIndex - ((GUESS_FACTORS - 1.0) / 2.0)) / ((GUESS_FACTORS - 1.0) / 2.0) * Math.asin(8.0 / bulletV(firepower)) * (double)direction;
    }

    public RoundRectangle2D fieldRectangle(double margin, AdvancedRobot AR) 
    {
        //System.out.println(AR);
        return new RoundRectangle2D.Double(margin, margin,
	    AR.getBattleFieldWidth() - margin * 2, AR.getBattleFieldHeight() - margin * 2, 75, 75);
    }

    public void fireWaves(AdvancedRobot AR, Guess[] stats, double firepower, Enemy target)
    {
        Wave w = new Wave(AR, firepower, stats, this, target);
        waves.add(w);
        //AR.addCustomEvent(w);
    }
    
    double absoluteBearing(Point2D source, Point2D target)
    {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
    public boolean hasFired()
    {
        return energyChange <= -0.10000000000000001D && energyChange >= -3D;
    }

    public double firepower()
    {
        return -energyChange;
    }
    
    public void bulletHit(HitByBulletEvent e)
    {
        energy += 3*e.getPower();
    }
    
    public void hitByBullet(BulletHitEvent e)
    {
        energy -= 4*e.getEnergy();
    }
    
    public boolean isFiring()
    {
        return (AR.getTime()-fireTime)<100;
    }
    
    public int getDistanceIndex(double thisDistance)
    {
        return Math.min((int)(thisDistance / (900/5)), 4);
    }
    
    public int getVelocityIndex(double thisVelocity)
    {
        return 0;//(int)Math.round(Math.abs(thisVelocity/4));
    }
    
    public void setFirePower(double power)
    {
        firepower = power;
        maxAngle = Math.asin(8/(20-(3*power)));
    }
    
    public void reset()
    {
        distance = 0;
        bearing = 0;
        heading = 0;
        velocity = 0;
        energy = 100;
        energyChange = 0;
        time = 0;
        nextMoveTime = -1;
        isAlive = true;
        waves = new Vector();
    }
}

