package brainfade.utils;
import robocode.*;
import java.awt.geom.*;
import java.util.*;
import brainfade.gun.*;

public class Muggins extends Enemy
{
    AdvancedRobot AR;
    Enemy target;
    public Point2D nextDestination;
    public int forwards = 1;
    int directionAtStart = 1;
    public double[] bulletPowers = { 3.0, 2.8, 2.4, 2.0, 1.7 };
    
    Wave surfing;
    
    double shotBearing;
    Point2D circleCentre = new Point2D.Double();
    Guess[][][] stats = new Guess[10][10][25];
    double bounceVal;
    double rollingVal;
    
    long tickCount = 0;
    
    public Muggins()
    {
        
    }
    
    public void init(AdvancedRobot AR, int segmentCount, int magicNumber, Enemy target)
    {
        this.AR = AR;
        this.target = target;
        this.bounceVal = -0.8;
        this.rollingVal = 3;
        this.segmentCount = segmentCount;
        this.magicNumber = magicNumber;        
        
        if(AR.getRoundNum()==0)
        {    
            for(int k=0; k<10; k++)
            {
                for(int j=0; j<10; j++)
                {
                    for(int i=0; i<25; i++)
                    {
                        stats[k][j][i] = new Guess(this, target, rollingVal);
                        stats[k][j][i].index = i;
                        stats[k][j][i].distIndex = j;
                        stats[k][j][i].value = 1;
                    }
                }
            }
        }
    }
    
    public void update()
    {
        //if(time == 99999) waves = new Vector();
        setLocation(AR.getX(), AR.getY());
        distance = this.distance(target);
        heading = AR.getHeadingRadians();
        acceleration = Math.min(1, Math.max(-2, Math.abs(AR.getVelocity()) - Math.abs(velocity)));
        velocity = AR.getVelocity();
        lastLastBearing = lastBearing;
        lastBearing = bearing;
        bearing = absoluteBearing(target, this);
        time = AR.getTime();
        energy = AR.getEnergy();
        lateralVelocity = velocity*Math.sin(heading-bearing);
        advancingVelocity = -velocity*Math.cos(heading-bearing);
        //if(advancingVelocity>4) forwards*=-1;
        
        tickCount++;
        
        direction = sign(lateralVelocity);
        
        if(target.hasFired())fireWaves(AR, stats[getDistanceIndex(distance)][getVelocityIndex(velocity)], target.firepower(), target);
    }
    
    public Point2D doMove()
    {
         if(waves.size()==0) 
         {
            return this;
         }
        
        //Find closest
        Enumeration e = waves.elements();
        double closestDist = 10000;
        while(e.hasMoreElements())
        {
            Wave temp = (Wave)e.nextElement();
            temp.test();
            if(temp.waveDist-this.distance(temp.here)>20)
            {
                if(temp.waveDist-this.distance(temp.here)>30)waves.remove(temp);
            }
            else if((this.distance(temp.here)-temp.waveDist)/temp.bulletSpeed<closestDist)
            {
                closestDist = (this.distance(temp.here)-temp.waveDist)/temp.bulletSpeed;
                surfing = temp;
            }
            
        }
        
        double targetDistance = this.distance(target)>400?this.distance(surfing.here):this.distance(surfing.here)+20;//target.distance>250?target.distance-50:target.distance+20;
        Point2D circleCentre = surfing.here;
        
        Guess[] newStats = makeTemp(closestDist);		
        Guess maxStat = (Guess) Collections.min(Arrays.asList(newStats));
        int guessIndex = maxStat.index;	
        boolean smooth = true;
        return getDestination(guessIndex, targetDistance, circleCentre, smooth);
    }
    
    public Point2D getDestination(int guessIndex, double targetDistance, Point2D circleCentre, boolean smooth)
    {        
        double currentBearing = absoluteBearing(surfing.here, this);
        double bearingDiff = surfing.direction * robocode.util.Utils.normalRelativeAngle(currentBearing - surfing.enemyBearing);
        int currentIndex = (int)Math.min(Math.max(0L, Math.round((bearingDiff / surfing.maxAngle) * 12D) + 12D), 24L);
        
        double shotBearing = getGuessAngle((guessIndex-currentIndex)+12, firepower) + currentBearing;
        Point2D destination = vectorToLocation(shotBearing, targetDistance, circleCentre);
        //System.out.println(shotBearing);
        double myHeading = absoluteBearing(this, destination);
        double moveDistance = this.distance(destination);
        int tries = 0;
        
        while(!fieldRectangle(50, AR).contains(vectorToLocation(myHeading, 120, this))&&tries++<100)
        {
            myHeading += direction*0.05;
        }
        
        if((Math.cos(myHeading - bearing)<bounceVal)&&smooth) return getDestination(24-guessIndex, targetDistance, circleCentre, false);
        return vectorToLocation(myHeading, moveDistance, this);
    }
    
    public Guess[] makeTemp(double time)
    {
        int topVal = getForwardsReachable(time);
        int bottomVal = getBackwardsReachable(time);
        
        int count;
        Guess[] temp = new Guess[25];
        
        int j = getDistanceIndex(distance);
        int k = getVelocityIndex(velocity);
        
        for (int i=0; i<25; i++)
        {
            temp[i].maxVal = topVal;
            temp[i].minVal = bottomVal;
            
            if(i<bottomVal||i>topVal)
            {
                temp[i] = new Guess(this, target, rollingVal);
                temp[i].index = i;
                temp[i].value = 9999999;
            }
            else
            {
                temp[i] = new Guess(this, target, rollingVal);
                temp[i].index = stats[j][k][i].index;
                temp[i].value = (float)stats[j][k][i].value;
            }
        }
       
        return temp;
    }
    
    public int getForwardsReachable(double time)
    {
        double bearingDiff = robocode.util.Utils.normalRelativeAngle(absoluteBearing(surfing.here, this) - surfing.enemyBearing);
        double myVelocity = surfing.direction * sign(velocity* Math.sin(heading-absoluteBearing(surfing.here, this))) * Math.abs(velocity);
        
        for(int i=0; i<time; i++)
        {
            if(myVelocity == -1) myVelocity = -2; 
            myVelocity += (myVelocity<0?2:1);
            myVelocity = Math.min(8, myVelocity);
            bearingDiff += surfing.direction*myVelocity/(this.distance(surfing.here));
        }
        
        return (int)Math.max(12,Math.min(12.0+(int)((surfing.direction*bearingDiff/surfing.maxAngle)*12.0),24.0));
    }
    
    public int getBackwardsReachable(double time)
    {
        //Works out the bearing difference from when the wave was fired
        double bearingDiff = robocode.util.Utils.normalRelativeAngle(absoluteBearing(surfing.here, this) - surfing.enemyBearing);
        //Works out my lateral velocity compared to the direction i was going when the wave was fired
        double myVelocity = surfing.direction * sign(velocity* Math.sin(heading-absoluteBearing(surfing.here, this))) * Math.abs(velocity);
        
        //Loop through all the possible times
        for(int i=0; i<time; i++)
        {
            //Increase the velocity to account for acceleration
            if(myVelocity == 1) myVelocity = 2; 
            myVelocity += (myVelocity>0?-2:-1);
            myVelocity = Math.max(-8, myVelocity);
            
            //Work out the bearing difference for this lateral velocity for the current tick
            bearingDiff += surfing.direction*myVelocity/(this.distance(surfing.here));
        }
        
        //Return index corresponding the most backwardly reachable guess factor
        return Math.max(0,Math.min(12+(int)((surfing.direction*bearingDiff/surfing.maxAngle)*12),12));
    }
    
    public long nextMoveTime()
    {
        return AR.getTime() + Math.round(target.distance(this)/bulletV(firepower));
    }
    
    public double getGuessAngle(int guessIndex, double firePower) 
    {
        if (energy == 0.0) return 0.0;
        double value = (guessIndex - 12.0) / 12.0 * surfing.maxAngle * surfing.direction;
        //System.out.println(guessIndex);
        return value;
    }
    
    public void fireWaves(AdvancedRobot AR, Guess[] stats, double firepower, Enemy target)
    {
        Wave w = new Wave(AR, firepower, stats, this, target);
        waves.add(w);
        AR.addCustomEvent(w);
    }
    
    public void hitByBullet(HitByBulletEvent e)
    {
        if(waves.size()>0)
        {
            Wave hitMe = surfing;
            Enumeration en = waves.elements();
            double closestDist = 99999999;
            
            //System.out.println("WAVE SIZE " + waves.size());

            while(en.hasMoreElements())
            {
                Wave temp = (Wave) en.nextElement();
                temp.test();
                if((Math.abs(temp.waveDist-this.distance(temp.here))<closestDist)&&(Math.abs(surfing.firepower-e.getPower())<0.001))
                {
                    hitMe = temp;
                    closestDist = Math.abs(temp.waveDist-this.distance(temp.here));
                }
            }

            //System.out.println("HIT AT: " + hitMe.index); 
            
            for(int i=0; i<GUESS_FACTORS; i++)
            {
                if(i<=hitMe.maxIndex&&i>=hitMe.minIndex)
                {
                    //stats[getDistanceIndex(hitMe.distance)][getVelocityIndex(hitMe.velocity)][i].rollingAvg(10);
                    stats[getDistanceIndex(hitMe.distance)][getVelocityIndex(hitMe.velocity)][i].lastHitTime = tickCount;
                }
            }

            //waves.remove(hitMe);
        }
    }
}


