/*
 * Created on Nov 27, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package dans;

import java.awt.geom.*;
import java.util.Vector;

/**
 * @author Danny
 *
 * RobocodeUtils.java
 * Created on Nov 27, 2003
 * 
 */


 /**
 * This class contains a set of useful methods for programming
 * robocode robots, mainly dealing with distances and angles.
 * Most of these would actually work for any 2d application. All
 * functions use radians, not degrees.
 **/

 public class RobocodeUtils {
	
	private RobocodeUtils() {}
	
	public static final double TWO_PI = Math.PI*2;
	public static final double HALF_PI = Math.PI/2;
	
	/**return the distance between (x1,y1) and (x2,y2)*/
	public static double dist(double x1, double y1, double x2, double y2) {
		return Math.sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
	}
	
	/**
	 * Normalizes an angle (reduces it to the coterminal angle theta
	 * such that  0 < theta < 2*pi)
	 **/
	public static double normalizeHeading(double ang) {
		while (ang < 0) ang += TWO_PI;
		while (ang > TWO_PI) ang -= TWO_PI;
		return ang;
	}
	
	/**
	 * Normalizes a bearing (reduces it to the coterminal angle theta
	 * such that  -pi < theta < pi)
	 **/
	public static double normalizeBearing(double ang) {
		while (ang < -Math.PI) ang += TWO_PI;
		while (ang > Math.PI) ang -= TWO_PI;
		return ang;
	}
	
	/**returns the bearing from (x1,y1) to (x2,y2) in the range -pi to pi*/
	public static double getBearing( double x1,double y1, double x2,double y2 ) {
		double xo = x2-x1;
		double yo = y2-y1;
		return Math.atan2(xo,yo);
	}
	/** returns the enemy's X location */
	public static double enemyX(double angle, double yourX, double dist)
	{
		double x1 = yourX + (Math.sin(angle) * dist);
		return x1;
	} 
	/** returns the enemy's Y location */
	public static double enemyY(double angle, double yourY, double dist)
	{
 		 double y1 = yourY + (Math.cos(angle) * dist);
		 return y1;
	} 
	/** returns a number from min-max
	 * @return double 
	 */
	public static double randomInRange(double max, double min){
			double number=Math.random()*((max-(2*min))+min);
			return number;
		}
	/**Returns a the Average of a set of numbers, weighted for the latest data*/
	protected static double getMovingAverage(Vector v, int depth)
		{
		int start = v.size() - depth;
		   if(start < 0) start = 0;
		   double tot = 0;
		   int ctr = 0;
		   for(int i = start; i < v.size(); i++)
		   {
			tot += ((Double)v.elementAt(i)).doubleValue();
				ctr++;
			}
		   return tot / ctr;
		}
	/**Returns the Angle between two points*/
	public static double getBearing(Point2D a, Point2D b){
		double xo = b.getX()-a.getX();
		double yo = b.getY()-a.getY();
		return Math.atan2(xo,yo);
		}
	/**Returns a the Average of a set of numbers, weighted for the latest data*/		
	public static double rollingAvg(double value, double newEntry, double n, double weighting ) {
		return (value * n + newEntry * weighting)/(n + weighting);
	} 
	/**Returns a point based on you location(x0,y0) the bearing to the other point(a), and the distance(r)*/
	public static Point2D calcPoint(double a, double x0, double y0, double r)
	{
		 double x1 = x0+(Math.sin(a) * r);
		 double y1 = y0+(Math.cos(a) * r);
		 Point2D xy= new Point2D.Double(x1,y1);
		 return xy;
	} 
	

 }
