package yk;
import robocode.*;
import java.util.Vector;
import java.awt.Color;

/**
 * JahMicro - a robot by (Yaroslav Kourovtsev)
 */
// robocode.util.Utils.normalAbsoluteAngle
// robocode.util.Utils.normalRelativeAngle
public class JahMicro extends AdvancedRobot
{
	private class C
	{
		public double targetheading;//radians
		public double x;
		public double y;
		public double velocity;
		public long time;
		public double distance;
	}
	/**
	 * run: JahMicro's default behavior
	 */
	
	private double getBulletSpeed(double power)
	{
		return 20 - 3 * power;
	}
	
	private Vector targets = new Vector();
	private boolean forward = true;
	private void correctDirection()
	{
		double x = getX();
		double y = getY();
		double w = getBattleFieldWidth();
		double h = getBattleFieldHeight();
		double r = getHeadingRadians() + (forward?0:Math.PI);
//		double s = (forward ? 1 : -1);
		double dx = Math.sin(r)/* * s*/;
		double dy = Math.cos(r)/* * s*/;
/*		if (!forward)
		{
			dx = -dx;
			dy = -dy;
		}
*/		double c = 100;
		if ((x < c && dx < 0)
			|| (x > w - c && dx > 0)
			|| (y < c && dy < 0)
			|| (y > h - c && dy > 0))
			reverseDirection();

	}
	private void reverseDirection()
	{
		if (forward)
		{
			setBack(40000);
		}
		else
		{
			setAhead(40000);
		}
		forward = !forward;
	}
	public void run() {
//		setColors(Color.pink,Color.yellow,Color.gray);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		turnRadarRight(360);
		addCustomEvent(new RadarTurnCompleteCondition(this));
		while(true) {
			setAhead(40000);
			setTurnRight(90);
			
			double sign = -1;
			do
			{
				execute();
			 	while (getTurnRemaining() != 0) {
					execute();
					correctDirection();
				}
				setTurnRight(180 * sign);
				sign = -sign;
			}while(true);
		}
	}
	
	public void onCustomEvent(CustomEvent e)
	{
		setTurnRadarRight(360);
		ProcessTargets();
	}
	
	private void ProcessTargets()
	{
		if (targets.size() == 0)
			return;
		C c1 = null;
		for(int i = 0; i < targets.size(); i++)
		{
			C c = (C)targets.elementAt(i);
			if (c1 == null || c.distance < c1.distance)
			{
				c1 = c;
			}
		}
		onScannedRobot1(c1);
		targets.clear();
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		C c = new C();
		c.distance = e.getDistance();
		c.velocity = e.getVelocity();
		c.targetheading = e.getHeadingRadians();
		c.time = e.getTime();
		double targetAngle = e.getBearingRadians() + getHeadingRadians(); // direction to target (absolute)
		c.x = getX() + c.distance * Math.sin(targetAngle);
		c.y = getY() + c.distance * Math.cos(targetAngle);
		targets.add(c);
		scan();
	}
	public void onScannedRobot1(C c) {
		if (getEnergy() < 10 || getGunHeat() != 0 || c.distance > 700)
			return;
						
		double myheading = getHeadingRadians();
		// add velocity * time
		long time = getTime();
		double pred_dist = c.velocity * (time - c.time);
		c.x += Math.sin(c.targetheading) * pred_dist;
		c.y += Math.cos(c.targetheading) * pred_dist;

		double dX = c.x - getX();
		double dY = c.y - getY();
		double targetAngle = Math.atan2(dX, dY);

		double power = (c.distance < 300) ? 3 : 1;
		double beta_angle = c.targetheading - targetAngle;
		double angle_corr = c.velocity / getBulletSpeed(power) * Math.sin(beta_angle);
			
		setGunHeadingRadians(targetAngle + angle_corr);
		fire(power);
	}

	private void setGunHeadingRadians(double heading)
	{
		heading = robocode.util.Utils.normalAbsoluteAngle(heading);
		turnGunRightRadians(robocode.util.Utils.normalRelativeAngle(heading - getGunHeadingRadians()));
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
/*	public void onHitByBullet(HitByBulletEvent e) {
	}
*/	
/*	public void onWin(WinEvent e) {
		for (int i = 0; i < 15; i++)
		{
			turnLeft(40);
			turnRight(40);
		}
	}
*/	public void onHitRobot(HitRobotEvent e)
	{
		double botheading = e.getBearingRadians() + getHeadingRadians();
		setGunHeadingRadians(botheading);
		fire(3);
		
		reverseDirection();	
	}
	public void onHitWall(HitWallEvent e)
	{
		reverseDirection();
	}
}
