package uccc;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class CircularTargetingGun {
	AdvancedRobot robot;

	CircularIntercept intercept = new CircularIntercept();
	double radarTurn = 0;
	double ourRobotPositionX = 0;
	double ourRobotPositionY = 0;
	double currentTargetPositionX = 0;
	double currentTargetPositionY = 0;
	double curentTargetHeading_deg = 0;
	double currentTargetVelocity = 0;
	double bulletPower = 0;

	public CircularTargetingGun(AdvancedRobot robot) {
		this.robot = robot;
	}

	void doGunStuff() {
		intercept.calculate(ourRobotPositionX, ourRobotPositionY,
				currentTargetPositionX, currentTargetPositionY,
				curentTargetHeading_deg, currentTargetVelocity, bulletPower, 0 // Angular
				// velocity
				);

		// Helper function that converts any angle into
		// an angle between +180 and -180 degrees.
		double turnAngle = Math.toDegrees(robocode.util.Utils
				.normalRelativeAngle(Math.toRadians(intercept.bulletHeading_deg
						- robot.getGunHeading())));

		// Move gun to target angle
		robot.setTurnGunRight(turnAngle);

		if (Math.abs(turnAngle) <= intercept.angleThreshold) {
			// Ensure that the gun is pointing at the correct angle
			/*
			 * Actually, we don't care... if ((intercept.impactPoint.x > 0) &&
			 * (intercept.impactPoint.x < robot.getBattleFieldWidth()) &&
			 * (intercept.impactPoint.y > 0) && (intercept.impactPoint.y <
			 * robot.getBattleFieldHeight())) { // Ensure that the predicted
			 * impact point is within // the battlefield
			 */
			robot.setFire(bulletPower);
			//
		}
		robot.execute();
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		radarTurn = robot.getHeadingRadians() + e.getBearingRadians()
				- robot.getRadarHeadingRadians();
		robot.setTurnRadarRightRadians(2.0 * Utils
				.normalRelativeAngle(radarTurn));

		ourRobotPositionX = robot.getX();
		ourRobotPositionY = robot.getY();
		currentTargetPositionX = (robot.getX() + (Math.sin(robot
				.getHeadingRadians()
				+ e.getBearingRadians()) * e.getDistance()));
		currentTargetPositionY = (robot.getY() + (Math.cos(robot
				.getHeadingRadians()
				+ e.getBearingRadians()) * e.getDistance()));
		curentTargetHeading_deg = e.getHeading();
		currentTargetVelocity = e.getVelocity();
		bulletPower = 1;

	}

}
