package SHAM;

import robocode.*;
import robocode.util.Utils;

import java.awt.*;
import java.awt.geom.*;
import java.*;


/**
 * SHAM.WOW created by Steven Hatton and Aditya Majumdar
 * Period 3, JAVA Programming
 * Due: 06/05/09
 * Robocode, JAVA, Second Semester Final Project
 * 
 * Pattern Matching Class, implemented with pluggable framework
 * Will search through a large string to find a "pattern" of previous movements and robot history.
 * Based on that history, we will decide where to shoot.
 */
public class PM
{
    private AdvancedRobot _robot;

    public PM( AdvancedRobot robot )
    {
        _robot = robot;
    }

    private AdvancedEnemyBot enemy = new AdvancedEnemyBot();

    //this large string is part of the symbolic pattern matching algorithm
    //essentially, we store previous information of past turns of the enemies
    
    public static String enemyHistory = "" + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)2
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)-1
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0
        + (char)0 + (char)-2 + (char)-4 + (char)-6 + (char)-8 + (char)-8
        + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8
        + (char)-7 + (char)-6 + (char)-5 + (char)-4 + (char)-3 + (char)-2
        + (char)-1 + (char)0 + (char)2 + (char)4 + (char)6 + (char)8 + (char)8
        + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8
        + (char)8 + (char)8 + (char)8 + (char)8 + (char)7 + (char)6 + (char)5
        + (char)4 + (char)3 + (char)2 + (char)1 + (char)0 + (char)125
        + (char)125 + (char)125 + (char)125 + (char)75 + (char)125 + (char)125
        + (char)45 + (char)125 + (char)125 + (char)125 + (char)125 + (char)75
        + (char)125 + (char)125 + (char)45 + (char)125 + (char)125 + (char)125
        + (char)125 + (char)75 + (char)125 + (char)125 + (char)45 + (char)125
        + (char)125 + (char)125 + (char)125 + (char)75 + (char)125 + (char)125
        + (char)45 + (char)125 + (char)125 + (char)125 + (char)125 + (char)75
        + (char)125 + (char)125 + (char)45 + (char)125 + (char)125 + (char)125
        + (char)125 + (char)75 + (char)125 + (char)125 + (char)45 + (char)125
        + (char)125 + (char)125 + (char)125 + (char)75 + (char)125 + (char)125
        + (char)45 + (char)125 + (char)125 + (char)125 + (char)125 + (char)75
        + (char)125 + (char)125 + (char)45

        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-65 + (char)65
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-65 + (char)65
        + (char)-45 + (char)45 + (char)-75 + (char)75 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-75 + (char)75
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-65 + (char)65
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-75 + (char)75
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-75 + (char)75 + (char)-45 + (char)45

        + (char)-65 + (char)-65 + (char)-45 + (char)-45 + (char)-75 + (char)-75
        + (char)-45 + (char)-45 + (char)-65 + (char)-65 + (char)-45 + (char)-45
        + (char)-75 + (char)-75 + (char)-45 + (char)-45 + (char)-65 + (char)-65
        + (char)-45 + (char)-45 + (char)-75 + (char)-75 + (char)-45 + (char)-45
        + (char)-65 + (char)-65 + (char)-45 + (char)-45 + (char)-75 + (char)-75
        + (char)-45 + (char)-45 + (char)-65 + (char)-65 + (char)-45 + (char)-45
        + (char)-75 + (char)-75 + (char)-45 + (char)-45 + (char)-65 + (char)-65
        + (char)-45 + (char)-45 + (char)-75 + (char)-75 + (char)-45 + (char)-45
        + (char)-65 + (char)-65 + (char)-45 + (char)-45 + (char)-75 + (char)-75
        + (char)-45 + (char)-45 + (char)-65 + (char)-65 + (char)-45 + (char)-45
        + (char)-75 + (char)-75 + (char)-45 + (char)-45

        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-65 + (char)65
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-65 + (char)65
        + (char)-45 + (char)45 + (char)-75 + (char)75 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-75 + (char)75
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-65 + (char)65
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-65 + (char)65 + (char)-45 + (char)45 + (char)-75 + (char)75
        + (char)-45 + (char)45 + (char)-65 + (char)65 + (char)-45 + (char)45
        + (char)-75 + (char)75 + (char)-45 + (char)45;

    private final static double PREFERRED_RANGE = 170.0;

    private final static double BULLET_POWER = 3.0D;

    private final static double BULLET_SPEED = 20.0 - 3 * BULLET_POWER;

    private final static double DISTANCE_DIVISOR = PREFERRED_RANGE;

    private final static int MAX_MATCH_LEN = 30;

    private final static int PREDICT_TICKS = (int)( DISTANCE_DIVISOR / BULLET_SPEED );


    // start gun
    public void run()
    {
    }


    public void onScannedRobot( ScannedRobotEvent e )
    {
        // ------pattern matching code
        // register variables
        
        //how many characters to look for in the string when searching for pattern history
        int length = MAX_MATCH_LEN; 
        
        double relativeEnemyBearing = e.getBearingRadians();
        
        int matchPos;

        //direction in relating to enemy
        double absoluteBearing = _robot.getHeadingRadians()+ e.getBearingRadians();
        
        // relativeEnemyBearing represents the bearing in relation to the bot
        relativeEnemyBearing += _robot.getHeadingRadians();

        // pattern gun from WeekendObsession credited to Eric Simonton - Thank you!
        
        //add last enemy move to the pattern
        //assigns a value of the velocity and heading of the enemy robot
        //converts that into a character to be added to our huge string of history 
        //is added to the string with the 'concat' command
        enemyHistory = String.valueOf( (char)( e.getVelocity() * ( Math.sin( e.getHeadingRadians()
            - relativeEnemyBearing ) ) ) )
            .concat( enemyHistory );

        // search for a match based on previous history in the string
        //looks thru a specified region in the string history for a match
        while ((matchPos = enemyHistory.indexOf(enemyHistory.substring( 0,length-- ),PREDICT_TICKS))<0)
            ;

        // calculate aim offset - how much longer should it take for bullet to get to enemy?
        length = PREDICT_TICKS;
        do
        {
            //changing into the short will give you a certain direction based on pattern history
            //if so, and with the aim offset, it should be fairly effective in predicting the next
            //location of the enemy bot
            relativeEnemyBearing += ( (short)enemyHistory.charAt( --matchPos ) )
                / DISTANCE_DIVISOR;
        }
        //checks for length afterwards, would continue to check
        while ( --length > 0 );

        // turn gun in shortest direction
        _robot.setTurnGunRightRadians( Utils.normalRelativeAngle( relativeEnemyBearing
            - _robot.getGunHeadingRadians() ) );

        // setTurnRightRadians( e.getBearingRadians() + .5 * Math.PI );

        // fires the gun when possible
        // sets firepower based on distance from target robot
        double firepower = Math.min( 500 / enemy.getDistance(), 3 );
        
        //if getting close to robot, and gun is completely cooled, the gun will fire
        if ( _robot.getGunHeat() == 0 && _robot.getGunTurnRemaining() <= 3 )
        {
            _robot.setFire( firepower );

        }
        else
        {
            if ( enemy.none() || e.getDistance() < enemy.getDistance() - 70
                || e.getName().equals( enemy.getName() ) )
            {
                enemy.update( e, this._robot );
            }
        }
    }

    double absoluteBearing( double x1, double y1, double x2, double y2 )
    {
        return Math.toDegrees( Math.atan2( x2 - x1, y2 - y1 ) );
    }


    double normalizeBearingDegrees( double angle )
    {
        while ( angle > 180 )
            angle -= 360;
        while ( angle < -180 )
            angle += 360;
        return angle;
    }

    public void onHitByBullet( HitByBulletEvent e )
    {
    }
}