package sch;

/**
 * Tracks all statistics about an intercept method
 */
public class InterceptStats implements Constants, Comparable {

	private double hits;
	private double shots;
	private double totHits;
	private double totShots;
	private Intercept intercept;
	private double goodness;

	public InterceptStats(Intercept intercept) {
		hits=0;
		shots=0;
		this.totHits=0;
		this.totShots=0;
		this.intercept=intercept;
	}

	public Intercept getIntercept() {
		return this.intercept;
	}

	public double getHits() {return hits;}

	public double getShots() {return shots;}

	public double getHitRatio()  {return (hits/shots)*100;}

	public void incrementHits() {hits++;}

	public void incrementShots() {shots++;}	

	public double getTotHits() {return totHits;}

	public double getTotShots() {return totShots;}

	public double getTotHitRatio()  {return (totHits/totShots)*100;}
	
	
	public double getGlobalHits() {return totHits+hits;}

	public double getGlobalShots() {return totShots+shots;}

	public double getGlobalHitRatio()  {return (getGlobalHits()/getGlobalShots())*100;}
	
	

	public void incrementTotHits() {totHits++;}

	public void incrementTotShots() {totShots++;}

	public void incrementAllHits() {totHits++;hits++;}

	public void incrementAllShots() {totShots++;shots++;}

	public void reset() {
		hits=0;
		shots=0;
	}

	public void setTotHits(double totHits) {
		this.totHits=totHits;
	}

	public void setTotShots(double totShots) {
		this.totShots=totShots;
	}

	public int compareTo(Object o) {
		InterceptStats is=(InterceptStats) o;

		if (getGlobalHitRatio()>is.getGlobalHitRatio())
			return -1;
		else if (getGlobalHitRatio()<is.getGlobalHitRatio())
			return 1;
		else
			if (getGlobalShots()>is.getGlobalShots())
				return -1;
			else if (getGlobalShots()<is.getGlobalShots())
				return 1;
			else
				if (getIntercept().getComplexity()<is.getIntercept().getComplexity())
					return -1;
				else if (getIntercept().getComplexity()>is.getIntercept().getComplexity())
					return 1;
				else
					return 0;

	}
}