package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;

public class SurfBufferV  extends SurfBuffer {
	private static double[][][][] surfStats = new double[BasicWaveSurfer.SEG_ACCEL][BasicWaveSurfer.SEG_WALL_PROXIMITY][BasicWaveSurfer.SEG_BULLET_POWER][BasicWaveSurfer.BINS];
	public SurfBufferV(int weight) {
		super(weight);
	}
	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegAccel(),wave.getSegWallProximity(),wave.getSegBulletPower()));
	}
	
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 3)
			throw new IllegalArgumentException("args length must be 3");
		return new SegmentedBuffer(surfStats[args[0]][args[1]][args[2]], this.getWeight());
	}

}
