package pl.Abstract;

/*******************************************************************************
 * An abstract class for strategies.
 * <p />
 * Inside are the usual Event methods used in Robocode. In keeping with
 * polymorphism, it is recommended that, in the robot proper, to delegate all
 * events to a static Strategy.
 * <p />
 * Example:
 * 
 * <pre>
 * static Strategy strategy;
 * 
 * public void run() {
 * 	strategy = new ClassThatExtendsStrategy();
 * 	strategy.run();
 * }
 * 
 * public void onScannedRobot(ScannedRobotEvent e) {
 * 	strategy.onScannedRobot(e);
 * }
 * </pre>
 * 
 * A class extending Strategy can override these methods if necessary. Extending
 * Strategies should be made as inner classes of the robot using Strategies.
 * Strategies should be written such that they can be taken out of the Strategy
 * and into a robot and work perfectly.
 ******************************************************************************/
public abstract class Strategy {

	/**
	 * The AdvancedRobot that uses this strategy. All actions done by Strategies
	 * will call it through this variable.
	 */
	public robocode.AdvancedRobot robot;

	/**
	 * Constructor with an AdvancedRobot
	 * 
	 * @param r AdvancedRobot using the Strategy
	 */
	public Strategy(robocode.AdvancedRobot robot) {
		this.robot = robot;
	}

	/**
	 * This run method should be called inside the robot's run() method. It must
	 * be overridden by any Strategy.
	 */
	public abstract void run();

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e ScannedRobotEvent
	 */
	public void onScannedRobot(robocode.ScannedRobotEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e HitByBulletEvent
	 */
	public void onHitByBullet(robocode.HitByBulletEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e HitRobotEvent
	 */
	public void onHitRobot(robocode.HitRobotEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e HitWallEvent
	 */
	public void onHitWall(robocode.HitWallEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e WinEvent
	 */
	public void onWin(robocode.WinEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e DeathEvent
	 */
	public void onDeath(robocode.DeathEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e BulletHitEvent
	 */
	public void onBulletHit(robocode.BulletHitEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e BulletMissedEvent
	 */
	public void onBulletMissed(robocode.BulletMissedEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e BulletHitBulletEvent
	 */
	public void onBulletHitBullet(robocode.BulletHitBulletEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e RobotDeathEvent
	 */
	public void onRobotDeath(robocode.RobotDeathEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param e CustomEvent
	 */
	public void onCustomEvent(robocode.CustomEvent e) {
	}

	/**
	 * This method should be called by the corresponding method of the robot.
	 * 
	 * It should be overwritten by the extending Strategy if necessary.
	 * 
	 * @param g Graphics2D
	 */
	public void onPaint(java.awt.Graphics2D g) {
	}
}