//--------------------------------------------------------------------------
// $Id: Position.java,v 1.1 2003/08/29 09:18:58 erning Exp $
//--------------------------------------------------------------------------
// Copyright (c) 2000-2003 Dragon Software Corp. All rights reserved.
//
// Please refer to COPYRIGHT for notices regarding the confidential
// and proprietary nature of this source code.
//--------------------------------------------------------------------------

package net.dragonsoft.robocoding.util;

public class Position implements Cloneable
{
    public Position(double x, double y)
    {
        this.x = x;
        this.y = y;
    }

    public int hashCode()
    {
        return super.hashCode();
    }

    public boolean equals(Object obj)
    {
        if (obj instanceof Position)
        {
            Position p = (Position)obj;
            return (p.x == x && p.y == y);
        }
        else
        {
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException
    {
        return new Position(x, y);
    }

    public String toString()
    {
        return "(" + Math.round(x) + "," + Math.round(y) + ")";
    }

    // calculate the distance between tow position

    public static double calcDistance(double x1, double y1, double x2, double y2)
    {
        double w = Math.abs(x1 - x2);
        double h = Math.abs(y1 - y2);
        return Math.sqrt(w*w + h*h);
    }

    public double calcDistance(double x, double y)
    {
        return calcDistance(this.x, this.y, x, y);
    }

    public double calcDistance(Position p)
    {
        return calcDistance(this.x, this.y, p.x, p.y);
    }

    // calculate the angle of two position

    public static double calcAngle(double x1, double y1, double x2, double y2)
    {
        double angle = Math.atan2(x2 - x1, y2 - y1);
        return robocode.util.Utils.normalAbsoluteAngle(angle);
    }

    public static double calcAngle(Position p1, Position p2)
    {
        return calcAngle(p1.x, p1.y, p2.x, p2.y);
    }

    public double calcAngle(Position p)
    {
        return calcAngle(x, y, p.x, p.y);
    }

    public double calcAngle(double x, double y)
    {
        return calcAngle(this.x, this.y, x, y);
    }

    // calculate another position by current position, angle and the distance

    public static Position calcPosition(double x, double y, double angle, double distance)
    {
        return new Position(
            x + Math.sin(angle) * distance,
            y + Math.cos(angle) * distance);
    }

    public static Position calcPosition(Position p, double angle, double distance)
    {
        return calcPosition(p.x, p.y, angle, distance);
    }

    public Position calcPosition(double angle, double distance)
    {
        return calcPosition(x, y, angle, distance);
    }

    public double x;
    public double y;
}
