package zyx.debug.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.LinkedList;

import zyx.mega.geometry.Circle;
import zyx.mega.geometry.Point;

public class Painter {
  private static LinkedList<IPaintable> paints_ = new LinkedList<IPaintable>();
  private static LinkedList<Color> colors_ = new LinkedList<Color>();
  public static void onPaint(Graphics2D g) {
    if ( g != null ) {
      Iterator<IPaintable> it1 = paints_.iterator();
      Iterator<Color> it2 = colors_.iterator();
      while ( it1.hasNext() ) {
        g.setColor(it2.next());
        it1.next().onPaint(g);
      }
    }
    paints_.clear();
    colors_.clear();
  }
  public static void Add(Point point, double radius, Color color) {
    paints_.add(new Circle(point, radius));
    colors_.add(color);
  }
  public static void Add(IPaintable paint, Color color) {
    paints_.add(paint);
    colors_.add(color);
  }
}
