package zyx.mega.bot;

import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.*;
import static java.lang.Math.abs;
import static robocode.util.Utils.normalAbsoluteAngle;
import static robocode.util.Utils.normalRelativeAngle;
import static zyx.mega.geometry.Geometry.AngleDifference;
import static zyx.mega.geometry.Geometry.HALF_PI;
import static zyx.mega.geometry.Geometry.PI_18;
import static zyx.mega.geometry.Geometry.PI_240;
import static zyx.mega.utils.Range.CapCentered;
import static zyx.mega.utils.Range.CapHigh;
import static zyx.mega.utils.Range.CapLow;
import static zyx.mega.utils.TurnHandler.*;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;

import robocode.AdvancedRobot;
import static robocode.Rules.*;
import zyx.debug.Printer;
import zyx.mega.geometry.BoundingSquare;
import zyx.mega.geometry.Circle;
import zyx.mega.geometry.Geometry;
import zyx.mega.geometry.Point;
import zyx.mega.geometry.Rectangle;
import zyx.mega.utils.Range;
import zyx.mega.utils.Snapshot;
import zyx.mega.utils.TurnHandler;

public class Bot extends Point {
  private static final double WALL = 18;
  private static final double SMOOTH_WALL = 22;
  private static final double WALL_STICK = 180;
  public static double WIDTH;
  public static double HEIGHT;

  //public static Bot me_;
  public static Rectangle smooth_field_;
  public static Rectangle field_;
  //public static AdvancedRobot robot_;
  public static Point center_;

  public static void InitStatic() {
    //me_ = TurnHandler.me_;
    //robot_ = TurnHandler.robot_;
    WIDTH = robot_.getBattleFieldWidth();
    HEIGHT = robot_.getBattleFieldHeight();
    center_ = new Point(WIDTH / 2, HEIGHT / 2);
    smooth_field_ = new Rectangle(SMOOTH_WALL, SMOOTH_WALL, WIDTH - SMOOTH_WALL * 2, HEIGHT - SMOOTH_WALL * 2);
    field_ = new Rectangle(WALL, WALL, WIDTH - WALL * 2, HEIGHT - WALL * 2);
  }
  
  public void onPaint(Graphics2D g) {
    bbox_.onPaint(g);
  }

  /* Basic Values */
  public double energy_;
  public double heading_;
  public double velocity_;
  public double gun_heat_;
  
  /* Relative to Time */
  public int acceleration_;
  public double rotation_;
  public int time_running_;
  public int time_stopped_;
  public int time_direction_;
  
  /* Relative to Enemy */
  public double bearing_;
  public double lateral_velocity_;
  public int direction_;
  public double approaching_velocity_;
  
  /* Position */
  public BoundingSquare bbox_;
  public int ahead_ticks_;
  public int back_ticks_;
  
  public Bot() {
    energy_ = 100;
    gun_heat_ = 3;
    bbox_ = new BoundingSquare(this, 18);
    time_running_ = time_stopped_ = time_direction_ = 0;
  }
  public Bot(Bot bot) {
    super(bot);
    energy_ = bot.energy_;
    heading_ = bot.heading_;
    velocity_ = bot.velocity_;
    gun_heat_ = bot.gun_heat_;
    acceleration_ = bot.acceleration_;
    rotation_ = bot.rotation_;
    bearing_ = bot.bearing_;
    lateral_velocity_ = bot.lateral_velocity_;
    direction_ = bot.direction_;
    ahead_ticks_ = bot.ahead_ticks_;
    back_ticks_ = bot.back_ticks_;
    bbox_ = new BoundingSquare(this, 18);
  }
  public void Update(AdvancedRobot robot) {
    x_ = robot.getX();
    y_ = robot.getY();
    energy_ = robot.getEnergy();
    heading_ = robot.getHeadingRadians();
    velocity_ = robot.getVelocity();
    gun_heat_ = robot.getGunHeat();
    //Printer.printf(0, "up: %.5f %.5f\n", heading_, robot_.getGunHeadingRadians());
    FinishUpdate();
  }
  protected void FinishUpdate() {
    bbox_.Update();
    UpdateWallDistance();
  }
  private void UpdateWallDistance() {
    Bot ahead = new Bot(this);
    Bot back = new Bot(this);
    double ahead_angle = heading_;
    double back_angle = heading_ + PI;
    if ( velocity_ < 0 ) {
      ahead_angle = back_angle;
      back_angle = heading_;
    }
    ahead_ticks_ = 0;
    back_ticks_ = 0;
    boolean ahead_done = false;
    boolean back_done = false;
    for ( int t = 0; t <= Snapshot.MAX_WALL_DISTANCE && (!ahead_done || !back_done); ++t ) {
      if ( !ahead_done ) {
        ++ahead_ticks_;
        ahead.MoveBot(ahead_angle, false);
        ahead_done = !field_.Inside(ahead, false);
      }
      if ( !back_done ) {
        ++back_ticks_;
        back.MoveBot(back_angle, false);
        back_done = !field_.Inside(back, false);
      }
    }
    /*
    if ( this != me_ ) {
      Printer.printf(0, "(%.2f %.2f) %.2f [%.2f, %.2f] -> %d\n",
          velocity_, ahead.velocity_,
          Distance(this, ahead), ahead.x_, ahead.y_, ahead_ticks_);
      Printer.printf(0, "(%.2f %.2f) %.2f [%.2f, %.2f] -> %d\n", 
          velocity_, back.velocity_,
          Distance(this, back), back.x_, back.y_, back_ticks_);
      Painter.Add(0, new Line(this, ahead_angle, Distance(this, ahead)));
      Painter.Add(0, ahead);
      Painter.Add(0, back);
    }
    */
  }
  public static Bot CloneMe() {
    return new Bot(me_);
  }
  public void UpdateInTime(Bot bot, long elapsed) {
    if ( abs(velocity_ - bot.velocity_) < 1e-9 ) {
      acceleration_ = 0;
      if ( abs(velocity_) < 1 ) {
        ++time_stopped_;
        time_running_ = 0;
      } else {
        time_stopped_ = 0;
        ++time_running_;
      }
    } else if ( abs(velocity_) < abs(bot.velocity_) ) {
      acceleration_ = -2;
      time_stopped_ = time_running_ = 0;
    } else {
      acceleration_ = 1;
      time_stopped_ = 0;
      ++time_running_;
    }
    if ( acceleration_ == -2 ) time_direction_ = 0;
    else ++time_direction_;
    rotation_ = normalRelativeAngle(heading_ - bot.heading_) / elapsed;
    if ( velocity_ < 0 ) rotation_ = -rotation_;
    //else if ( velocity_ == 0 && bot.velocity_ < 0 ) rotation_ = -rotation_;
    if ( rotation_ + 1e-9  < -PI_18 || rotation_ - 1e-9  > PI_18 ) {
      Printer.printf(0, "rot (%d): %.10f NOT in [+-%.10f] (%d)\n", time_, rotation_, PI_18, elapsed);
      /**
      Printer.onPrint(robot_.out);
      ((Bot)null).acceleration_ = 0;
      /**/
    }
  }
  public void UpdateToEnemy(Enemy enemy) {
    bearing_ = enemy.bearing_ + PI;
    direction_ = enemy.my_direction_;
    lateral_velocity_ = enemy.my_lateral_velocity_;
    approaching_velocity_ = enemy.my_approaching_velocity_;
  }
  public void Orbit(Point center, int direction, boolean stop) {
    double angle = OrbitAngle(center, direction);
    MoveBot(angle, stop);
  }
  public void OrbitSimple(Point center, int direction, boolean try_approach) {
    double angle = OrbitAngleSimple(center, direction, try_approach);
    MoveBot(angle, false);
  }
  public void MoveBot(double angle, boolean stop) {
    double turn = normalRelativeAngle(angle - heading_);
    int direction = 1;
    if ( abs(turn) > HALF_PI ) {
      direction = -1;
      turn = normalRelativeAngle(turn + PI);
    }
    turn = CapCentered(turn, MaxTurn());
    if ( stop ) {
      if ( velocity_ == 0 ) return;
      if ( velocity_ < 0 ) velocity_ = CapHigh(velocity_ + 2, 0);
      else velocity_ = CapLow(velocity_ - 2, 0);
    } else {
      velocity_ = CapCentered(velocity_ + (velocity_ * direction < 0 ? 2 : 1) * direction, MAX_VELOCITY);
    }
    heading_ = normalAbsoluteAngle(heading_ + turn);
    MovePoint(heading_, velocity_);
    bbox_.Update();
  }
  private double MaxTurn() {
    return PI_18 - PI_240 * abs(velocity_);
  }
  public double OrbitAngle(Point center, int direction) {
    double p = 0.485;
    double distance = this.distance(center);
    if ( distance < 150 ) p = 0.2;
    else if ( distance < 200 ) p = 0.30;
    else if ( distance < 250 ) p = 0.35;
    else if ( distance < 300 ) p = 0.40;
    else if ( distance < 350 ) p = 0.45;
    else if ( distance > 800 ) p = 0.85;
    else if ( distance > 700 ) p = 0.75;
    else if ( distance > 600 ) p = 0.65;
    else if ( distance > 450 ) p = 0.55;
    return Smooth(center, center.Angle(this) + direction * p * PI);
  }
  public double OrbitAngleSimple(Point center, int direction, boolean try_approach) {
    double p = try_approach ? 0.51 : 0.45;
    return Smooth(center, center.Angle(this) + direction * p * PI);
  }
  public double Smooth(Point center, double angle) {
    //Painter.Add(0, field_);
    if ( smooth_field_.Inside(new Point(this, angle, WALL_STICK), true) ) return angle;
    angle = normalRelativeAngle(angle);
    double smooth_angle = angle;
    double best_error = POSITIVE_INFINITY;
    double best_error2 = POSITIVE_INFINITY;
    Circle shield = new Circle(this, WALL_STICK);
    for ( Point point : shield.Intersection(smooth_field_) ) {
      double pangle = Angle(point);
      double error = AngleDifference(pangle, angle);
      double error2 = point.distance(center);
      //robot_.out.printf("point: %.4f %.4f\n", pangle, error);
      if ( error < best_error || (abs(error - best_error) < 1e-5 && error2 < best_error2) ) {
        best_error = error;
        best_error2 = error2;
        smooth_angle = pangle;
      }
    }
    //robot_.out.printf("smooth: %.4f %.4f\n", normalRelativeAngle(angle), normalRelativeAngle(smooth_angle));
    return smooth_angle;
  }
/*
  public static Bot NextMe() {
    Bot next_me = new Bot(me_);
    int direction = (int)signum(robot_.getDistanceRemaining());
    if ( direction == 0 ) direction = (int)signum(-next_me.velocity_);
    next_me.heading_ = normalAbsoluteAngle(next_me.heading_ +
        CapCentered(robot_.getTurnRemainingRadians(), next_me.MaxTurn()));
    next_me.velocity_ = CapCentered(next_me.velocity_ +
        (next_me.velocity_ * direction < 0 ? -2 : 1) * direction, MAX_VELOCITY);
    next_me.MovePoint(next_me.heading_, next_me.velocity_);
    return next_me;
  }
*/
  public static double NextTurn() {
    return CapCentered(robot_.getTurnRemainingRadians(), me_.MaxTurn());
  }

  public Range CornersAngleWindow(Point bot) {
    Range window = new Range();
    for ( double x : new double[] { bot.x_ - 18, bot.x_ + 18 } ) for ( double y : new double[] { bot.y_ - 18, bot.y_ + 18 } ) {
      window.Update(Bearing(x, y));
    }
    return window;
  }

  private double Bearing(double x, double y) {
    return atan2(x - x_, y - y_);
  }
  public Bot LinearPrediction(Point source, int start_time, int fire_time, double power) {
    Bot prediction = new Bot(this);
    double dx = sin(heading_) * velocity_;
    double dy = cos(heading_) * velocity_;
    double velocity = getBulletSpeed(power);
    double radius = -fire_time * velocity;
    for ( int t = start_time; source.distanceSq(prediction) > radius * radius; ++t ) {
      if ( t >= fire_time ) radius += velocity;
      prediction.x_ += dx;
      prediction.y_ += dy;
      if ( field_.ForceInside(prediction, true) ) break;
    }
    return prediction;
  }
  public Bot CircularPrediction(Point source, int start_time, int fire_time, double power) {
    Bot prediction = new Bot(this);
    double velocity = getBulletSpeed(power);
    double radius = -fire_time * velocity;
    for ( int t = start_time; source.distanceSq(prediction) > radius * radius; ++t ) {
      //if ( t >= fire_time ) prediction.MoveBot(prediction.heading_, false);
      if ( t >= fire_time ) radius += velocity;
      prediction.heading_ = normalRelativeAngle(prediction.heading_ + prediction.rotation_);
      prediction.x_ += sin(prediction.heading_) * velocity_;
      prediction.y_ += cos(prediction.heading_) * velocity_;
      if ( field_.ForceInside(prediction, true) ) break;
    }
    return prediction;
  }
  public Bot LinearPredictionMaxSpeed(Point source, int start_time, int fire_time, double power) {
    Bot prediction = new Bot(this);
    double velocity = getBulletSpeed(power);
    double radius = -fire_time * velocity;
    for ( int t = start_time; source.distanceSq(prediction) > radius * radius; ++t ) {
      if ( t >= fire_time ) radius += velocity;
      prediction.MoveBot(prediction.heading_, false); 
      if ( field_.ForceInside(prediction, true) ) break;
    }
    return prediction;
  }
  public Bot CircularPredictionMaxSpeed(Point source, int start_time, int fire_time, double power) {
    Bot prediction = new Bot(this);
    double velocity = getBulletSpeed(power);
    double radius = -fire_time * velocity;
    for ( int t = start_time; source.distanceSq(prediction) > radius * radius; ++t ) {
      if ( t >= fire_time ) radius += velocity;
      prediction.MoveBot(prediction.heading_ + rotation_, false); 
      if ( field_.ForceInside(prediction, true) ) break;
    }
    return prediction;
  }
  public static Bot NextMe() {
    Bot bot = new Bot(me_);
    bot.heading_ = bot.heading_ + CapCentered(robot_.getTurnRemainingRadians(), bot.MaxTurn());
    if ( robot_.getDistanceRemaining() == 0 ) {
      if ( bot.velocity_ < 0 ) bot.velocity_ = CapHigh(bot.velocity_ + 2, 0);
      else if ( bot.velocity_ > 0 ) bot.velocity_ = CapLow(bot.velocity_ - 2, 0);
    } else {
      double move_dir = signum(robot_.getDistanceRemaining());
      int acceleration = (bot.velocity_ * move_dir) < 0 ? 2 : 1;
      bot.velocity_ = CapCentered(bot.velocity_ + acceleration * move_dir, 8);
    }
    bot.MovePoint(bot.heading_, bot.velocity_);
    return bot;
  }
}
