/*
 * Created on 24-oct-2004
 * 
 * $Id: MovimientoEsquivaBalas.java,v 1.1.2.5 2004/10/26 11:13:12 lolo Exp $
 */
package mnt.utils;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

public class MovimientoEsquivaBalas implements ControlDeMovimiento {

    public static final double MOVIMIENTO = 600;

    public static final double MARGEN_PARED = 60;

    private static Line2D paredIz;

    private static Line2D paredDer;

    private static Line2D paredAr;

    private static Line2D paredAb;

    private static Rectangle2D campoBatalla;

    private Enemigo objetivo;

    private AdvancedRobot miRobot;

    private double direccion = 1;

    private double potenciaBala = 0;

    private double tiempoDeLlegada = 0;

    private double tiempoCercaPared = 0;

    public MovimientoEsquivaBalas(AdvancedRobot robot) {
        miRobot = robot;
        campoBatalla = new Rectangle2D.Double(MARGEN_PARED, MARGEN_PARED, robot
                .getBattleFieldWidth()
                - 2 * MARGEN_PARED, robot.getBattleFieldHeight() - 2
                * MARGEN_PARED);
        paredIz = new Line2D.Double(0, 0, 0, robot.getBattleFieldHeight());
        paredDer = new Line2D.Double(robot.getBattleFieldWidth(), 0, robot
                .getBattleFieldWidth(), robot.getBattleFieldHeight());
        paredAr = new Line2D.Double(0, robot.getBattleFieldHeight(), robot
                .getBattleFieldWidth(), robot.getBattleFieldHeight());
        paredAb = new Line2D.Double(0, 0, robot.getBattleFieldWidth(), 0);
    }

    /*
     * (non-Javadoc)
     * 
     * @see mnt.utils.ControlDeMovimiento#hacerMovimiento()
     */
    public void hacerMovimiento() {
        if (objetivo != null) {
            double angulo = Utils.normalRelativeAngle(objetivo
                    .getBearingRadians()
                    + Math.PI / 2);
            Point2D.Double miPos = new Point2D.Double(miRobot.getX(), miRobot
                    .getY());
            boolean cercaPared = false;
            if (cercaPared(paredIz, miPos) || cercaPared(paredDer, miPos)
                    || cercaPared(paredAr, miPos) || cercaPared(paredAb, miPos))
                cercaPared = true;

            miRobot.setTurnRightRadians(angulo);

            if (cercaPared) {
                if (tiempoCercaPared > 15) {
                    direccion *= -1;
                    tiempoCercaPared = 0;
                }
                miRobot.setAhead(direccion * -0.5 * MOVIMIENTO);
                tiempoCercaPared++;
            } else if (--tiempoDeLlegada < 8 * Math.random()
                    && potenciaBala >= 0.1 && potenciaBala <= 3) {
                tiempoCercaPared = 0;
                tiempoDeLlegada = objetivo.getDistance() / 20;
                double distancia;
                direccion = Math.random() - 0.5;
                distancia = direccion * MOVIMIENTO;

                miRobot.setAhead(distancia);
            }
        }
    }

    private boolean cercaPared(Line2D pared, Point2D miPos) {
        return pared.ptLineDist(miPos) < MARGEN_PARED;
    }

    private int turnTo(double angulo) {
        angulo = Utils
                .normalRelativeAngle(angulo - miRobot.getHeadingRadians());
        int dir = 1;
        if (angulo > Math.PI / 2) {
            angulo -= Math.PI;
            dir = -1;
        } else if (angulo < -Math.PI / 2) {
            angulo += Math.PI;
            dir = -1;
        }
        miRobot.setTurnRightRadians(angulo);
        return dir;
    }

    /*
     * (non-Javadoc)
     * 
     * @see mnt.utils.ControlDeMovimiento#onScannedRobot(robocode.ScannedRobotEvent)
     */
    public void onScannedRobot(ScannedRobotEvent e) {
        if (objetivo != null)
            potenciaBala = objetivo.getEnergy() - e.getEnergy();
        objetivo = new Enemigo(e, miRobot);
    }

    /*
     * (non-Javadoc)
     * 
     * @see mnt.utils.ControlDeMovimiento#onHitByBullet(robocode.HitByBulletEvent)
     */
    public void onHitByBullet(HitByBulletEvent e) {
        // TODO Auto-generated method stub

    }

    /*
     * (non-Javadoc)
     * 
     * @see mnt.utils.ControlDeMovimiento#onHitRobot(robocode.HitRobotEvent)
     */
    public void onHitRobot(HitRobotEvent e) {
        // TODO Auto-generated method stub

    }

    /*
     * (non-Javadoc)
     * 
     * @see mnt.utils.ControlDeMovimiento#onHitWall(robocode.HitWallEvent)
     */
    public void onHitWall(HitWallEvent e) {
        // TODO Auto-generated method stub

    }

    public void onBulletHit(BulletHitEvent e) {

    }

}