package kvk.Movement;
import kvk.Bots.Bot;
import kvk.ExtendedRobot;
import kvk.Utils.BattleField;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.ObjectRobot;
import kvk.Utils.Point;
import robocode.*;

/**
 *  Mouvement alatoire pour les duels. Amlior avec la mthode de pez.mini.Tityus.
 *
 * @author     Ssin.le.Terrible
 * @created    4 mars 2004
 */
public class MoveTityusOvOStyle extends ObjectRobot implements Movement {
	//{{{*** Variables
	private static  double   GOOD_DISTANCE;
	private static  double   MIN_DISTANCE;
	private         double   lateralAngle                  = 0.15d;
	private         double   lateralAngleOld               = lateralAngle;
	private         long     timeSinceChangeDirection      = 0;
	private         int      nbHits;
	private         int      fullLeadHits;
	private         boolean  isFlattening;
	private         double   oldTargetDistance             = 9999d;
	private         boolean  forceChangeDirection          = false;
	private         long     lastForceChangeDirectionTime  = 0;

	public MoveTityusOvOStyle(ExtendedRobot er) {
		super(er);
		GOOD_DISTANCE = Math.min(600d, Math.min(BattleField.getWidth(), BattleField.getHeight()) * 0.8d);
		MIN_DISTANCE = Math.min(200d, Math.min(BattleField.getWidth(), BattleField.getHeight()) * 0.4d);
	}

	public void action() {
		Bot     target           = myBot.getTarget();
		double  targetDistance;
		double  targetFirePower;
		double  moveAngle;
		double  turnAngle;
		double  distanceFactor   = 0d;                                                //valeur entre -0.1 et +0.1 pour se rapprocher de GOOD_DISTANCE
		Point   myPosition       = myBot.getCoord();
		Point   nextPosition     = null;
		long    now              = myBot.getTime();
		lateralAngleOld = lateralAngle;

		//S'il n'y a pas de cible, pas de mouvement
		if ((target == null) || !target.isUpdated()) {
			myBot.setMaxVelocity(5d);
			return;
		}

		//Gestion de la distance
		targetDistance = target.getDistance();
		//Vrifie si la distance n'est pas trop faible
		if (Math.abs(now - lastForceChangeDirectionTime) > 10 && oldTargetDistance < MIN_DISTANCE && targetDistance < oldTargetDistance) {
			forceChangeDirection = true;                                                 //force le changement de direction
			lastForceChangeDirectionTime = now;
			//myBot.print(true, "Trop trs : changement de sens ...");//DEBUG
		}
		oldTargetDistance = targetDistance;

		//Changement de direction
		double  reverseFactor;
		targetFirePower = target.getLastBulletPower();
		if (targetFirePower <= 2.3) {
			reverseFactor = 0.107 - Math.pow(targetDistance * (targetFirePower + 2.1), 0.83) / 8000;
		}
		else {
			reverseFactor = 0.1 - Math.pow(targetDistance * (targetFirePower + 1.1), 0.82) / 7750;
		}
		timeSinceChangeDirection++;

		//myBot.print(true, "" + targetDistance + "/" + targetFirePower + "/" + reverseFactor + "/" + Fct.maxEscapeAngle(Fct.bulletSpeed(targetFirePower)));//DEBUG
		if (forceChangeDirection || (isFlattening && Math.random() < reverseFactor / Fct.maxEscapeAngle(Fct.bulletSpeed(targetFirePower)))) {
			lateralAngle *= -1d;
		}

		//gestion dynamique de la distance  la cible
		distanceFactor = 0d;
		if (Math.abs(targetDistance - GOOD_DISTANCE) > 25d) {
			distanceFactor = (targetDistance < GOOD_DISTANCE ? 0.1d : -0.1d);
		}

		//Calcul de la destination
		for (int i = 0; i < 2; i++) {
			double  tries  = 0d;
			do {
				nextPosition = Fct.calcXY(target.getCoord(), Fct.bearing(target.getCoord(), myPosition) + lateralAngle, targetDistance * (1 + distanceFactor - tries / 100d));
				tries++;
			} while (tries < 150 && !nextPosition.isOnSmallRoundedField());
			if (tries < 23 + i * 100) {
				break;
			}
			lateralAngle *= -1d;
		}

		//Test si changement de sens
		if (lateralAngle != lateralAngleOld) {
			forceChangeDirection = false;
			timeSinceChangeDirection = 0;
			nbHits = 0;
			//myBot.print(true, "Reverse");                                                //DEBUG
		}

		//Mouvement
		moveAngle = robocode.util.Utils.normalRelativeAngle(Fct.bearing(myPosition, nextPosition) - myBot.getHeadingRadians());
		turnAngle = Math.atan(Math.tan(moveAngle));
		myBot.setTurnRightRadians(turnAngle);
		myBot.setAhead(myPosition.distance(nextPosition) * (moveAngle == turnAngle ? 1 : -1));
		myBot.setMaxVelocity(7d + (Math.random() < 0.4 ? -1d : 1d) - (myBot.getTurnRemaining() > 45d ? 5d : 0d));
	}

	/**
	 *  Gestion des vnements
	 *
	 * @param  e  vnement
	 */
	public void onEvent(Event e) {
		if (e instanceof HitByBulletEvent) {
			Bot     target          = myBot.getTarget();
			double  targetDistance;

			//Teste si l'on se fait toucher 2x de suite dans le mme mouvement
			if (++nbHits > 1) {
				forceChangeDirection = true;                                                //force le changement de direction
				nbHits = 0;
			}

			if (target != null && (targetDistance = target.getDistance()) > 150d) {
				if (timeSinceChangeDirection > targetDistance / ((HitByBulletEvent)e).getVelocity()) {
					fullLeadHits++;
					isFlattening = fullLeadHits > myBot.getRoundNum() / 2 + 1;
					//myBot.print("   " + targetDistance + "/" + fullLeadHits + "/" + isFlattening);//DEBUG
				}
			}
		}
	}

	public void reinitialise() {
	}
}

