package axeBots.silversurfer;
import robocode.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.io.*;
import java.awt.Shape;
import java.awt.geom.*;

import axeBots.AxeBot;
import axeBots.util.*;

public class AxeTargetMan {
	private AxeTarget targets[] = null;
	private boolean duel;

	private int opps = 0;
	private int maxOpps = 0;
	private PrintStream log = null;
	private AxeTarget target = null;

	public static final int CHS_CENTERNORMAL = 0;
	public static final int CHS_BESTAVG = 1;
	private int targetChoose = CHS_BESTAVG;

	private ArrayList scores = new ArrayList();

	public void terminate() {
		//log.println("AxeTargetMan.terminate()");

		for (int i = 0; i < maxOpps; i++) {
			if (targets[i] != null) {

				targets[i].terminate();
			}
		}

		orderTargetsByScore();

		Collections.reverse(scores);

	}

	public AxeTargetMan(double h, double w) {
		log = AxeBot.getIt().out;
	}

	public ArrayList getHeadlight() {
		ArrayList inFront = new ArrayList();

		return inFront;

	}

	public int getOpps() {
		return opps;
	}

	public int getMaxOpps() {
		return maxOpps;
	}

	public int inFront(Arc2D.Double arc) {
		return botsInShape(arc).size();
	}

	public AxeVector antiGrav(boolean useDist) {
		AxeBot me = AxeBot.getIt();
		AxeVector ag = new AxeVector(me.pos(), me.pos());
		AxeVector meToHim;
		double mod;

		for (int i = 0; i < targets.length; i++) {
			if ((targets[i] != null) && (targets[i].isAlive())) {
				meToHim = new AxeVector(me.pos(), targets[i].pos());

				//                log.println(targets[i].getName()+" meToHim: "+meToHim);
				double score = targets[i].getStratego().getScore()
						.getAvgScore();
				score = (score < 1) ? 1 : score;
				double weight = targets[i].getLife() * score;

				mod = (useDist) ? (weight / Math.pow(targets[i].getDistance(),
						3)) : weight;
				mod *= -1;
				meToHim.setModule(mod);

				ag.relativePlus(meToHim);

				//				log.println(targets[i].getName()+" apos ag. modulo:"+mod+"
				// meToHim: "+meToHim+" ag:"+ag);
			}
		}

		return ag;
	}

	private Vector botsInShape(Shape s) {
		Vector ret = new Vector();
		for (int i = 0; i < targets.length; i++) {
			if ((targets[i] != null) && (targets[i].isAlive())
					&& (targets[i].isIn(s))) {
				ret.addElement(targets[i]);
			}
		}
		return ret;
	}

	public int botsInSquare(Shape s, double distance) {
		int ret = 0;
		Vector inShape = botsInShape(s);
		for (int i = 0; i < inShape.size(); i++) {
			if (targets[i].getDistance() <= distance) {
				ret++;
			}
		}
		return ret;
	}

	public void setDuel(boolean d) {
		duel = d;
		for (int i = 0; i < maxOpps; i++) {
			if (targets[i] != null) {
				targets[i].setDuel(d);

			}
		}
	}

	public boolean allScanned(double since) {
		//if(opps < maxOpps) return true; else return false;

		for (int i = 0; i < targets.length; i++) {
			if (targets[i] != null) {

				if (targets[i].isAlive()) {
					if (targets[i].getScanTime() < since) {
						//log.println("allScanned
						// false:"+targets[i].getName()+" scan
						// em:"+targets[i].getScanTime()+" since:"+since);
						return false;
					}
				}
			} else
				return false;
		}
		return true;
	}

	public double getLowestEnemyBearing(double x, double y, double ref) {
		double ret = Double.NaN;
		double test;
		//AxeVector al = null;
		//int p = 0;
		ref = RoboMath.normalRelativeAngle(ref);
		for (int i = 0; i < targets.length; i++) {
			if (targets[i] != null) {
				if (targets[i].isAlive()) {
					test = RoboMath.normalRelativeAngle(((AxeVector) targets[i]
							.getAllPos().lastElement()).getRelativeTheta(x, y));
					test = RoboMath.normalRelativeAngle(test - ref);
					if (Double.isNaN(ret)) {
						ret = test;
						//				al =
						// ((AxeVector)targets[i].getAllPos().lastElement());
						//				p = i;
					} else if (test < ret) {
						ret = test;
						//					al =
						// ((AxeVector)targets[i].getAllPos().lastElement());
						//					p = i;
					}
				}
			}
		}
		//log.println("getLowestEnemyBearing:"+ret+"
		// x,y:"+al.getX()+","+al.getY()+" targets
		// x,y:"+targets[p].getX()+","+targets[p].getY()+"
		// "+targets[p].getName());
		return ret;
	}

	public double getHightestEnemyBearing(double x, double y, double ref) {
		double ret = Double.NaN;
		double test;
		//AxeVector al = null;
		//int p = 0;
		ref = RoboMath.normalRelativeAngle(ref);
		for (int i = 0; i < targets.length; i++) {
			if (targets[i] != null) {
				if (targets[i].isAlive()) {
					test = RoboMath.normalRelativeAngle(((AxeVector) targets[i]
							.getAllPos().lastElement()).getRelativeTheta(x, y));
					test = RoboMath.normalRelativeAngle(test - ref);
					if (Double.isNaN(ret)) {
						ret = test;
						//				al =
						// ((AxeVector)targets[i].getAllPos().lastElement());
						//				p = i;
					} else if (test > ret) {
						ret = test;
						//					al =
						// ((AxeVector)targets[i].getAllPos().lastElement());
						//					p = i;
					}
				}
			}
		}
		//log.println("getHightestEnemyBearing:"+ret+"
		// x,y:"+al.getX()+","+al.getY()+" targets
		// x,y:"+targets[p].getX()+","+targets[p].getY()+"
		// "+targets[p].getName());
		return ret;
	}

	public void setMaxOpps(int m) {
		if (maxOpps == 0) {
			maxOpps = m;
			targets = new AxeTarget[maxOpps];
		}
	}

	public void hitMe(String name, double power) {
		AxeTarget it = getBot(name);
		if (it != null) {
			it.setExpectedLifeDiff(power * 3D);
			it.hitMe(RoboMath.getBulletDamage(power));
			//resetTarget();
		}
		if (target != null)
			if (target.getHitMe() == 0)
				target = null;
	}

	public void missed(BulletTracker bt) {
		AxeTarget busca = getBot(bt.getTargetName());

		if (busca != null) {
			busca.missed(bt);
		}

	}

	public void fired(BulletTracker bt) {
		//log.println(">>>>>>>>>>>>>>>>
		// HHHHHHHHHHIIIIIIIIIIIIITTTTTTTTTTT!!!!!!!!!!! "+bt.getTargetName()+"
		// aim:"+bt.getAimMethod());//+" Life:"+bt.getEnergy());
		AxeTarget busca = getBot(bt.getTargetName());

		if (busca != null) {
			busca.fired();
		}
	}

	public void hit(BulletTracker bt) {
		//log.println(">>>>>>>>>>>>>>>>
		// HHHHHHHHHHIIIIIIIIIIIIITTTTTTTTTTT!!!!!!!!!!! "+bt.getTargetName()+"
		// aim:"+bt.getAimMethod());//+" Life:"+bt.getEnergy());
		AxeTarget busca = getBot(bt.getTargetName());

		if (busca != null) {
			busca.hit(bt);
		}
	}

	public Vector getAllClose(int dist) {

		Vector ret = new Vector();

		for (int i = 0; i < targets.length; i++) {
			if ((targets[i] != null) && (targets[i].isAlive())
					&& (targets[i].getDistance() < dist)) {
				//HataMoto.getIt().out.println(" ========-----
				// "+targets[i].getName() +" ====>> "+bot);
				ret.addElement(targets[i]);
			}
		}

		//        if (ret.size() == 0)
		//            return null;
		//        else
		return ret;
	}

	public Vector getTargeting(String bot) {
		Vector ret = new Vector();

		for (int i = 0; i < targets.length; i++) {
			if ((targets[i] != null) && (targets[i].isAlive())
			//&& (targets[i].getStratego().goodFire(targets[i]))
					&& (targets[i].getAlvo() != null)
					&& (targets[i].getAlvo().equals(bot))) {
				//HataMoto.getIt().out.println(" ========-----
				// "+targets[i].getName() +" ====>> "+bot);
				ret.addElement(targets[i]);
			}
		}

		if (ret.size() == 0)
			return null;
		else
			return ret;
	}

	public boolean inCrossFire() {
		int moveAmount = 60;
		AxeBot me = AxeBot.getIt();
		AxeVector myMoving = new AxeVector(me.getX(), me.getY(), me
				.getMoveHeading(), moveAmount);

		Line2D.Double myLine = new Line2D.Double(myMoving.getStartPoint(),
				myMoving.getEndPoint());

		for (int i = 0; i < targets.length; i++) {
			if ((targets[i] != null) && (targets[i].isAlive())) {
				AxeTarget aimed = this.getBot(targets[i].getAlvo());
				if ((aimed != null) && (aimed.isAlive())) {
					Line2D.Double fireLine = new Line2D.Double(targets[i]
							.getX(), targets[i].getY(), aimed.getX(), aimed
							.getY());

					if (myLine.intersectsLine(fireLine)) {
						//                        me.out.println(
						//                            " ********* CROSSFIRE ******* "
						//                                + targets[i].getName()
						//                                + " --> "
						//                                + aimed.getName());
						return true;
					}
				}
			}
		}
		return false;

	}

	public void printAllTargets() {

		AxeBot.getIt().out.println("*****************************");
		for (int i = 0; i < targets.length; i++) {
			if (targets[i] != null) {
				if (targets[i].isAlive()) {

					AxeBot.getIt().out.println("" + targets[i].getName()
							+ "  ====>> " + targets[i].getAlvo());

				}
			}
		}
		AxeBot.getIt().out.println("*****************************");

	}

	/**
	 * @return
	 */
	public double getCanHitMe(String bot) {
		AxeTarget robot = this.getBot(bot);
		if ((robot != null) || (!robot.isAlive())) {
			return robot.getCanHitMe();
		} else
			return Double.NaN;
	}

	/**
	 * @param d
	 */
	public void resetCanHitMe(String bot) {
		AxeTarget robot = this.getBot(bot);
		if ((robot != null) || (!robot.isAlive())) {
			robot.setCanHitMe(Double.NaN);
		}
	}

	public void setScanned(ScannedRobotEvent e, AdvancedRobot ft) {

		AxeTarget busca = getBot(e.getName());

		if (busca == null) {

			log.println("scaneou novo. armazenando ==> " + e.getName());
			putBot(e, ft);
			busca = getBot(e.getName());
		}

		if (busca != null) {

			busca.setScanned(e, ft);
		
		}
	}

	public double getFirePwr(AdvancedRobot ft, Arc2D.Double arc, AxeTarget t) {
		if (t != null) {
			//            int inf= this.inFront(arc);
			return t.getStratego().setFirePower();
		} else
			return Double.NaN;
	}

	public boolean notSeenSince(double time) {
		if (target != null) {
			return (time > (target.getScanTime() + 10));
		}

		return false;
	}

	public AxeTarget getTarget(int opps) {
		if ((target == null) || (!target.isAlive())
				|| (target.getHitsOnARow() < 2)) {
			getPrimeTarget(opps);
		}
		return target; //(AxeTarget)target.clone();

	}

	public void anotherOneBitesTheDust(RobotDeathEvent e, int pts) {
		AxeTarget jaera = getBot(e.getName());
		pts = (maxOpps + 1) - (pts + 1);
		//pts + 1 pque a eu existo!!!pts e o numero de restantes.
		if (jaera != null) {
			jaera.dead(pts);
		}
	}

	public AxeTarget getTooClose(double minDist) {
		AxeTarget ret = null;
		for (int i = 0; i < targets.length; i++) {
			if ((targets[i] != null) && (targets[i].isAlive())
					&& (targets[i].getDistance() < minDist)) {
				if (ret == null)
					ret = targets[i];
				else if (targets[i].getDistance() < ret.getDistance())
					ret = targets[i];
			}
		}
		return ret;
	}

	private double getCenterBearing() {
		AxeVector me = new AxeVector(
				AxeBot.getIt().getBattleFieldWidth() / 2.0, AxeBot.getIt()
						.getBattleFieldHeight() / 2.0);
		return me
				.getRelativeTheta(AxeBot.getIt().getX(), AxeBot.getIt().getY());

	}

	private double getTargetCenterNormal(AxeTarget targ) {
		double ret = (double) RoboMath.normalRelativeAngle(RoboMath
				.normalRelativeAngle(getCenterBearing())
				- RoboMath.normalRelativeAngle(Math.toDegrees(targ
						.getAbsBearing())));
		return Math.abs(ret);
	}

	private void getPrimeTarget(int opps) {
		AxeBot me = AxeBot.getIt();
		double close = me.getBotDim() * 8;

		int energyLim = 25;

		if (target != null) {
			if (!target.isAlive()) {
				if (me.getOthers() > 0) {

					target = null;
				} else {
					return;
				}
			}
		}
		Vector targVector = this.getAllClose((int) close);
		Object[] targArray;
		if ((targVector != null) && (targVector.size() > 0)) {
			targArray = targVector.toArray();
		} else {
			targArray = targets;
		}

		//		se tres opps OU MENOS , pega o +fraco (DOS QUE ESTAO ATIRANDO EM MIM.
		if (opps < 4) {
			//aimMe= targets;

			AxeTarget next = null;
			double norm = 0;
			for (int i = 0; i < targArray.length; i++) {
				AxeTarget now = (AxeTarget) targArray[i];
				if ((now != null) && (now.isAlive())) {
					double cp;

					cp = now.getStratego().getBestAvg(now.getDistance(),
							now.getAngle()) * 100.00;
					cp += 100 - now.getLife();
					double groupPrize = 10 * (inFront(me.getAimingArc(now
							.getAbsBearing(), 20)) - 1);
					cp += groupPrize;
					if ((next == null) || (cp > norm)) {
						norm = cp;
						next = now;
					}
				}
			}
			if (next != null) {
				target = next;
				//log.println("getPrimeTarget escolheu:"+target.getName());
			}
		}
		AxeTarget next = null;
		double norm = 0;
		switch (targetChoose) {

			case CHS_CENTERNORMAL :
				// aimMe= targets;
				for (int i = 0; i < targArray.length; i++) {
					AxeTarget now = (AxeTarget) targArray[i];
					if ((now != null) && (now.isAlive())) {
						double cp;
						if (me.getEnergy() < energyLim) {
							cp = now.getStratego().getBestAvg(
									now.getDistance(), now.getAngle()) * 100.00;
							cp += 100 - now.getLife();
							double groupPrize = 10 * (inFront(me.getAimingArc(
									now.getAbsBearing(), 20)) - 1);
							cp += groupPrize;
						} else {
							// pega a normal em relaccao ao centro.
							cp = getTargetCenterNormal(now);
							// adiciona bonus 10*grupo
							double groupPrize = 10 * (inFront(me.getAimingArc(
									now.getAbsBearing(), 20)) - 1);
							cp += groupPrize;
							//adiciona bonus se atual alvo
							if ((target != null)
									&& (target.getName().compareTo(
											now.getName()) == 0)) {
								cp += 10;
							} // adiciona bonus se alvo me atacando
							if ((now.getAlvo() != null)
									&& (now.getAlvo().equals(AxeBot.getIt()
											.getName()))) {
								cp += 20;
							} //adiciona bonus de score e danos causados

							cp += this.getScorePoints(now.getName());
							cp += this.getDamagePoints(now.getName());
						} //log.println("getPrimeTarget
						  // points:"+now.getName()+" :" +cp+" score:"+scr+"
						  // damaged:"+dmg);
						if ((next == null) || (cp > norm)) {
							norm = cp;
							next = now;
						}
					}
				}
				if (next != null) {
					target = next;
					//log.println("getPrimeTarget escolheu:"+target.getName());
				}
				break;

			case CHS_BESTAVG :
				//aimMe= targets;
				//escolhe o melhor dentre os outros
				for (int i = 0; i < targArray.length; i++) {
					AxeTarget now = (AxeTarget) targArray[i];
					if ((now != null) && (now.isAlive())) {
						double cp;

						cp = (now.getStratego().getAimTotFiredInRange(now) > (Stratego.AIM_STRATS * 5))
								? now.getStratego().getBestAvg(
										now.getDistance(), now.getAngle()) * 100.00
								: 100.00;

						//	adiciona bonus 10*grupo
						double groupPrize = 10 * (inFront(me.getAimingArc(now
								.getAbsBearing(), 20)) - 1);
						cp += groupPrize;
						//	adiciona bonus se alvo me atacando
						if ((now.getAlvo() != null)
								&& (now.getAlvo().equals(AxeBot.getIt()
										.getName()))) {
							cp += 20;
						}
						//	adiciona bonus se atual alvo
						if ((target != null)
								&& (target.getName().compareTo(now.getName()) == 0)) {
							cp += 10;
						}

						if ((next == null) || (cp > norm)) {
							norm = cp;
							next = now;
						}
					}
				}
				if (next != null) {
					target = next;
				}
				break;

		}

	}

	public AxeTarget getBot(String bot) { ////log.println("getBot
										  // searching:"+bot);
		if (bot != null) {
			AxeTarget busca = null;
			for (int i = 0; i < maxOpps; i++) {
				busca = targets[i];
				if (busca != null) {
					if (busca.getName().compareTo(bot) == 0) {
						return busca;
					}
				}
			}
		}

		return null;
	}

	private void putBot(ScannedRobotEvent e, AdvancedRobot ft) {
		AxeTarget t = new AxeTarget(e, ft, log);
		t.setDuel(duel);
		scores.add(t.getStratego().getScore());
		AxeTarget busca = null;
		for (int i = 0; i < maxOpps; i++) {
			busca = targets[i];
			if (busca == null) {
				busca = t;
				targets[i] = t;
				opps++;
				return;
			}

		}

	}
	private double getScorePoints(String bot) {

		double pointsWidth = 20;
		double pointsStep = pointsWidth / (double) (this.getMaxOpps() - 1);
		orderTargetsByScore();
		AxeScoreReg srch = new AxeScoreReg(bot, this.getMaxOpps() + 1);
		int ind = scores.indexOf(srch);
		if (ind > -1) {
			return ind * pointsStep;
		} else {
			return 0;
		}
	}

	private void orderTargetsByScore() {
		Collections.sort(scores, new Comparator() {
			public int compare(Object a, Object b) {
				double diff = ((AxeScoreReg) a).getAvgScore()
						- ((AxeScoreReg) b).getAvgScore();
				if (diff < 0)
					return -1;
				if (diff > 0)
					return 1;
				return 0;
			}
		});
	}

	private void orderTargetsByDamage() {
		Collections.sort(scores, new Comparator() {
			public int compare(Object a, Object b) {
				double diff = ((AxeScoreReg) a).getAvgDamage()
						- ((AxeScoreReg) b).getAvgDamage();
				if (diff < 0)
					return -1;
				if (diff > 0)
					return 1;
				return 0;
			}
		});
	}

	private double getDamagePoints(String bot) {

		double pointsWidth = 20;
		double pointsStep = pointsWidth / (double) (this.getMaxOpps() - 1);
		orderTargetsByDamage();
		AxeScoreReg srch = new AxeScoreReg(bot, this.getMaxOpps() + 1);
		int ind = scores.indexOf(srch);
		if (ind > -1) {
			return ind * pointsStep;
		} else {
			return 0;
		}
	}

}