package damij.mega;
import robocode.*;
import robocode.util.Utils;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Arrays;
import java.util.HashMap;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

/**
 * Boque - a robot by Damij
 */
public class Boque extends AdvancedRobot
{

	static final int WALL_STICK = 200;

	static final boolean IS_MC = false, IS_TC = false;
	
	static Rectangle2D playField;

	static double WIDTH, HEIGHT, MAX_DIST;

	private static Poker weapon;
	
	private static Rekop movement;
	
	private Bullet bulletFired;
	
	private ScanEvent ev;
	
	private RobotStatus statsPast;
	
	private double[] distVelData;
	
	private double bPower;

	private long shotTime = 0l;
	
	private boolean hasSurfWave;

	/**
	 * run: Boque's default behavior
	 */
	public void run() {
	
		WIDTH = super.getBattleFieldWidth() - 36d;
		HEIGHT = super.getBattleFieldHeight() - 36d;
		MAX_DIST = Math.sqrt(WIDTH*WIDTH + HEIGHT*HEIGHT);
	
		playField = new Rectangle2D.Double(
			18d, 18d, WIDTH, HEIGHT
		);

		if(weapon == null) {
			weapon = new Poker(this);
			movement = new Rekop(this);
		}

		super.setAdjustRadarForGunTurn(true);
		super.setAdjustRadarForRobotTurn(true);
		super.setAdjustGunForRobotTurn(true);	

		weapon.startRound();
		movement.startRound();

		super.addCustomEvent(
			new Condition("ShouldAim", 15) {
				@Override
				public boolean test() {
					return !IS_TC;
				}
			}
		);
		
		super.addCustomEvent(
			new Condition("ShouldFire", 18) {
				@Override
				public boolean test() {
					return !IS_TC && shotTime == Boque.super.getTime() &&
						Boque.super.getGunTurnRemainingRadians() == 0 &&
						Boque.super.getGunHeat() == 0 &&
						(Boque.super.getEnergy() > bPower || IS_MC) &&
						Boque.super.getOthers() > 0;
				}
			}
		);
		
		super.addCustomEvent(
			new Condition("ShouldNull", 20) {
				@Override
				public boolean test() {
					return true;
				}
			}
		);
		
		super.addCustomEvent(
			new Condition("ShouldPlan", 23) {
				@Override
				public boolean test() {
					return !Boque.IS_MC && (hasSurfWave || Boque.super.getDistanceRemaining() <= 1.5d);
				}
			}
		);
		
		super.addCustomEvent(
			new Condition("ShouldDrive", 21) {
				@Override
				public boolean test() {
					return !Boque.IS_MC;
				}
			}
		);
		
		super.setEventPriority("StatusEvent", 2);
		super.setEventPriority("ScannedRobotEvent", 98);
		super.setEventPriority("HitByBulletEvent", 97);
		super.setEventPriority("BulletHitBulletEvent", 97);
		super.setEventPriority("BulletHitEvent", 97);
		
		final int roundCount = super.getRoundNum();
		
		super.setColors(
			Color.WHITE, Color.WHITE,
			new Color(
				(int)Math.round(255*Math.abs(Math.cos(0.5d*roundCount*Math.PI))),
				(int)Math.round(255*Math.abs(Math.sin(0.333d*roundCount*Math.PI))),
				(int)Math.round(255*Math.abs(Math.sin(0.1d*roundCount*Math.PI)))
			)
		);
		
		super.setBulletColor(
			Color.ORANGE.brighter().brighter().brighter()
		);

		super.turnRadarRightRadians(Double.POSITIVE_INFINITY);
		
	}
	
	@Override
	public void onCustomEvent(final CustomEvent e) {
		if(e.getCondition().getName().equals("ShouldAim")) {
			shotTime = weapon.aim();
		}
		else if(e.getCondition().getName().equals("ShouldFire")) {
			bulletFired = weapon.fireBullet();
		}
		else if(e.getCondition().getName().equals("ShouldNull")) {
			bulletFired = null;
		}
		else if(e.getCondition().getName().equals("ShouldPlan")) {
			movement.planRoute();
		}
		else if(e.getCondition().getName().equals("ShouldDrive")) {
			movement.driveToDest();
		}
	}
	
	@Override
	public void onStatus(final StatusEvent e) {
		statsPast = e.getStatus();
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	
		final int currDir;
		final int currLatDir;
		final double currEnergy;
		final double currVel;
		if(ev == null) {
			currDir = 1;
			currLatDir = 1;
			currEnergy = 100d;
			currVel = 0;
		} else {
			currDir = ev.eDir();
			currLatDir = ev.eLatDir();
			currEnergy = ev.getEnergy();
			currVel = ev.velocity();
		}
		
		ev = new ScanEvent(e, super.getX(), super.getY(), super.getHeadingRadians(), currDir, currLatDir, currEnergy, currVel);
		
		final double radarOffset =
			Utils.normalRelativeAngle(
				ev.absBearingTo()
				-
				super.getRadarHeadingRadians()
			);
			
		super.setTurnRadarRightRadians(1.8*radarOffset);
		
		bPower = weapon.integrate(ev);
		hasSurfWave = movement.integrate(ev, statsPast, bulletFired);
	
	}

	@Override
	public void onHitByBullet(final HitByBulletEvent e) {
		movement.saveHit(e.getBullet(), super.getTime());
	}
	
	@Override
	public void onBulletHitBullet(final BulletHitBulletEvent e) {
		movement.saveHit(e.getHitBullet(), super.getTime() - 1);
	}
	
	@Override
	public void onBulletHit(final BulletHitEvent e) {
		weapon.chalkOneUp(e.getBullet());
	}
	
	@Override
	public void onHitWall(HitWallEvent e) {
		
	}
	
	@Override
	public void onPaint(final Graphics2D g2) {
		weapon.paint(g2);
		movement.paint(g2);
	}
	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Poker {

	static final double TIME_DECAY_CONST = 0.35D;//1618d;

	static final int BINS = 113, NEIGHBORS = 35,
		HALF_BIN = (BINS-1)/2, 
		//DON'T CHANGE
		MAX_WAVES = 8;

	private final AdvancedRobot self;
	private final HashMap<double[], Double> _attackMap;
	private final List<Wave> _waves;
	private final List<Point2D> _futures;
	
	private final Point lastEPos;

	private final double[] distances, dangerCurve, dangerCurveAS, gunAccuracies;
	
	private final long[] hits, shots;
	
	private ScanEvent eData;
	
	private double[] lastKey, activeKey, fireAngles;
	
	private double bPower, maxOffset, minOffset, maxCrimp, minCrimp, fireBearing;
	
	private long timeSinceDirChange;
	
	private int runningWaveCount, lastEDir, fireELatDir;

	Poker(final AdvancedRobot self) {
		this.self = self;
		_waves = new ArrayList<>();
		_futures = new ArrayList<>();
		_attackMap = new HashMap<>();
		distances = new double[NEIGHBORS];
		dangerCurve = new double[BINS];
		dangerCurveAS = new double[BINS];
		gunAccuracies = new double[2];
		fireAngles = new double[2];
		hits = new long[2];
		shots = new long[2];
		lastEPos = new Point();
	}
	
	void startRound() {
		_waves.clear();
		timeSinceDirChange = 0;
		lastEDir = 1;
	}	

	double integrate(final ScanEvent e) {
	
		if(this.eData != null) this.lastEPos.setLocation(eData.getX(), eData.getY());

		this.eData = e;
		
		timeSinceDirChange ++;
		if(eData.eDir() != lastEDir) {
			timeSinceDirChange = 0;
		}
		lastEDir = eData.eDir();
		
		this.cullWaves();
		
		this.setMaxPosAndCrimps();
		
		return bPower;
	}
	
	private void cullWaves() {
		final Iterator<Wave> waverator = _waves.iterator();
		final Point eSpot = new Point();
		eSpot.setLocation(eData.getX(), eData.getY());
		final long currTime = self.getTime();
		while(waverator.hasNext()) {
			final Wave w = waverator.next();
			if(w.breaks(eSpot, currTime)) {
				storeWave(w, eSpot);
				waverator.remove();
			}
		}
	}
	
	private void storeWave(final Wave w, final Point eSpot) {
		double factor = w.getFactor(eSpot);
                factor /= factor * w.minOffset() > 0 ? -w.minOffset() : w.maxOffset();
		//factor = factor < w.minCrimp() ? (factor-w.minCrimp())/w.minOffset() + w.minCrimp() : factor > w.maxCrimp() ? (factor-w.maxCrimp())/w.maxOffset() + w.maxCrimp() : factor;
		//factor = factor < w.minCrimp() ? w.minOffset()*(factor-w.minCrimp()) + w.minCrimp() : factor > w.maxCrimp() ? w.maxOffset()*(factor-w.maxCrimp()) + w.maxCrimp() : factor;
                //factor = factor < 0 ? -factor/w.minOffset() : factor / w.maxOffset();
                _attackMap.put(w.key(), factor);
		final int[] currHits = w.getHitIndices(eSpot, self.getTime());
		hits[0] += currHits[0];
		hits[1] += currHits[1];
		shots[0] += 1;
		shots[1] += 1;
		gunAccuracies[0] = (double)hits[0]/(double)shots[0];
		gunAccuracies[1] = (double)hits[1]/(double)shots[1];
	}
	
	void chalkOneUp(final Bullet b) {
		final Wave chalk = getLiveMatch(b, self.getTime());
		if(chalk == null) {
			System.out.println("Nonseneseries abound");
			return;
		}
		final double[] key = chalk.key();
		_attackMap.remove(key);
		key[key.length-1] = (double) 3;
		final Point bPoint = new Point();
		bPoint.setLocation(b.getX(),b.getY());
		final double factor = chalk.getFactor(bPoint);
		_attackMap.put(key, factor);
	}
	
	private void calcBPower() {
		double potPow = 1.5d;
		final double energy = self.getEnergy();
		if(energy < 18) {
			potPow -= 0.8d;
			if(energy < 12) {
				potPow -= 0.4d;
				if(energy < 7) {
					potPow -= 0.2d;
					if(energy < 3) {
						potPow = 0.1d;
					}
				}
			}
		}
		if(eData.distance() < 469d) {//368d) {
			final double distFact;
			potPow += (3d - potPow) * (1-Math.min(1d,Math.max(0d,(eData.distance() - 90d)/405)));//Helpers.max(0d,(1d-Helpers.log1p(2d*(distFact = ((eData.getDistance()-36d)/569)))));///533d)))));// *distFact*distFact)));
		}
		if(eData.getEnergy() <= 1.2d*Rules.getBulletDamage(potPow)&&eData.getEnergy() < 16d) {
			potPow = (eData.getEnergy()+2d)/6d + 0.01d;
			if(eData.getEnergy()<=4)
				potPow = Math.max(0.1d, eData.getEnergy() / 4d);
		}
		
		this.bPower = potPow;
	}

	long aim() {
	
		if(eData == null) {
			return 0;
		}
		
		this.calcBPower();
		this.lastKey = activeKey;
		this.activeKey = calcKey();
	
		final double maxTurnRate = Rules.getTurnRateRadians(self.getVelocity());
		final double willTurn = Helpers.clamp(
			self.getTurnRemainingRadians(),
			-maxTurnRate,
			maxTurnRate
		);
		final double myNextHeading =
			Utils.normalAbsoluteAngle(
				self.getHeadingRadians()
				+
				willTurn
			);
	
		final double myNextVelocity =
			Helpers.getNewVelocityLimited(
				self.getVelocity(),
					self.getDistanceRemaining(),
				Rules.MAX_VELOCITY
			);
		
		final Point nextLoc = Helpers.projectToPoint(
			self.getX(), self.getY(), myNextHeading, myNextVelocity
		);
                
                nextLoc.setLocation(
                        Helpers.clamp(nextLoc.x, 18d, Boque.WIDTH+18d),
                        Helpers.clamp(nextLoc.y, 18d, Boque.HEIGHT+18d)
                );
		
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		final Point[] enemyLocPair = predictEnemyLoc();
		final Point enemyLoc = enemyLocPair[0];
		final Point asLoc = enemyLocPair[1];

		/*double currVel = eData.velocity();
		double nextEVelocity = (currVel >= 0 ? 1 : -1) * Math.max(0d, (3*Math.abs(currVel) - 1)) / 3d;
		enemyLoc.setLocation(Helpers.projectToPoint(
			enemyLoc.x, enemyLoc.y, eData.headingRadians(), nextEVelocity
		));
		asLoc.setLocation(Helpers.projectToPoint(
			asLoc.x, asLoc.y, eData.headingRadians(), nextEVelocity
		));*/
                
                enemyLoc.setLocation(
                        Helpers.clamp(enemyLoc.x, 18d, 18d + Boque.WIDTH),
                        Helpers.clamp(enemyLoc.y, 18d, 18d + Boque.HEIGHT)
                );
                
                asLoc.setLocation(
                        Helpers.clamp(asLoc.x, 18d, 18d + Boque.WIDTH),
                        Helpers.clamp(asLoc.y, 18d, 18d + Boque.HEIGHT)
                );
	
		final double absBearingToTarget
			= Math.atan2(enemyLoc.x - nextLoc.x, enemyLoc.y - nextLoc.y);
		final double bearingToASTarget
			= Math.atan2(asLoc.x - nextLoc.x, asLoc.y - nextLoc.y);
			
		fireAngles = new double[] {absBearingToTarget, bearingToASTarget};

		final double gunOffset;
                final Color midSection;
                
		if(gunAccuracies[0] >= gunAccuracies[1]) {
			gunOffset = Utils.normalRelativeAngle(
				absBearingToTarget
				-
				self.getGunHeadingRadians()
			);
                        midSection = Color.MAGENTA.brighter();
		} else {
			gunOffset = Utils.normalRelativeAngle(
				bearingToASTarget
				-
				self.getGunHeadingRadians()
			);
                        midSection = new Color(0x94, 0xF0, 0x6C);
		}
                
                final int roundCount = self.getRoundNum();
                
                self.setColors(Color.WHITE, midSection,
                    new Color(
				(int)Math.round(255*Math.abs(Math.cos(0.5d*roundCount*Math.PI))),
				(int)Math.round(255*Math.abs(Math.sin(0.333d*roundCount*Math.PI))),
				(int)Math.round(255*Math.abs(Math.sin(0.1d*roundCount*Math.PI)))
			)
                );
                
                self.setBulletColor(midSection);
			
		self.setTurnGunRightRadians(gunOffset);
		
		//fireBearing = Math.atan2(enemyLoc.x - nextLoc.x, enemyLoc.y - nextLoc.y);
		
		fireELatDir = eData.eLatDir();
		
		return self.getTime() + 1;

	}
	
	private Point[] predictEnemyLoc() {
		Arrays.fill(dangerCurve, 0d);
		Arrays.fill(dangerCurveAS, 0d);
		Arrays.fill(distances, 0d);
		int numNeighbors = Math.min(NEIGHBORS, _attackMap.size());
		
		final double[][][] neighborsBoth =
			Helpers.findKNNBoth(
				numNeighbors,
				activeKey,
				_attackMap.keySet().toArray(double[][]::new),
				distances
			);
			
		final double[][] neighbors = neighborsBoth[0];
		final double[][] asNeighbors = neighborsBoth[1];
			
		final double mEA = Math.asin(8d/Rules.getBulletSpeed(bPower));
			
		final double[] factorAngles = new double[neighbors.length];
		final double[] asAngles = new double[asNeighbors.length];
		for(int i = 0; i < factorAngles.length; i ++) {
			factorAngles[i] = angleFromFactor(_attackMap.get(neighbors[i]), mEA);
			asAngles[i] = angleFromFactor(_attackMap.get(asNeighbors[i]), mEA);
		}
			
		final double stdDev = 0.618*eData.angularWidth();
		double maxAngle = eData.absBearingTo();
		double maxASAngle = eData.absBearingTo(); 
		double maxDanger = 0d;
		double maxASDanger = 0d;
		boolean tied = false;
		int startTieIndex = 5*HALF_BIN/3, endTieIndex = 5*HALF_BIN/3;
		int maxASBin = 5*HALF_BIN/3;
		for(int b = 0; b < BINS; b ++) {
			final double binAngle = angleFromBin(b, mEA);
			for(int fa = 0; fa < factorAngles.length; fa ++) {
				final double angleDif =
					Utils.normalRelativeAngle(
						binAngle - factorAngles[fa]
					);
				final double asAngleDif =
					Utils.normalRelativeAngle(
						binAngle - asAngles[fa]
					);
				final double x = angleDif / (stdDev);
				final double x2 = asAngleDif / stdDev;
				//if(Math.abs(angleDif) < stdDev) {
					dangerCurve[b] += Math.exp(-0.5*x*x) / (Math.sqrt(stdDev*Math.PI*distances[fa]*distances[fa]+1));
					dangerCurveAS[b] += Math.exp(-0.5*x2*x2) / (Math.sqrt(stdDev*Math.PI+1));
				//	dangerCurve[b] += 1d/distances[fa];
				//}
			}
			if(dangerCurve[b] > maxDanger) {
				maxDanger = dangerCurve[b];
				//maxAngle = binAngle;
				startTieIndex = b;
				endTieIndex = b;
				tied = true;
			}/* else if (dangerCurve[b] == maxDanger && tied) {
				endTieIndex = b;
			} else {
				tied = false;
			}*/
			if(dangerCurveAS[b] > maxASDanger) {
				maxASDanger = dangerCurveAS[b];
				maxASBin = b;
			}
		}
		
		//shoot at maximum esc if on the edge
		if(tied) startTieIndex = endTieIndex;
		
		maxAngle = angleFromBin((startTieIndex + endTieIndex)/2, mEA);
		maxASAngle = angleFromBin(maxASBin, mEA);
		

		final Point enemyLoc =
			Helpers.projectToPoint(
				self.getX(), self.getY(),
				maxAngle, eData.distance()
			);
			
		final Point asLoc =
			Helpers.projectToPoint(
				self.getX(), self.getY(),
					maxASAngle, eData.distance()
			);
                
                enemyLoc.setLocation(
                        Helpers.clamp(enemyLoc.x, 18d, 18d + Boque.WIDTH),
                        Helpers.clamp(enemyLoc.y, 18d, 18d + Boque.HEIGHT)
                );
                
                asLoc.setLocation(
                        Helpers.clamp(asLoc.x, 18d, 18d + Boque.WIDTH),
                        Helpers.clamp(asLoc.y, 18d, 18d + Boque.HEIGHT)
                );
                
		return new Point[] {enemyLoc, asLoc};
	}
	
	Bullet fireBullet() {
		final double aimedBearing = Math.atan2(eData.getX() - self.getX(), eData.getY() - self.getY());
		_waves.add(
			new Wave(
				self.getX(), self.getY(),
				aimedBearing,
				bPower,
				self.getTime(),
				fireELatDir,
				calcKey(),
				(minCrimp),
				(maxCrimp),
				(minOffset),
				(maxOffset),
				fireAngles
			)
		);
		return self.setFireBullet(bPower);
	}
	
	double[] calcKey() {
		final Point eCenter = new Point();
		eCenter.setLocation(eData.getX(), eData.getY());
		double eGoing = eData.headingRadians() - (eData.eDir()-1)/2 * Math.PI;
		double wallSpace = Helpers.calcWallSpace(eCenter, eGoing);
		eGoing += Math.PI;
		eGoing = Utils.normalAbsoluteAngle(eGoing);
		double revWallSpace = Helpers.calcWallSpace(eCenter, eGoing);
		final double FOCUS = 1d; // 
		return new double[]{
			FOCUS *(eData.distance() / Boque.MAX_DIST),
			FOCUS *(Math.abs(eData.eAdvVel()) / 8d),
			FOCUS *(Math.abs(eData.eLatVel()) / 8d),
			FOCUS *(Math.abs(eData.eLatVel() + Math.abs(Math.sin(eData.bearingRadians()))*self.getVelocity()*eData.eSide()) / 16d),
			FOCUS *(1d/(1d + TIME_DECAY_CONST*timeSinceDirChange)),
			FOCUS *(Math.min(1d, wallSpace)),
			FOCUS *(Math.min(1d, revWallSpace)),
			FOCUS *((eData.accel() + 1d) / 2d),
			FOCUS *(bPower / 3d),
			//FOCUS *(Math.abs(minCrimp)),
			//FOCUS *(Math.abs(maxCrimp)),
                        FOCUS *(Math.abs(minOffset)),
                        FOCUS *(Math.abs(maxOffset)),
			0 // used for AS targetting
		};
	}
	
	void setMaxPosAndCrimps() {
		final Point eCenter = new Point();
		eCenter.setLocation(eData.getX(), eData.getY());
		final Point2D[] nexts
				= Helpers.getMaxPosAndCrimps(self, eData, eCenter, bPower, _futures);

		final double absBearingTo = eData.absBearingTo();

		final double o1 = calcFactor(nexts[0], absBearingTo);
		final double o2 = calcFactor(nexts[1], absBearingTo);
		final double c1 = calcFactor(nexts[2], absBearingTo);
		final double c2 = calcFactor(nexts[3], absBearingTo);
			
		this.maxOffset = Math.max(o1,o2);
		this.minOffset = Math.min(o1,o2);
		this.maxCrimp = Math.max(c1,c2);
		this.maxCrimp = Math.abs(maxOffset - maxCrimp) < 0.01d ? 0d : maxCrimp;
		this.minCrimp = Math.min(c1,c2);
		this.minCrimp = Math.abs(minOffset - minCrimp) < 0.01d ? 0d : minCrimp;
	}
	
	double calcFactor(final Point2D pos, final double absBearingG) {
		final double mEA = Math.asin(8d/Rules.getBulletSpeed(bPower));
		final double absAngleTo = Math.atan2(pos.getX()-self.getX(),pos.getY()-self.getY());
		double factor = Helpers.clamp(Utils.normalRelativeAngle(absAngleTo-absBearingG)/mEA * eData.eLatDir(), -1d, 1d);
		//factor = factor < minCrimp ? (factor-minCrimp)/minOffset + minCrimp : factor > maxCrimp ? (factor-maxCrimp)/maxOffset + maxCrimp : factor;
		//factor = factor < minCrimp ? minOffset*(factor-minCrimp) + minCrimp : factor > maxCrimp ? maxOffset*(factor-maxCrimp) + maxCrimp : factor;
		//factor *= factor < 0 ? Helpers.abs(minOffset) : Helpers.abs(maxOffset);
		return factor;
	}
	
	private double angleFromBin(final int bin, final double mEA) {
                double factor = ((double)(bin-HALF_BIN)/(double)HALF_BIN);
                //factor = factor < minCrimp ? minOffset*(factor-minCrimp) + minCrimp : factor > maxCrimp ? maxOffset*(factor-maxCrimp) + maxCrimp : factor;
		final double thetaOffset = factor * eData.eLatDir() * mEA;
		return Utils.normalAbsoluteAngle(eData.absBearingTo() + thetaOffset);
	}
	
	private double angleFromFactor(double factor, final double mEA) {
                factor *= factor * minOffset > 0 ? -minOffset : maxOffset;
		//factor = factor < minCrimp ? minOffset*(factor-minCrimp) + minCrimp : factor > maxCrimp ? maxOffset*(factor-maxCrimp) + maxCrimp : factor;
                //factor = factor < minCrimp ? (factor-minCrimp)/minOffset + minCrimp : factor > maxCrimp ? (factor-maxCrimp)/maxOffset + maxCrimp : factor;
		return Utils.normalAbsoluteAngle(factor * eData.eLatDir() * mEA + eData.absBearingTo());
	}	
	
	private Wave getLiveMatch(final Bullet b, final long impactTime) {
		for(final Wave w : _waves) {
			if(w.matches(b, impactTime)) return w;
		} return null;
	}

	void paint(final Graphics2D g2) {
		for(final Wave w : _waves) {
			//w.paintSkelly(g2, self.getTime(), 0);
			//w.paintBaseAngle(g2, self.getTime());
			w.paintFireAngles(g2, self.getTime());
		}
		g2.setColor(Color.RED.darker().darker());
		for(final Point2D fut : _futures) {
			g2.fill(
				new Rectangle2D.Double(
					fut.getX()-2,fut.getY()-1,5,3
				)
			);
		}
	}

}

class Rekop {

	static final double TIME_DECAY_CONST = 0.2618d;

	static final int BINS = 191, NEIGHBORS = 9,
		HALF_BIN = (BINS-1)/2;
	
	private final HashMap<double[], Double> _attackMap;
	private final List<Bullet> _shaders;
	private final List<BulletWave> _waves;
	//private final List<double[]> _dangerCurves;
	
	private final AdvancedRobot self;
	private final Point destination, bowP, sternP;
	
	private final double[] distances;
	
	private ScanEvent eData, delayedEData, ancientEData;
	private RobotStatus statsPast, delayedStats, ancientStats;
	private BulletWave surfWave;
        
        private double[] shotKey;
	
	private double laggingVel, laggingBearing, headingChangeRate;
	private long timeOfImpact, timeSinceDirChange, lastTSDC;
	private int dir = -1, latDir = 1, accel, delayedAccel, delayedLatDir, desiredDir, delayedDir = -1, ancientLatDir = delayedLatDir;
	
	Rekop(final AdvancedRobot self) {
		this.self = self;
		this.destination = new Point();
		this.bowP = new Point();
		this.sternP = new Point();
		this.destination.setLocation(self.getX(), self.getY());
		_shaders = new ArrayList<>();
		_waves = new ArrayList<>();
		_attackMap = new HashMap<>();
		distances = new double[NEIGHBORS];
		//_dangerCurve = new ArrayList<>();
	}
	
	void startRound() {
		_shaders.clear();
		_waves.clear();
		surfWave = null;
		eData = null;
		delayedEData = null;
		ancientEData = null;
		desiredDir = dir;
		timeOfImpact = 0;
		timeSinceDirChange = 0;
		lastTSDC = 0;
	}
	
	boolean integrate(final ScanEvent e, final RobotStatus statsPast, final Bullet bulletFired) {
		if(bulletFired != null) {
			_shaders.add(bulletFired);
		}
		final long currTime = self.getTime();
		for(final BulletWave w : _waves) {
			w.runThroughBullets(_shaders, currTime+1);
		}
		this.ancientStats = this.delayedStats;
                this.delayedStats = this.statsPast;
		this.statsPast = statsPast;
		this.ancientEData = this.delayedEData;
		this.delayedEData = this.eData;
		this.dir = self.getVelocity() == 0 ? this.dir : self.getVelocity() > 0 ? 1 : -1;
		this.lastTSDC = timeSinceDirChange;
		this.timeSinceDirChange ++;
		this.eData = e;
		if(delayedEData != null && this.ancientStats != null) {
			this.latDir = eData.bearingRadians() == 0 ? this.latDir : eData.bearingRadians() * dir > 0 ? 1 : -1;
			this.laggingVel = delayedStats.getVelocity();
			final double accelMag = Math.abs(statsPast.getVelocity()) - Math.abs(laggingVel);
			this.delayedAccel = accel;
			this.accel = accelMag == 0 ? 0 : accelMag > 0 ? 1 : -1;
			this.ancientLatDir = this.delayedLatDir;
			this.delayedDir = this.laggingVel == 0 ? this.delayedDir : this.laggingVel > 0 ? 1 : -1;
			this.laggingBearing = delayedEData.bearingRadians();
			this.delayedLatDir = this.laggingBearing == 0 ? this.delayedLatDir : this.laggingBearing * this.delayedStats.getVelocity() > 0 ? 1 : -1;
			//this.delayedLatDir = laggingBearing == 0 ? this.delayedLatDir : laggingBearing * delayedDir > 0 ? 1 : -1;
			if(delayedDir != dir) this.timeSinceDirChange = 0l;
			this.headingChangeRate = Utils.normalRelativeAngle(
					(this.statsPast.getHeadingRadians()-this.delayedStats.getHeadingRadians())
			)/(double)(this.statsPast.getTime() - this.delayedStats.getTime());

			if(delayedStats != null && eData.hasShot()) {
				final double bearingFrom = //Utils.normalRelativeAngle(eData.absBearingTo() + Math.PI);
                                        Math.atan2(statsPast.getX() - delayedEData.getX(), statsPast.getY() - delayedEData.getY());
				final long shotTime = statsPast.getTime();
				_waves.add(
					new BulletWave(
						BINS,
						delayedEData.getX(), delayedEData.getY(),
						bearingFrom,
						eData.shotPower(),
						shotTime,
						ancientLatDir,
						calcKey()
					)
				);
				//devineDanger(_waves.get(_waves.size()-1));
				//_dangerCurves.add(devineDanger(_waves.get(waves.size()-1)));
			}
		}
		
		cullWaves();
		
		return surfWave != null;
	}
	
	private void cullWaves() {
		surfWave = null;
		double maxDamage = 0;
		long minTTI = Long.MAX_VALUE;
		final Iterator<BulletWave> braver = _waves.iterator();
		final long currTime = self.getTime();
		final Point me = new Point();
		me.setLocation(self.getX(), self.getY());
		while(braver.hasNext()) {
			final BulletWave w = braver.next();
			if(w.contains(me, currTime)) {
				braver.remove();
			}
			//
			final long ttI = w.timeTillImpact(me, currTime);
			if(ttI < minTTI && ttI > 1.7) {
				minTTI = ttI;
				maxDamage = Rules.getBulletDamage(w.power());
				surfWave = w;
				timeOfImpact = currTime + (long)Math.ceil(ttI);
			} else if(ttI <= (minTTI + 2) && ttI > 1.7 && Rules.getBulletDamage(w.power()) > 1.5d*maxDamage) {
				maxDamage = Rules.getBulletDamage(w.power());
				surfWave = w;
				timeOfImpact = currTime + (long)Math.ceil(ttI);
				minTTI = Math.min(ttI, minTTI);
			}
		}
		final Iterator<Bullet> bator = _shaders.iterator();
		while(bator.hasNext()) {
			if(!bator.next().isActive())
				bator.remove();
		}
	}
	
	private double[] calcKey() {
		final int pastDir = statsPast.getVelocity() == 0 ? dir : statsPast.getVelocity() > 0 ? 1 : -1;
		final Point eCenter = new Point();
		eCenter.setLocation(statsPast.getX(), statsPast.getY());
		double eGoing = statsPast.getHeadingRadians() - (pastDir-1)/2 * Math.PI;
		double wallSpace = Helpers.calcWallSpace(eCenter, eGoing);
		eGoing += Math.PI;
		eGoing = Utils.normalAbsoluteAngle(eGoing);
		double revWallSpace = Helpers.calcWallSpace(eCenter, eGoing);
		return new double[] {
			delayedEData.distance() / Boque.MAX_DIST,
			Math.abs(Math.cos(delayedEData.bearingRadians())),
			Math.abs(statsPast.getVelocity()) / Rules.MAX_VELOCITY,
			Math.abs(Math.abs(Math.sin(delayedEData.bearingRadians())) * statsPast.getVelocity()) / Rules.MAX_VELOCITY,
			Math.min(1d, wallSpace),
			Math.min(1d, revWallSpace),
			Helpers.clamp((this.headingChangeRate*delayedEData.eSide()/Rules.MAX_TURN_RATE_RADIANS + 1d)/2d, 0, 1d),
			1d/(1d + TIME_DECAY_CONST*lastTSDC),
			(delayedAccel + 1d) / 2d,
			eData.shotPower() / 3d,
		};
	}
	
	void saveHit(final Bullet b, final long tOI) {
		final BulletWave w = getLiveMatch(b, tOI);
		if(w == null) {
			System.out.println("Dropped Incoming Bullet");
			return;
		}
		final Point ofImpact = new Point();
		ofImpact.setLocation(statsPast.getX(), statsPast.getY());
		_attackMap.put(w.key(), w.getFactor(ofImpact));
		_waves.remove(w);
	}
	
	void planRoute() {
	
		if(surfWave == null) {
			//this.destination.setLocation(
			//	Math.random() * Boque.WIDTH + 18d,
				//Math.random() * Boque.HEIGHT + 18d
			//);
			return;
		};
		
///////////////////////////////////////////////////////////////////////////////////////////

		
		final ClownMobile forwardRacer = new ClownMobile(desiredDir);
		
		final Point bowPoint = forwardRacer.exhaust(surfWave);

		final ClownMobile backwardRacer = new ClownMobile(-1*desiredDir);
		
		final Point sternPoint = backwardRacer.exhaust(surfWave);
		
		bowP.setLocation(bowPoint);
		sternP.setLocation(sternPoint);

		findSafest(bowPoint, sternPoint);

	}
	
	private void devineDanger(final BulletWave wave) {
	
	//	final double[] dangerCurve = new double[BINS];

		int numNeighbors = Math.min(NEIGHBORS, _attackMap.size());
		Arrays.fill(distances, 0);
		
		final double[] neighborAngles = new double[NEIGHBORS];
		//Arrays.fill(dangerCurve, 0);
		
		final double[][] neighbors =
			Helpers.findKNN(
				numNeighbors,
				wave.key(),
				_attackMap.keySet().toArray(double[][]::new),
				distances
			);
			
		int count = 0;
		for(int i = 0; i < neighbors.length; i ++, count ++) {
			neighborAngles[i] = angleFromFactor(wave, _attackMap.get(neighbors[i]));
		}

		final double stdDev = eData.angularWidth();
		double maxDanger = 0d;
		
		final Phanto[] phantoms = wave.exposeIt();
		for(int b = 0; b < BINS; b ++) {
			//int bin = wave.orbitDir() > 0 ? b : BINS-1-b;
			final double angleFromBin = angleFromBin(wave, b);
			for(int n = 0; n < count; n ++) {
				if(phantoms[b].isDead()) continue;
			//	if(!phantoms[n].intersects(
				final double x = Utils.normalRelativeAngle(
					neighborAngles[n] - angleFromBin
				) / (stdDev);
				//dangerCurve[b] += Math.exp(-0.5d*x*x) / distances[n];
				//phantoms[b].setDanger(dangerCurve[b]);
				phantoms[b].setDanger(phantoms[b].getDanger() + Math.exp(-0.5d*x*x) / (Math.sqrt(stdDev*distances[n]*distances[n]*Math.PI+1)));
				maxDanger = Math.max(maxDanger, phantoms[b].getDanger());
			}
		}	

	}
		
	private void findSafest(final Point bowPoint, final Point sternPoint) {
		
		
		/*for(int b = 0; b < BINS; b ++) {
			int bin = surfWave.orbitDir() > 0 ? b : BINS-1-b;
			phantoms[b].setDanger(dangerCurve[bin]);
		}*/
		
		
		//for(final BulletWave ws : _waves) {
		//	devineDanger(ws);
		//}
		devineDanger(surfWave);
		
		final Phanto[] phantoms = surfWave.exposeIt();		
		
		double dangerBow = 0, dangerStern = 0;
		for(int b = 0; b < BINS; b ++) {
			//boolean intersected = false;
			if(phantoms[b].intersects(bowPoint, timeOfImpact + 10)) {
				dangerBow += phantoms[b].getDanger();
			//	intersected = true;
				}
			if(phantoms[b].intersects(sternPoint, timeOfImpact + 10)) {
				dangerStern += phantoms[b].getDanger();
			//	intersected = true;
				}
		//		if(!intersected) phantoms[b].setDanger(0d);
		}
		
	/*	final double bowFactor = surfWave.getFactor(bowPoint);
		final double sternFactor = surfWave.getFactor(sternPoint);
		final int bowBin =(int)Helpers.clamp(bowFactor*HALF_BIN + HALF_BIN, 0, BINS);
		final int sternBin = (int)Helpers.clamp(sternFactor*HALF_BIN + HALF_BIN, 0, BINS);
		
		final int halfBinWidth = (int)((eData.angularWidth() / (2d*surfWave.mEA())) * BINS);
		

		//double dangerBow = 0, dangerStern = 0;
		for(int i = bowBin-halfBinWidth; i < bowBin + halfBinWidth; i ++) {
			final int index = (int)Helpers.clamp(i, 0, BINS - 1);
		//	if(!phantoms[index].isDead())
				dangerBow += phantoms[index].getDanger();
		}
		for(int i = sternBin-halfBinWidth; i < sternBin + halfBinWidth; i ++) {
			final int index = (int)Helpers.clamp(i, 0, BINS-1);
		//	if(!phantoms[index].isDead())
				dangerStern += phantoms[index].getDanger();
		}*/


		//if(dir == 1) {
			if(dangerBow <= dangerStern) {
				destination.setLocation(bowPoint);
				//desiredDir = 1;
			}
			else {
				destination.setLocation(sternPoint);
				//desiredDir *= -1;
			}
		//	return;
		//}
	
		/*if(dangerStern <= dangerBow) {
			destination.setLocation(sternPoint);
			desiredDir = -1;
			return;
		}
		
		destination.setLocation(bowPoint);
		desiredDir = 1;*/
		
	}
	
	void driveToDest() {
	
		if(eData == null) {
			this.destination.setLocation(
				(int)(Math.random() * (Boque.WIDTH) + 18d),
				(int)(Math.random() * Boque.HEIGHT + 18d)
			);
			return;
		}
		final Point center = new Point();
		center.setLocation(self.getX(), self.getY());		
	
		if(surfWave == null) {
		
			final Point contPoint = Helpers.projectToPoint(self.getX(),self.getY(),self.getHeadingRadians(), desiredDir*75d);
			final Point revPoint = Helpers.projectToPoint(self.getX(),self.getY(),self.getHeadingRadians(), -1d*desiredDir*75d);
			final Point eCent = new Point();
			eCent.setLocation(eData.getX(), eData.getY());
			
			if(contPoint.distance(eCent) < -25d + revPoint.distance(eCent)) { desiredDir *= -1; }
		
			double desHead = Utils.normalAbsoluteAngle(
				Math.atan2(
					eData.getX() - self.getX(),
					eData.getY()- self.getY()
					//Tactics.this.eCenter.getX() - center.getX(),
					//Tactics.this.eCenter.getY() - center.getY()
				) - eData.eSide() * (Helpers.HALF_PI
					//)
				+ 3.618d * Rules.MAX_TURN_RATE_RADIANS)//Rules.getTurnRateRadians(Helpers.abs(velocity))
				//)
			);
		
			desHead = Utils.normalRelativeAngle( desHead - eData.eSide() * (desiredDir-1)/2 * (Math.PI+ 2d * 3.618d * Rules.MAX_TURN_RATE_RADIANS));	
			desHead = Utils.normalAbsoluteAngle(Helpers.wallSmooth(center, desHead, dir, eData.eSide()));
			double turnAmount = Utils.normalRelativeAngle(desHead - self.getHeadingRadians());
		
		 	int goDir = 1;
			if(Math.abs(turnAmount) > Math.PI/2d) {
				turnAmount = Utils.normalRelativeAngle(turnAmount - Math.PI);
				goDir = -1;
			}
			self.setTurnRightRadians(turnAmount);
			self.setAhead(Math.abs(Math.cos(turnAmount)) * goDir * 100d);
				return;
		}

		final double absBearingToDest =
			Math.atan2(destination.x - self.getX(), destination.y - self.getY());
		double bearingToDest =
			Utils.normalRelativeAngle(
				absBearingToDest
				-
				self.getHeadingRadians()
			);
		int goDir = 1;
		if(Math.abs(bearingToDest) > Math.PI*0.5d) {
			bearingToDest = Utils.normalRelativeAngle(
				Math.PI - bearingToDest
			);
			goDir= -1;
		}
	
		final double wallSpaceMult = Helpers.calcWallSpace(center, Utils.normalAbsoluteAngle(self.getHeadingRadians() - (goDir-1)/2*Math.PI)) < 0.15d ? 1d : 2d;
		
			self.setTurnRightRadians(goDir * bearingToDest);
			self.setAhead(
				goDir *
				wallSpaceMult*Helpers.distanceFromPoint(
					self.getX(), self.getY(), destination
				)
			);
			
	}
	
	private BulletWave getLiveMatch(final Bullet b, final long impactTime) {
		for(final BulletWave w : _waves) {
			if(w.matches(b, impactTime)) return w;
		} return null;
	}
	
	private double angleFromBin(final BulletWave surfWave, final int bin) {
		double thetaOffset = ((double)(bin-HALF_BIN)/(double)HALF_BIN) * surfWave.orbitDir() * surfWave.mEA();
		return Utils.normalAbsoluteAngle(surfWave.baseAngle() + thetaOffset);
	}
	
	private double angleFromFactor(final BulletWave surfWave, final double factor) {
		return Utils.normalAbsoluteAngle(factor * surfWave.orbitDir() * surfWave.mEA() + surfWave.baseAngle());
	}
	
	void paint(final Graphics2D g2) {
		final long currTime = self.getTime();
		final int hash = surfWave == null ? 0 : surfWave.hashCode();
		for(final BulletWave w : _waves) {
			w.paintSkelly(g2, currTime, hash);
			w.paintBaseAngle(g2, currTime);
			//if(surfWave != null && w.equals(surfWave))
				w.paintPhantoms(g2, currTime-1);
		}
		g2.setColor(Color.GREEN);
		for(final Bullet b : _shaders) {
			g2.draw(
				Helpers.projectToLine(
					b.getX(), b.getY(),
					b.getHeadingRadians(), -b.getVelocity()
				)
			);
		}
		g2.draw(
			new Rectangle2D.Double(
				destination.x - 18d, destination.y-18d,
				36d, 36d
			)
		);
		g2.setColor(Color.ORANGE);
		g2.draw(
			new Rectangle2D.Double(
				sternP.x -18d, sternP.y-18d,
				36d, 36d
			)
		);
		g2.setColor(Color.BLUE.brighter());
		g2.draw(
			new Rectangle2D.Double(
				bowP.x - 18d, bowP.y - 18d,
				36d, 36d
			)
		);
	}
	
	
	class ClownMobile {
		private final long currTime;
		private Point center;
		private double heading, velocity, desHead;
		private int futures, slamDir, goDir, eSide;
		
		ClownMobile(final int slamDir) {
			this.eSide = eData.eSide();
			this.center = new Point();
			this.center.setLocation(self.getX(), self.getY());
			this.heading = self.getHeadingRadians();
			this.velocity = self.getVelocity();
			this.futures = 0;
			this.currTime = self.getTime();
			this.slamDir = slamDir;
			this.goDir = slamDir;
		}
		
		Point exhaust(final Wave surfWave) {
			int counter = 0;
			while(counter ++ < 100) {
				 if(stepAndCheck(surfWave)) break;
			}
			return this.center;
		}
		
/// ADDED SLAM DIR TO ESCAPE ANGLE BONUS
		private boolean stepAndCheck(final Wave surfWave) {
			//update heading
			double desHead = Utils.normalAbsoluteAngle(
				Math.atan2(
					surfWave.sourceX() - center.x,
					surfWave.sourceY() - center.y
				) - eSide * (Math.PI/2d
					+ 4.3618d * Rules.MAX_TURN_RATE_RADIANS)//Rules.getTurnRateRadians(Helpers.abs(velocity))
			);
			desHead -= eSide * (slamDir-1)/2 * (Math.PI + 2d * 4.3618d * Rules.MAX_TURN_RATE_RADIANS);//Rules.getTurnRateRadians(Helpers.abs(myVelocity)));
			//desHead = Helpers.wallSmooth(center,  desHead, slamDir, eSide);
			desHead = Helpers.wallSmooth(center, desHead, goDir, eSide);
			
			double turnAmount = Utils.normalRelativeAngle(desHead - heading);
			
			goDir = 1;
			if(Math.abs(turnAmount) > Math.PI/2d) {
				turnAmount = Utils.normalRelativeAngle(turnAmount - Math.PI);
				//heading = Utils.normalAbsoluteAngle(heading + Helpers.PI);
				goDir = -1;
			}
		//	double turnAmount = Utils.normalRelativeAngle(desHead - heading);
			
			//goDir = 1;
			//if(Math.abs(turnAmount) > Math.PI/2d) {
		//		turnAmount = Utils.normalRelativeAngle(turnAmount-Math.PI);
		//		goDir = -1;
		//	}
		//	goDir = 1;
			final double maxTurn = Rules.getTurnRateRadians(Math.abs(velocity));
			turnAmount = Helpers.clamp(turnAmount, -maxTurn, maxTurn);
			
			this.heading = Utils.normalAbsoluteAngle(heading + turnAmount);

			this.velocity += (goDir * velocity >= 0 ? Rules.ACCELERATION*(goDir) : Rules.DECELERATION*(goDir));
			
			this.velocity = Helpers.clamp(this.velocity, -8d, 8d);
			
			center.setLocation(Helpers.projectToPoint(center.x, center.y, heading, Math.cos(turnAmount)*velocity));
			
			center.setLocation(
				Helpers.clamp(center.x, 20d, Boque.WIDTH+40d),
				Helpers.clamp(center.y, 20d, Boque.HEIGHT+40d)
			);
			
			futures ++;
			return surfWave.intersects(this.center, currTime + futures);
		}
	}

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Wave {

	private final Ellipse2D headRing, tailRing;
	private final Point source;
	private final double[] key, fireAngles;
	private final double power, velocity, baseAngle, mEA,
			minCrimp, maxCrimp, minOffset, maxOffset;
	private long timeOfShot;
	private int orbitDir;
	
	double[] key() { return key; }
	double sourceX() { return source.x; }
	double sourceY() { return source.y; }
	double velocity() { return velocity; }
	double power() { return power; }
	double baseAngle() { return baseAngle; }
	double mEA() { return mEA; }
	double minCrimp() { return minCrimp; }
	double maxCrimp() { return maxCrimp; }
	double minOffset() { return minOffset; }
	double maxOffset() { return maxOffset; }
	long timeOfShot() { return timeOfShot; }
	int orbitDir() { return orbitDir; }
	
	Wave(final double sourceX, final double sourceY, final double baseAngle, final double bPower, final long timeOfShot,
				final int orbitDir, final double[] key, final double minCrimp, final double maxCrimp, final double minOffset, final double maxOffset,
			final double[] fireAngles) {
		this.source = new Point();
		source.setLocation(sourceX, sourceY);
		this.power = bPower;
		this.velocity = Rules.getBulletSpeed(power);
		this.baseAngle = baseAngle;
		this.timeOfShot = timeOfShot;
		this.headRing = new Ellipse2D.Double(sourceX - velocity, sourceY - velocity, 2*velocity, 2*velocity);
		this.tailRing = new Ellipse2D.Double(sourceX, sourceY, 1d, 1d);
		this.key = Arrays.copyOf(key, key.length);
		this.mEA = Math.asin(8d/velocity);
		this.orbitDir = orbitDir;
		this.minCrimp = minCrimp;
		this.maxCrimp = maxCrimp;
		this.minOffset = minOffset;
		this.maxOffset = maxOffset;
		this.fireAngles = Arrays.copyOf(fireAngles, fireAngles.length);
	}
	
	void setSkeleton(final long futTime) {
		double distTravelled = (futTime - timeOfShot) * velocity;
		this.headRing.setFrame(source.x - distTravelled, source.y - distTravelled, 2*distTravelled, 2*distTravelled);
		
	distTravelled = (futTime - 1 - timeOfShot) * velocity;
		this.tailRing.setFrame(
			source.x - distTravelled,
			source.y - distTravelled,
			2d*(distTravelled),
			2d*(distTravelled)
		); 
	}
	
	boolean intersects(final Point p, final long futTime) {
		setSkeleton(futTime);
		final Rectangle2D enemySq = new Rectangle2D.Double(p.x-20d, p.y-20d, 40d, 40d);
		return headRing.intersects(enemySq) || tailRing.intersects(enemySq);
	}
	
	boolean breaks(final Point p, final long futTime) {
		setSkeleton(futTime);
		return headRing.contains(p);
	}
	
	boolean contains(final Point p, final long futTime) {
		setSkeleton(futTime);
		final Rectangle2D enemySq = new Rectangle2D.Double(p.x-20d, p.y-20d, 40d, 40d);
		return tailRing.contains(enemySq);
	}
	
	double getFactor(final Point p) {
		final double resultBearing =
			Math.atan2(p.x - source.x , p.y - source.y);
		final double angleDiff = Utils.normalRelativeAngle(resultBearing - baseAngle);
		return Helpers.clamp(
			angleDiff * orbitDir / mEA,
			-1d, 1d
		);
	}
	
	int[] getHitIndices(final Point p, final long futTime) {
		double distTravelled = (futTime - timeOfShot) * velocity;
		final int[] hits = new int[fireAngles.length];
		final Rectangle2D target = new Rectangle2D.Double(
			p.x - 20, p.y - 20, 40, 40
		);
		for(int fa = 0; fa < fireAngles.length; fa++) {
			final Line2D ray = new Line2D.Double(
				source.x, source.y,
				distTravelled*Math.sin(fireAngles[fa]),
				distTravelled*Math.cos(fireAngles[fa])
			);
			hits[fa] = target.intersectsLine(ray) ? 1 : 0;
		}
		return hits;
	}
	
	long timeTillImpact(final Point p, final long futTime) {
		final double distTravelled = (futTime - timeOfShot) * velocity;
		final double distTo = source.distance(p);
		return (long)Math.ceil((distTo - distTravelled) / velocity);
	}
	
	void paintSkelly(final Graphics2D g2, final long futTime, final int surfHash) {
		final Color color = this.hashCode() == surfHash ? Color.BLUE.brighter().brighter() : Color.RED;
		setSkeleton(futTime);
		g2.setColor(color.darker());
		g2.draw(headRing);
		g2.setColor(color.darker().darker().darker());
		g2.draw(tailRing);
	}
	
	void paintBaseAngle(final Graphics2D g2, final long futTime) {
		final double distTravelled = (futTime - timeOfShot) * velocity;
		final Point tailPoint = Helpers.projectToPoint(source.x, source.y, baseAngle, distTravelled - velocity);
		final Point headPoint = Helpers.projectToPoint(source.x, source.y, baseAngle, distTravelled);
		g2.draw(new Line2D.Double(tailPoint.x, tailPoint.y, headPoint.x, headPoint.y));
	}
	

	void paintFireAngles(final Graphics2D g2, final long futTime) {
		final double distTravelled = (futTime - timeOfShot) * velocity;
		final Point regPoint = Helpers.projectToPoint(source.x, source.y, fireAngles[0], distTravelled);
		final Point asPoint = Helpers.projectToPoint(source.x, source.y, fireAngles[1], distTravelled);
		g2.setColor(Color.MAGENTA.brighter());
		g2.draw(new Line2D.Double(source.x,source.y,regPoint.x,regPoint.y));
		g2.setColor(new Color(0x94, 0xF0, 0x6C));
		g2.draw(new Line2D.Double(source.x,source.y,asPoint.x,asPoint.y));
	}
	
	boolean matches(final Bullet b, final long futTime) {
		final double distTo = Math.sqrt(
			(b.getX()-sourceX())*(b.getX()-sourceX())
			+
			(b.getY()-sourceY())*(b.getY()-sourceY())
		);
		final double distTravelled = (futTime - timeOfShot()) * velocity();
		return Math.abs(b.getVelocity() - velocity()) < .3d
			&& Math.abs(distTravelled - distTo) < velocity();
	}

	@Override
	public boolean equals(final Object o) {
		if(o instanceof Wave) {
			return ((Wave)o).hashCode() == this.hashCode();
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		int hash = 0xf0f0f0f;
		
		hash ^= Long.hashCode(timeOfShot);
		hash ^= Double.hashCode(power);
		//hash ^= Arrays.hashCode(key);
		return hash;
	}

}

class BulletWave extends Wave {

	private Phanto[] phantoms;
	BulletWave(final int phantoCount, final double sourceX, final double sourceY, final double baseAngle, final double bPower, final long timeOfShot, final int orbitDir, final double[] key) {
		super(sourceX, sourceY, baseAngle,bPower, timeOfShot, orbitDir, key, 0, 0, 0, 0, new double[]{0});
		final double mEA = Math.asin(8d/Rules.getBulletSpeed(bPower));
		double phantAngle = Utils.normalAbsoluteAngle(baseAngle - mEA * orbitDir);
		final double angleInc = 2d*mEA / (double) phantoCount;
		phantoms = new Phanto[phantoCount];
		for(int i = 0; i < phantoCount; i ++) {
			phantoms[i] = new Phanto(sourceX, sourceY, phantAngle, bPower, timeOfShot + 1);
			phantAngle += angleInc * orbitDir;
			phantAngle = Utils.normalAbsoluteAngle(phantAngle);
		}
	}
	
	Phanto[] exposeIt() {
		return phantoms;
	}
	
	void runThroughBullets(final List<Bullet> bullets, final long currTime) {
		//final List<Line2D> useful = new ArrayList<>(bullets.size());
	//	for(final Bullet b : bullets) {
//			useful.add(Helpers.projectToLine(b.getX(), b.getY(), b.getHeadingRadians(), b.getVelocity()));
		//}
		for(final Phanto p : phantoms) {
			p.checkBulletCollision(bullets, currTime);
		}
	}
	
	boolean matches(final Bullet b, final long futTime) {
		final double distTo = Math.sqrt(
			(b.getX()-super.sourceX())*(b.getX()-super.sourceX())
			+
			(b.getY()-super.sourceY())*(b.getY()-super.sourceY())
		);
		final double distTravelled = (futTime - super.timeOfShot()) * super.velocity();
		return Math.abs(b.getVelocity() - super.velocity()) < .3d
			&& Math.abs(distTravelled - distTo) < super.velocity();
	}
	
	void paintPhantoms(final Graphics2D g2, final long futTime) {
		
		double maxDanger = 0d;
		for(int b = 0; b < phantoms.length; b ++) {
			maxDanger = Math.max(maxDanger, this.phantoms[b].getDanger());
		}
		
		for(final Phanto p : phantoms) {
			if(p.isDead())
				g2.setColor(Color.GRAY);
			else{
				int green = (int) Math.min(255, Math.round(255*3*p.getDanger()/maxDanger)), blue = (int) Math.min(255, Math.round(255*6*p.getDanger()/maxDanger)), red = (int)Math.min(255, Math.round(255*p.getDanger()/maxDanger));
				if(blue > 245 && green > 245) blue = 0;
				if(green > 245 && red > 245) green = 0; 
				g2.setColor(new Color(red, green, blue));
			}
			g2.draw(p.getBody(futTime));
		}
	}

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

class ScanEvent {
	private final ScannedRobotEvent e;
	private final Point targetCenter;
	private final double eAdvVel, eLatVel, absBearingTo, bearingFrom, angularWidth, shotPower;
	private final int eSide, eDir, eLatDir, accel;
	private final boolean hasShot;
	
	ScanEvent(final ScannedRobotEvent e, final double selfX, final double selfY,
				final double selfHeading, final int currDir, final int currLatDir,
		final double currEnergy, final double currVel)
	{
		this.e = e;
		this.absBearingTo =
			Utils.normalRelativeAngle(
				e.getBearingRadians()
					+
				selfHeading
			);
		this.bearingFrom =
			Utils.normalRelativeAngle(
				e.getHeadingRadians() - absBearingTo
			);
		this.eLatVel = Math.sin(this.bearingFrom)*e.getVelocity();
		this.eAdvVel = Math.cos(this.bearingFrom)*e.getVelocity();
		this.eSide = e.getBearingRadians() >= 0 ? 1 : -1;
		
		this.targetCenter = Helpers.projectToPoint(selfX, selfY, absBearingTo, e.getDistance());
		
		this.eDir = e.getVelocity() == 0 ? currDir : e.getVelocity() > 0 ? 1 : -1;
		this.eLatDir = this.eLatVel == 0 ? currLatDir : eLatVel > 0 ? 1 : -1;
		
		this.angularWidth = 2d*Math.atan(20.5d / e.getDistance());
		
		final double eDelta = currEnergy - e.getEnergy();
		final double velDelta = e.getVelocity() - currVel;
		
		this.hasShot = (Math.abs(velDelta) < 2.08 && eDelta > 0 && eDelta <= 3);
		
		this.accel = currVel == e.getVelocity() ? 0 : Math.abs(currVel) > Math.abs(e.getVelocity()) ? 1 : -1;
		this.shotPower = hasShot ? eDelta : 0d;
	}
	
	double angularWidth() { return angularWidth; }
	double velocity() { return e.getVelocity(); }
	double headingRadians() { return e.getHeadingRadians(); }
	double bearingRadians() { return e.getBearingRadians(); }
	double distance() { return e.getDistance(); }
	double eAdvVel() { return this.eAdvVel; }
	double eLatVel() { return this.eLatVel; }
	double absBearingTo() { return this.absBearingTo; }
	double bearingFrom() { return this.bearingFrom; }
	double getEnergy() { return e.getEnergy(); }
	double getX() { return targetCenter.x; }
	double getY() { return targetCenter.y; }
	double shotPower() { return shotPower; }
	int eSide() { return this.eSide; }
	int eDir() { return this.eDir; }
	int eLatDir() { return this.eLatDir; }
	int accel() { return this.accel; }
	boolean hasShot() { return this.hasShot; }
	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Phanto {
	private final Line2D body;
	private final double power, velocity, xVel, yVel,
		sourceTailX, sourceTailY, sourceHeadX, sourceHeadY;
	private final long timeOfShot;
	
	private double danger;
	private boolean isDead;
	
	Phanto(final double sourceX, final double sourceY, final double heading, final double power, final long timeOfShot) {
		this.power = power;
		this.timeOfShot = timeOfShot;
		this.velocity = Rules.getBulletSpeed(power);
		this.sourceTailX = sourceX;
		this.sourceTailY = sourceY;
		xVel = Math.sin(heading) * velocity;
		yVel = Math.cos(heading) * velocity;
		this.sourceHeadX = sourceX + xVel;
		this.sourceHeadY = sourceY + yVel;
		body = new Line2D.Double(sourceTailX, sourceTailY, sourceHeadX, sourceHeadY);
		isDead = false;
	}
	double update(final Rectangle2D collider, final long futTime) {
		if(isDead) return 0d;
		final double distX = xVel * (futTime - timeOfShot);
		final double distY = yVel * (futTime - timeOfShot);
		body.setLine(sourceTailX + distX, sourceTailY + distY, sourceHeadX + distX, sourceHeadY + distY);
		return collider.intersects(body.getBounds()) ? danger : 0d;
	}
	void checkBulletCollision(final List<Bullet> bullets, final long futTime) {
		if(isDead) return;
		final double distX = xVel * (futTime - timeOfShot);
		final double distY = yVel * (futTime - timeOfShot);
		body.setLine(sourceTailX + distX, sourceTailY + distY, sourceHeadX + distX, sourceHeadY + distY);
		for(final Bullet b : bullets) {
			final Line2D bull = Helpers.projectToLine(b.getX(), b.getY(), b.getHeadingRadians(), b.getVelocity());
			if(bull.intersectsLine(body)) {
				isDead = true;
				break;
			}
		}
	}
	boolean intersects(final Point p, final long futTime) {
		if(isDead) return false;
		final double distX = xVel * (futTime - timeOfShot);
		final double distY = yVel * (futTime - timeOfShot);
		body.setLine(sourceTailX, sourceTailY, sourceHeadX + distX, sourceHeadY + distY);
		return body.intersects(new Rectangle2D.Double(p.x-20d, p.y-20d, 40d, 40d));//.intersects(body.getBounds());
	}
	void setDanger(final double danger) {
		this.danger = danger;
	}
	double getDanger() {
		return danger;
	}
	Line2D getBody(final long futTime) {
		final double distX = xVel * (futTime - timeOfShot);
		final double distY = yVel * (futTime - timeOfShot);
		body.setLine(sourceTailX + distX, sourceTailY + distY, sourceHeadX + distX, sourceHeadY + distY);
		return body;
	}
	boolean isDead() { return isDead; }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Helpers {
	static final double HALF_PI =  Math.PI/2d, THREE_OVER_TWO_PI = 3d*HALF_PI, TWO_PI = 2d*Math.PI;
	
	static Point projectToPoint(final double x, final double y, final double angle, final double distance) {
		final Point p = new Point();
		p.setLocation(x + distance * Math.sin(angle), y + distance * Math.cos(angle));
		return p;
	}
	
	static Line2D projectToLine(final double x, final double y, final double angle, final double distance) {
		return new Line2D.Double(x, y, x + distance*Math.sin(angle), y + distance * Math.cos(angle));
	}
	
	static double distanceFromPoint(final double x, final double y, final Point p) {
		final Point q = new Point();
		q.setLocation(x, y);
		return q.distance(p);
	}
	
	static double clamp(final double value, final double low, final double high) {
		assert(low < high);
		return Math.max(low, Math.min(value, high));
	}


	static double getNewVelocity(double velocity, double distance) {
    	return getNewVelocityLimited(velocity, distance, Rules.MAX_VELOCITY);
    }

	static double getNewVelocityLimited(final double velocity, final double distance, final double maxVel) {
		if(distance<0)
    	 	return -getNewVelocityLimited(-velocity,-distance,maxVel);
    	double highestVelocity = getMaxVelocity(distance); // highest velocity without overshooting
    	double wantedVelocity = Math.min(highestVelocity,maxVel);
    	      // the actually wanted velocity by the robot is the highest possible,
    	      // limited by what the robot set by the setMaxVelocity command
    	return getClosestReachableVelocityToVelocity(velocity, wantedVelocity);
    	      // return whatever is closest to that velocity
	}
	
	static double calcWallSpace(final Point eCenter, double eGoing) {
		eGoing = Utils.normalAbsoluteAngle(eGoing);
		final double wallDistLat = eGoing < Math.PI ? (Boque.WIDTH+17.99d-eCenter.getX()) / (Math.cos((Math.PI/2d - eGoing)))
			: eCenter.getX() / (Math.cos((3d*Math.PI/2d - eGoing)));
		eGoing = Utils.normalRelativeAngle(eGoing);
		final double wallDistVirt = Math.abs(Utils.normalRelativeAngle(eGoing)) < Math.PI / 2d  ?
				(Boque.HEIGHT+17.99d-eCenter.getY()) / (Math.cos(eGoing)) : eCenter.getY() / (Math.cos(Math.PI - eGoing));
		 return(float)Math.abs(Math.min(wallDistLat, wallDistVirt) / Boque.MAX_DIST);
	}
	
	static final double[][][] findKNNBoth(final int k, final double[] key, final double[][] data, final double[] distances) {
		final int outSize = Math.min(k, data.length);
		final double[][] asResponse = new double[outSize][];
		final double[][] response = new double[outSize][];
		final double[] asDistances = new double[distances.length];
		if(outSize == 0) return new double[][][] {response, response};
		Arrays.fill(distances, 0f);
		response[0] = data[0];
		asResponse[0] = data[0];
		distances[0] = keyDist(key, data[0]);
		asDistances[0] = keyDistFull(key, data[0]);
		double highestCaptured = distances[0];
		double highestASCaptured = distances[0];
		
		int indexOfHighest = 0;
		int indexOfHighestAS = 0;
		for(int i = 1; i < outSize; i ++) {
			response[i] = data[i];
			asResponse[i] = data[i];
			double dist = keyDist(key, data[i]);
			double asDist = keyDistFull(key, data[i]);
			distances[i] = dist;
			asDistances[i] = asDist;
			
			if(dist > highestCaptured) {
				highestCaptured = dist;
				indexOfHighest = i;
			}
			if(asDist > highestASCaptured) {
				highestASCaptured = asDist;
				indexOfHighestAS = i;
			}
		}
		
		for(int i = outSize; i < data.length; i ++) {
			double dist = keyDist(key, data[i]);
			if(dist < highestCaptured) {
				response[indexOfHighest] = data[i];
				distances[indexOfHighest] = dist;
				highestCaptured = Double.NEGATIVE_INFINITY;
				for(int a = 0; a < k; a ++) {
					if(distances[a] > highestCaptured) {
						highestCaptured = distances[a];
						indexOfHighest = a;
					}
				}
			}
			double asDist = keyDistFull(key, data[i]);
			if(asDist < highestASCaptured) {
				asResponse[indexOfHighestAS] = data[i];
				asDistances[indexOfHighestAS] = asDist;
				highestASCaptured = Double.NEGATIVE_INFINITY;
				for(int a = 0; a < k; a ++) {
					if(asDistances[a] > highestASCaptured) {
						highestASCaptured = asDistances[a];
						indexOfHighestAS = a;
					}
				}
			}
		}
		
		return new double[][][] {response, asResponse};
	}
	
	static final double[][] findKNN(final int k, final double[] key, final double[][] data, final double[] distances) {
		final int outSize = Math.min(k, data.length);
		final double[][] response = new double[outSize][];
		if(outSize == 0) return response;
		Arrays.fill(distances, 1f);
		response[0] = data[0];
		distances[0] = euchKeyDist(key, data[0]);
		double highestCaptured = distances[0];
		
		int indexOfHighest = 0;
		for(int i = 1; i < outSize; i ++) {
			response[i] = data[i];
			double dist = euchKeyDist(key, data[i]);
			distances[i] = dist;
			if(dist > highestCaptured) {
				highestCaptured = dist;
				indexOfHighest = i;
			}
		}
		
		for(int i = outSize; i < data.length; i ++) {
			double dist = euchKeyDist(key, data[i]);
			if(dist < highestCaptured) {
				response[indexOfHighest] = data[i];
				distances[indexOfHighest] = dist;
				highestCaptured = Float.NEGATIVE_INFINITY;
				for(int a = 0; a < k; a ++) {
					if(distances[a] > highestCaptured) {
						highestCaptured = distances[a];
						indexOfHighest = a;
					}
				}
			}
		}
		
		return response;
	}
	
	static final double keyDist(final double[] key1, final double[] key2) {
		double dist = 0f;
		final int endCap = Math.max(key1.length-1, key2.length-1);
		for(int i = 0; i < endCap; i ++) {
			dist += Math.abs(key1[i] - key2[i]);
		}
		return dist;
	}
        
        static final double keyDistFull(final double[] key1, final double[] key2) {
		double dist = 0f;
		final int endCap = Math.max(key1.length-1, key2.length-1);
		for(int i = 0; i <= endCap; i ++) {
			dist += Math.abs(key1[i] - key2[i]);
		}
		return dist;
	}
        

	static final double euchKeyDist(final double[] key1, final double[] key2) {
		double dist = 0f;
		final int endCap = Math.max(key1.length-1, key2.length-1);
		for(int i = 0; i < endCap; i ++) {
			dist += Math.abs(key1[i] - key2[i]);
		}
		return dist;
	}
	
	static final double euchKeyDistFull(final double[] key1, final double[] key2) {
		double dist = 0f;
		final int endCap = Math.max(key1.length-1, key2.length-1);
		for(int i = 0; i <= endCap; i ++) {
			dist += Math.abs(key1[i] - key2[i]);
		}
		return dist;
	}
	
	static double wallSmoothEasy(final Point center, final double heading, final int orbitDir) {
		final Point proj = projectToPoint(center.x, center.y, heading, Boque.WALL_STICK);
		double i = orbitDir/100d;
		while(!Boque.playField.contains(proj) && Math.abs(i) < 314) {
			proj.setLocation(projectToPoint(center.x, center.y, heading + i, Boque.WALL_STICK));
			i += 0.01d * orbitDir;
		}
		return Utils.normalAbsoluteAngle(heading + i);
	}
	
	static double wallSmooth(final Point center, double heading, final int velDir,  final int eSide) {
		
		double desiredAngle = heading;
		
			
		final int latDir = eSide * velDir;
		final double wallSpace;
		final Point future = projectToPoint(center.x, center.y, heading, 469);
		
		//	System.out.println("fut: " + future);
		if(Boque.playField.contains(future)) return heading;

		boolean top = future.getY() > 18d + Boque.HEIGHT,
			bottom = future.getY() < 18,
			left = future.getX() < 18,
			right = future.getX() > 18d + Boque.WIDTH;
			
	//	System.out.println("LURD: " + left + " " + top + " " + right + " " + bottom);
		//NOTE: I invert the heading for negative velocities in the next line... maybe
		final double wallSpaceFact =
			(1d - Math.sqrt((wallSpace=(2d*Math.min(0.5d, Math.abs(calcWallSpace(center, Utils.normalAbsoluteAngle((heading/* + (velDir-1)/2 *Math.PI*/)))))))));// /* = (heading + (velDir-1)/2 *Math.PI /*(Math.PI + 2d * velDir * 2.5d * Rules.getTurnRateRadians(velocity)))*/))))))// * 3d))
				//*wallSpace/*wallSpace/*wallSpace/*wallSpace/*wallSpace*wallSpace*/));
		//System.out.println("ws: " + wallSpaceFact);
		
		final double wallBounceAngle = 2d*Rules.MAX_TURN_RATE_RADIANS/3d; //Math.PI/12d;
		
		
		switch(latDir) {
			case 1:
				if(top && right) top = false;
				if(left && top) left = false;
				if(bottom && left) bottom = false;
				if(right && bottom) right = false;
				
			
				if(top) desiredAngle += Utils.normalRelativeAngle(Helpers.HALF_PI - heading + wallBounceAngle) * wallSpaceFact;
				else if(right) desiredAngle += Utils.normalRelativeAngle(Math.PI - heading + wallBounceAngle) * wallSpaceFact;
				else if(bottom) desiredAngle += Utils.normalRelativeAngle(Helpers.THREE_OVER_TWO_PI - heading + wallBounceAngle) * wallSpaceFact;
				else if(left) desiredAngle += Utils.normalRelativeAngle(Helpers.TWO_PI - heading + wallBounceAngle) * wallSpaceFact;
				
				break;
			case -1:
				if(top && right) right = false;
				if(left && top) top = false;
				if(bottom && left) left = false;
				if(right && bottom) bottom = false;
				
				if(top) desiredAngle += Utils.normalRelativeAngle(Helpers.THREE_OVER_TWO_PI - heading - wallBounceAngle) * wallSpaceFact;
				else if(right) desiredAngle += Utils.normalRelativeAngle(0d - heading - wallBounceAngle) * wallSpaceFact;
				else if(bottom) desiredAngle += Utils.normalRelativeAngle(Helpers.HALF_PI - heading - wallBounceAngle) * wallSpaceFact;
				else if(left) desiredAngle += Utils.normalRelativeAngle(Math.PI - heading - wallBounceAngle) * wallSpaceFact;
				
				break;
			default: //System.out.println("quit it please");
				break;
		}
		/*} else {
			final double wallSpace;
		final Point future = project(center, -165d, heading);
		boolean top = future.getY() > Boque.HEIGHT,
			bottom = future.getY() < 35.98,
			left = future.getX() < 35.98,
			right = future.getX() > Boque.WIDTH;
		//NOTE: I invert the heading for negative velocities in the next line
		final double wallSpaceFact =
			(1d - Math.sqrt((wallSpace=(Math.min(0.2d, calcWallSpace(center, Utils.normalAbsoluteAngle((heading/* = (heading + (velDir-1)/2 *Math.PI /*(Math.PI + 2d * velDir * 2.5d * Rules.getTurnRateRadians(velocity)))*/
					/*)))) * 5.2d))
			/*	*wallSpace*wallSpace*wallSpace*wallSpace/*wallSpace*wallSpace*/
		/*));
		double desiredAngle = heading;
		
		final double wallBounceAngle = Math.PI/24d;
		
		
		switch(latDir) {
			case 1:
				if(top && right) top = false;
				if(left && top) left = false;
				if(bottom && left) bottom = false;
				if(right && bottom) right = false;
				
			
				if(top) desiredAngle += Utils.normalRelativeAngle(Helpers.HALF_PI - heading + wallBounceAngle) * wallSpaceFact;
				else if(right) desiredAngle += Utils.normalRelativeAngle(Math.PI - heading + wallBounceAngle) * wallSpaceFact;
				else if(bottom) desiredAngle += Utils.normalRelativeAngle(Helpers.THREE_OVER_TWO_PI - heading + wallBounceAngle) * wallSpaceFact;
				else if(left) desiredAngle += Utils.normalRelativeAngle(Helpers.TWO_PI - heading + wallBounceAngle) * wallSpaceFact;
				
				break;
			case -1:
				if(top && right) right = false;
				if(left && top) top = false;
				if(bottom && left) left = false;
				if(right && bottom) bottom = false;
				
				if(top) desiredAngle += Utils.normalRelativeAngle(Helpers.THREE_OVER_TWO_PI - heading - wallBounceAngle) * wallSpaceFact;
				else if(right) desiredAngle += Utils.normalRelativeAngle(0d - heading - wallBounceAngle) * wallSpaceFact;
				else if(bottom) desiredAngle += Utils.normalRelativeAngle(Helpers.HALF_PI - heading - wallBounceAngle) * wallSpaceFact;
				else if(left) desiredAngle += Utils.normalRelativeAngle(Math.PI - heading - wallBounceAngle) * wallSpaceFact;
				
				break;
			default: System.out.println("quit it please");
				break;
				}
		}*/
		
		return Utils.normalAbsoluteAngle(desiredAngle);
	}





//HadMatter

	static final int sign(final double val) {
		return val >= 0d ? 1 : -1;
	}

	static final Point project(final Point2D source, final double dist, final double heading) {
		final Point answer = new Point();
		answer.setLocation(
			source.getX() + Math.sin(heading)*dist,
			source.getY() + Math.cos(heading)*dist
		);
		return answer;
	}
	
	public static final double wallSmoothSquare(final Point2D pos, final Point2D rotationPOint, double head, final int eSide, final int dir) {
		final int desiredClock = eSide * dir;
		int i = 0;
		while(!Boque.playField.contains(project(pos, 20*dir, head)) && i < 63) {
			head += 0.1d * desiredClock;
			i ++;
		}
		return head;
	}

	static Point2D[] getMaxPosAndCrimps(final AdvancedRobot self, final ScanEvent enemy, final Point eCenter, final double bPower, final List<Point2D> _futures) {
		final Point2D.Double nextBack = new Point2D.Double(eCenter.getX(),eCenter.getY()),
			nextFront = new Point2D.Double(eCenter.getX(),eCenter.getY());
		final double waveVelocity = Rules.getBulletSpeed(bPower);
		final double escAngleBonus  = 0d;
		
		final Point2D myPos = new Point2D.Double(self.getX(), self.getY());
		
		final Point2D myNextPos = myPos;//project(myPos, self.getVelocity(), self.getHeadingRadians());
		
		final Point2D frontCrimp = new Point2D.Double(eCenter.getX(),eCenter.getY()),
			backCrimp = new Point2D.Double(eCenter.getX(),eCenter.getY());
		_futures.clear();
	//	if(Math.abs(enemy.getVelocity()) <= 2d) {
	//		_futures.add(new Point2D.Double(eCenter.getX(),eCenter.getY()));
	//	}
		final double frac = 1d; //final int enemyDir = sign(enemy.getVelocity());
		final double immEVel = enemy.velocity();
		for(double dir = -1d; dir <= 1d; dir += 2d) {
			Point2D future =
				new Point2D.Double(eCenter.getX(), eCenter.getY());
			double futureEVel = enemy.velocity();//dir*immEVel > 0 ? immEVel + dir : immEVel - 2d*dir;
			//if(futureEVel * immEVel < 0) futureEVel *= 0.5d;
			double bareing = Math.atan2(eCenter.getX() - myNextPos.getX(), eCenter.getY() - myNextPos.getY());
			double runningDir = sign(enemy.velocity()), futDub = 0d;
			double runningLatDir = runningDir*sign(Utils.normalRelativeAngle(enemy.headingRadians() - bareing));
			double futureHeading = bareing - (Math.PI / 2d) * runningDir;
			//futureHeading += runningDir < 0 ? Math.PI : 0d;
			boolean hitWall = false;
			for(int futures = 0;
					futures < 75d && !new Ellipse2D.Double(myNextPos.getX()-waveVelocity*(futures),myNextPos.getY()-waveVelocity*(futures),2*waveVelocity*(futures),2*waveVelocity*(futures))
						.contains(new Rectangle2D.Double(future.getX()-18d,future.getY()-18d,36d,36d)); futDub += 1d/*hitWall ? 0.8d/*Math.max(0.5d, Math.min(0.98,0.5d+Math.abs(Math.abs(futureEVel))/16d)) : 1d*/, futures = (int)Math.floor(futDub)) {
				//futureEVel += dir * eLatDir > 0 ? Intra.sign(futureEVel)*dir*eLatDir : 2d*Intra.sign(futureEVel)*dir*eLatDir;
				futureEVel += dir*futureEVel > 0 ? dir : 2*dir;
				futureEVel = clamp(futureEVel, -8d, 8d);
				if(runningDir * futureEVel < 0) futureEVel *= 0.5d;
				runningDir = futureEVel == 0d ? runningDir : sign(futureEVel);
				runningLatDir = runningDir*sign(Utils.normalRelativeAngle(futureHeading - bareing));
				futureHeading = Utils.normalRelativeAngle(bareing - Math.PI/2d*dir);
				futureHeading += runningDir < 0 ? Math.PI : 0d;
				final double smoothedHeading = wallSmoothSquare(future, myNextPos, futureHeading, sign(Utils.normalRelativeAngle(futureHeading - bareing)), (int)dir);
				if(futures == 1 || (!hitWall && Math.abs(Utils.normalRelativeAngle(futureHeading - smoothedHeading)) <= Math.PI/36d)) {
					if(dir < 0) { backCrimp.setLocation(future.getX(),future.getY());}//backCrimp.getX() = future.getX(); backCrimp.getY = future.y; }
					else { frontCrimp.setLocation(future.getX(),future.getY()); }
				} else if(!hitWall){
				//	System.out.println(hitWall + " " + dir + " : " + futureHeading + " " + smoothedHeading);
					hitWall = true;
				}
			//	System.out.println(futureEVel + " dir: " + dir + " eLatDir: " + eLatDir);
				future = project(future, futureEVel, smoothedHeading);
				bareing = Math.atan2(future.getX() - self.getX(), future.getY() - self.getY());
				_futures.add(new Point2D.Double(future.getX(),future.getY()));
			}
			if(dir == -
1d) {
				//nextBack.x = future.x;//
				//nextBack.y = future.y;
				nextBack.setLocation(future);
				//if(hitWall)
				//	System.out.println("Crimp at back: " + backCrimp);
			} else {
				//nextFront.x = future.x;
				//nextFront.y = future.y;
				nextFront.setLocation(future);
				//if(hitWall)
				//	System.out.println("Crimp at front: " + frontCrimp);
			}
		}
		
		return new Point2D[] {nextBack, nextFront, backCrimp, frontCrimp};
	}














	//Voidous
	static double getClosestReachableVelocityToVelocity(double currentVelocity,double wantedVelocity)
{
 // this function assumes wantedVelocity<=Rules.MAXVELOCITY
 // with this function you can basically assume setAhead(Infinity) or setAhead(-Infinity)
 // was called, and you determine the next velocity based on the max velocity
 // set by the robot. For example, if the current velocity is 0 and the max velocity
 // set was 4.0, it would return 1.0. If the current velocity was 8.0, it would return 6.0.
 if(wantedVelocity<0)
  return -getClosestReachableVelocityToVelocity(-currentVelocity,-wantedVelocity);
 if(currentVelocity<0)
 {
  double nextVelocity;
  // we are travelling the wrong way, decelerate
  nextVelocity = currentVelocity + Rules.DECELERATION;
  if(nextVelocity>Rules.ACCELERATION)
   // make sure we can't jump from -0.1 to 1.9 or something
   nextVelocity = Rules.ACCELERATION;
  if(nextVelocity>wantedVelocity)
   // if the wanted velocity is for example 0.5, limit the velocity to that.
   return wantedVelocity;
  else
   // else return the highest possible
   return nextVelocity;
 }
 else
 {
  if(currentVelocity>wantedVelocity)
  {
   // both velocities are positive, but we need to decelerate
   double nextVelocity = currentVelocity - Rules.DECELERATION;
   if(nextVelocity<wantedVelocity)
    // if we can decelerate more than what's wanted, return what's wanted
    return wantedVelocity;
   else
    // else return the closest to it
    return nextVelocity;
  }
  else
  {
   // the wantedVelocity is higher than current
   double nextVelocity = currentVelocity + Rules.ACCELERATION;
   if(nextVelocity>wantedVelocity)
    // if we can accelerate more than what's wanted, return what's wanted
    return wantedVelocity;
   else
    // else return the closest to it
    return nextVelocity;
  }
 }
}
	
	static double getMaxVelocity(double distance)
    {
        if(distance>=20)  // temporary fix, works for maxVelocity==8.0 && maxDecel==2.0
          return Rules.MAX_VELOCITY;
        long decelTime = decelTime(distance);
        double decelDist = (decelTime / 2.0) * (decelTime-1) // sum of 0..(decelTime-1)
            * Rules.DECELERATION;
            
        return ((decelTime - 1) * Rules.DECELERATION) +
            ((distance - decelDist) / decelTime);
    }

    static long decelTime(double distance) {
        long x = 1;
        do {
            // (square(x) + x) / 2) = 1, 3, 6, 10, 15...
            if (distance <= ((square(x) + x) / 2) * Rules.DECELERATION) {
                return x;
            }
            x++;
        } while (true);
    }

    static long square(long i) {
        return i * i;
    }

}
