package bvh.fnr;

import java.awt.geom.Point2D;
/**
 * HulpRoutines
 *
 * Algemene hulpfuncties (overgenomen uit forums op de RobocodeRepository website)
 */
class HulpRoutines implements Constanten{

//if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
   public static double normaliseerRichting(double ang) {
      return ( ang + ( 7 * PI ) ) % TWEEPI - PI;
   }

/**
* bepaal richting van bot tot doel-positie
*/
   public static double bepaalRichting(double Xd, double Yd, double Xb, double Yb ) {
      return Math.atan2( (Xd - Xb), (Yd - Yb) );
   }
   public static double bepaalRichting(Point2D.Double doel, Point2D.Double oorsprong) {
      return Math.atan2( (doel.x-oorsprong.x), (doel.y-oorsprong.y) );
   }

/**
* bepaal afstand tussen twee opgegeven posities:
*/
   public static double bepaalAfstand(Point2D.Double doel, Point2D.Double oorsprong ) {
      return (Math.sqrt((doel.x-oorsprong.x)*(doel.x-oorsprong.x)+(doel.y-oorsprong.y)*(doel.y-oorsprong.y)));
   }

/**
* bepaal naam van bot gestript van het versienummer:
*/
	public static String getNaamZonderVersie(String s) {
      int  i = s.indexOf(" ");
      if (i == -1)  return( s ); // substring not found
      else          return( s.substring(0, i) );
   }
/**
* creeer een filenaam voor de datafile:
*/
	public static String getFilenaam(String s) {
      return( getNaamZonderVersie( s)+".dat" );
   }

/**
* bepaal teken van een waarde
*/
   public static double sign(double a) {
       return (a/Math.abs(a));
   }
   public static int sign(int a) {
       return (a/Math.abs(a));
   }
} // einde Utils
