package ph.movement;
import ph.*;
import ph.intelligence.*;
import java.awt.geom.*;
import robocode.util.*;

// based on PEZ's wiki.etc.RandomMovementBot
public class RandomMovementModule extends RobotModule {
    
    private ModularRobot robot;
    
    private double movementLateralAngle = 0.2;
    
    private Point2D robotLocation;
    private Point2D enemyLocation;
    
    /** Creates a new instance of RandomMovementModule */
    public RandomMovementModule(ModularRobot robot) {
        this.robot=robot;
        obtainBattlefieldInfo();
    }
    
    private void obtainBattlefieldInfo() {
        robotLocation=new Point2D.Double(robot.getX(),robot.getY());
        if(robot.otherRobotsInfo.size()>0) {
            robotInfo ri=(robotInfo)robot.otherRobotsInfo.elementAt(0);
            enemyLocation=new Point2D.Double(ri.x(),ri.y());
        } else {
            enemyLocation=new Point2D.Double(robot.battlefieldWidth/2,
            robot.battlefieldHeight/2);
        }
    }
    
    public void execute() {
        obtainBattlefieldInfo();
        Point2D robotDestination = null;
        double tries = 0;
        
        
        double distance =  robotLocation.distance(enemyLocation);
        doFlattening(distance);
        double bearing = absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle;
        double margin=21;
        do {
            robotDestination = vectorToLocation(bearing,
            distance * (1.1 - tries / 100.0), enemyLocation);
            tries++;
        } while (tries < 100 && !fieldRectangle(margin).contains(robotDestination));
        goTo(robotDestination);
    }
    
    private void doFlattening(double distance) {
        if(robot.fullLeadHits > robot.getRoundNum() / 2 + 1) {
            if(Math.random()<0.05) {
                movementLateralAngle = -movementLateralAngle;
                robot.timeSinceReverse=0;
                return;
            }
        }
        robot.timeSinceReverse++;
    }
    
    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin,
        robot.battlefieldWidth - margin * 2, robot.battlefieldHeight - margin * 2, 75, 75);
    }
    
    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, destination) - robot.getHeadingRadians());
        double turnAngle = Math.atan(Math.tan(angle));
        robot.setTurnRightRadians(turnAngle);
        robot.setAhead(robotLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
        // Hit the brake pedal hard if we need to turn sharply
        robot.setMaxVelocity(Math.abs(robot.getTurnRemaining()) > 33 ? 0 : 8);
    }
    
    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }
    
    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
        sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }
    
    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
}
