package arthord;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Rectangle2D;

/**
 * MannyPacquiao - a robot by Arthur Zielinski
 */
public class MannyPacquiao extends AdvancedRobot
{
	static int direction = 1; // Direction of movement
	static boolean flat; // Flattener active?
	static double bulletVelocity; // Velocity of enemy bullets

	/**
	 * run: MannyPacquiao's default behavior
	 */
	public void run()
	{
		// Start round with flattener off
		flat = false;

		// Constantly block, while also ensuring the radar can re-lock if it slips
		do
		{
			turnRadarRightRadians(1);
		}
		while(true);
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		double absoluteBearing; // The target enemy's absolute bearing in radians
		double robotHeading; // The robot's absolute heading in radians
		double enemyDistance = e.getDistance(); // Distance to the enemy

		// Flattener
		// 0.055 is about equal to NanoSatan's old movement
		if(flat && Math.random() < 0.1)
		{
			direction = -direction;
		}

		// Wall smoother
		double turnAngle = (absoluteBearing = e.getBearingRadians()) + Math.PI/2 + direction * 0.2;
		while(!new Rectangle2D.Double(18, 18, 764, 564).contains(getX() + 170 * direction * Math.sin((robotHeading = getHeadingRadians()) + (turnAngle -= direction * 0.02)), getY() + 170 * direction * Math.cos(robotHeading + turnAngle)));

		// Move
		setAhead(direction * 100);

		// Turn robot perpendicular to opponent
		setTurnRightRadians(Utils.normalRelativeAngle(turnAngle));

		// Lock onto opponent with radar
		setTurnRadarRightRadians(Utils.normalRelativeAngle((absoluteBearing += robotHeading) - getRadarHeadingRadians()) * 2);

		// Lock onto opponent with gun
		// Note the method I use here to achieve random aim, the tuning factor is the multiplier
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()) * (e.getEnergy() > 0 ? 5 : 1) );

		// Fire
		setFire(2);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		// Switch to flattener
		flat = true;

		// Record bullet velocity
		bulletVelocity = e.getVelocity();
	}
}