/*
    _____             _                   _______              _ 
  / ____|           (_)                 |__   __|            | |
 | (___   __ _ _   _ _ _ __ _ __ ___  _   _| | ___   __ _  __| |
  \___ \ / _` | | | | | '__| '_ ` _ \| | | | |/ _ \ / _` |/ _` |
  ____) | (_| | |_| | | |  | | | | | | |_| | | (_) | (_| | (_| |
 |_____/ \__, |\__,_|_|_|  |_| |_| |_|\__, |_|\___/ \__,_|\__,_|
            | |                        __/ |                    
            |_|                       |___/     

	SquirmyToad, a nanobot with the musashi trick, oscillation, random movement and pattern matching 
	By Slugzilla
	
	Credits: 
		Pattern Matching gun is based off of BlackWidow
		Movement is based off of Charp
		A huge thank you to all the contributors on the RoboWiki for your awesome tutorials and open source robots!

	Released under the RWPCL
 */

package slugzilla;
import robocode.*;
import robocode.util.*;

public class SquirmyToad extends AdvancedRobot {
	//gun ↓
	static String enemyLog = "000000000000000000000000000000888888888888888765432100888765432101234567888765432100"; 
    //Constants
    static final double FIREPOWER = 2.5; 
    static final double BULLETVEL = 20-3*FIREPOWER; 
    static final int PATTERN_DEPTH = 30; 
	//movement ↓
	static double direction = 37;
	static double prevEnergy;
	static double hits;

    public void run() {	
		turnRadarRightRadians(Double.POSITIVE_INFINITY); 
    }

    public void onScannedRobot(ScannedRobotEvent e) {
		int matchLenght = PATTERN_DEPTH; 	 
   		double absB; 
   		int i; 		 		    		
   		int index;
		// movement ↓	
		// stop and go
		if (prevEnergy > (prevEnergy = e.getEnergy())) {
			setAhead(direction);
		}
		//random movement
		if (hits > getRoundNum() + 2) {
			direction = ((Math.random() - 0.12) * direction) / 0;	
		}
		//gun↓
		setTurnRightRadians((Math.cos(absB = e.getBearingRadians())));
        enemyLog = String.valueOf( (char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB+=getHeadingRadians() )))).concat(enemyLog);
        while((index = enemyLog.indexOf(enemyLog.substring(0, matchLenght--), (i = (int)((e.getDistance())/BULLETVEL)))) < 0);
        do{
            absB += Math.asin(((byte)enemyLog.charAt(index--))/e.getDistance());
        }while(--i > 0);
        setTurnGunRightRadians(Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
        setFire(FIREPOWER);
 		//radar ↓
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
	}
	//count how many times we get hit
	public void onHitByBullet(HitByBulletEvent e) {
		hits += 0.34;
	}
	//reverse direction
	public void onHitWall(HitWallEvent e) {
		direction = -direction;
	}
}