/*
Feint v1.2.1 by Sheldor.  03/23/2024  Code size: 249 bytes
a nanobot with multimode movement and pattern matching targeting
v1.2.1 -- radar

Previously named sheldor.nano.Epeeist.

Credits: 
Thanks go to the authors of the following bots:
jk.sheldor.nano.Yatagan
Also, a general thanks to all open source bot authors and contributors to the RoboWiki.

Feint is open source and released under the terms of the RoboWiki Public Code License (RWPCL) - Version 1.1.
See license here: http://robowiki.net/wiki/RWPCL
*/

package sheldor.nano;

import robocode.*;
import robocode.util.Utils;

public class Feint extends AdvancedRobot
{
	//global variables
	static int     movementMode;
	static int     hasDied;
	static double  direction;
	static double  enemyEnergy;
	
	//En garde!
	public void run()
	{		
		setAdjustRadarForGunTurn(true);
		
		//Start spinning radar.
		setTurnRadarRightRadians(direction = Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		//local variables
		int    integer = 40;
       double absoluteBearing;
       int    matchPosition;  
		
		//stay mostly perpendicular to the enemy
		setTurnRightRadians(Math.cos(absoluteBearing = e.getBearingRadians()));
		
		//pattern matching based on Yatagan's
		//Record the current enemy lateral velocity.
		enemyHistory = String.valueOf((char)(e.getVelocity() * (Math.sin(e.getHeadingRadians() - (absoluteBearing += getHeadingRadians()))))).concat(enemyHistory);
		
       //Find the longest match allowable in the enemy history.
       do{}while((matchPosition = enemyHistory.indexOf(enemyHistory.substring(0, --integer), 64)) < 0);
		
		//Fire medium-power bullets most of the time, but use full power at very close range.
		setFire(2 + (100 / (integer = (int)e.getDistance())));
		
		//multimode movement
		if ((enemyEnergy - (enemyEnergy = e.getEnergy())) > (movementMode / (Math.random() - 0.1)))
		{
			onHitWall(null);
		}
		setAhead(direction);
		
		//Assume that the enemy will repeat their movements in the ticks following the recording of the original pattern.
		//Generate a firing angle based on that assumption.
		do
		{
			//Go through the log of enemy movements right after the original pattern was recorded.
			//Add the angular velocities directly to the absoluteBearing variable.
        	absoluteBearing += ((short) enemyHistory.charAt(--matchPosition)) /  e.getDistance();
        }
		while ((integer -= 14) > 0); //Keep projecting the enemy's movement forward until our bullet would reach their predicted location.		
	
		//Aim the gun at the enemy's predicted location.
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
				
		//radar
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
	}	
	
   public void onHitWall(HitWallEvent e)
   {
	   //Reverse direction when the bot hits a wall.
      direction = -direction;
   }
   
   public void onBulletHit (BulletHitEvent e)
	{
		//Adjust enemy energy variable when the bot hits the enemy.
		//This makes a big difference against linear targeting.
		enemyEnergy -= 10;
	}
   
	public void onDeath(DeathEvent e)
	{		
		//if oscillating movement loses twice in the first five rounds, switch to random movement
		if (getRoundNum() < hasDied) 
		{
			movementMode = 5;
		}
		hasDied = 5;
	}
   
	//log of enemy lateral velocities for pattern matcher, from Yatagan
	//preloaded to prevent StringIndexOutOfBoundsException
   static String enemyHistory = ""
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 1 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 1 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 1 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 1 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char)-1 + (char)-2 + (char)-3 + (char)-4 + (char)-5 + (char)-6 
   + (char)-7 + (char)-8 + (char) 8 + (char) 7 + (char) 6 + (char) 5 
   + (char) 4 + (char) 3 + (char) 2 + (char) 1 + (char) 0 + (char) 0;
}																																																																																																																																																											