package dsekercioglu.mega.wfGun;

import java.awt.geom.Point2D;

public class GunUtils {

    public static double absoluteBearing(Point2D.Double p1, Point2D.Double p2) {
        return Math.atan2(p2.x - p1.x, p2.y - p1.y);
    }

    public static Point2D.Double project(Point2D.Double source, double angle, double distance) {
        return new Point2D.Double(source.x + Math.sin(angle) * distance, source.y + Math.cos(angle) * distance);
    }

    public static double distanceToWall(double x, double y, double battleFieldWidth, double battleFieldHeight) {
        return Math.min(Math.min(x, battleFieldWidth - x), Math.min(y, battleFieldHeight - y));
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int getMostVisitedBin(double[] bins) {
        int bestIndex = bins.length / 2;
        for (int i = 0; i < bins.length; i++) {
            if (bins[i] > bins[bestIndex]) {
                bestIndex = i;
            }
        }
        return bestIndex;
    }

    public static double[] normalizeBinValues(double[] bins) {
        int bestIndex = 0;
        int worstIndex = 0;
        for (int i = 1; i < bins.length; i++) {
            double v = bins[i];
            if (v > bins[bestIndex]) {
                bestIndex = i;
            }
            if (v < bins[worstIndex]) {
                worstIndex = i;
            }
        }
        double max = bins[bestIndex];
        double min = bins[worstIndex];
        if (max == min) {
            return new double[bins.length];
        }
        max -= min;
        double[] normalizedBins = new double[bins.length];
        for (int i = 0; i < normalizedBins.length; i++) {
            normalizedBins[i] = (bins[i] - min) / max;
        }
        return normalizedBins;
    }

    public static double[] normalizeBinValuesExp(double[] bins) {
        double sum = 0;
        for (int i = 0; i < bins.length; i++) {
            sum += (bins[i] = Math.exp(bins[i]));
        }
        for (int i = 0; i < bins.length; i++) {
            bins[i] /= sum;
        }
        return bins;
    }

    public static double[] getWindowBins(double[] bins, double distanceToRobot, double binWidth) {
        double angularBotWidth = Math.atan(18 / (distanceToRobot - 18));
        double binBotWidth = angularBotWidth / binWidth;
        double[] windowBins = new double[bins.length];
        for (int i = 0; i < bins.length; i++) {
            windowBins[i] = getWindowDanger(i, bins, binBotWidth);
        }
        return windowBins;
    }

    public static double getWindowDanger(int bin, double[] bins, double binBotWidth) {
        double extra = binBotWidth - (int) binBotWidth;
        double minBin = Math.max(bin - binBotWidth, 0);
        double maxBin = Math.min(bin + binBotWidth, bins.length - 1);
        double danger = 0;
        for (int i = (int) Math.max(Math.ceil(minBin), 0); i <= (int) Math.min(Math.floor(maxBin), bins.length - 1); i++) {
            danger += bins[i];
        }
        danger += bins[(int) Math.floor(minBin)] * extra;
        danger += bins[(int) Math.ceil(maxBin)] * extra;
        return danger;
    }

    public static double calculateMEA(double bulletSpeed) {
        return Math.asin(8 / bulletSpeed);
    }
}
