package dsekercioglu.mega.wfMove.move;

import dsekercioglu.mega.megaCore.KNNPredictor;
import dsekercioglu.mega.wfMove.Lightning;
import dsekercioglu.mega.wfMove.move.formulas.Formula;
import dsekercioglu.mega.wfMove.move.formulas.FormulaFlattener;
import dsekercioglu.mega.wfMove.move.thresholds.Threshold;
import java.util.Arrays;

public class DecayingKNNView extends View {

    public final int BINS;
    KNNPredictor predictor;

    private final int K;

    final Formula FORMULA;

    boolean log = false;

    final Threshold THRESHOLD;
    final boolean ALWAYS_LOG;
    final boolean VISITS;

    final double DECAY_FACTOR;
    final double DECAY_POWER;
    
    private int counter = 0;
    
    public DecayingKNNView(int bins, Formula formula, int k, int divisor, Threshold threshold, boolean alwaysLog, boolean visits, double decayFactor, double decayPower) {
        BINS = bins;
        FORMULA = formula;
        K = k;
        ALWAYS_LOG = alwaysLog;
        VISITS = visits;
        THRESHOLD = threshold;
        DECAY_FACTOR = decayFactor;
        DECAY_POWER = decayPower;
        predictor = new KNNPredictor();
        predictor.setup(formula.getWeights(), K, BINS, true, predictor.divisionK(K, divisor));
        predictor.addData(new double[formula.getWeights().length], BINS / 2, 0.001);
    }

    public double[] predict(Lightning.BattleInfo data, double hitRate) {
        if (hitRate >= THRESHOLD.getOpenThreshold(0, data.enemyHit)) {
            log = true;
        } else if (hitRate < THRESHOLD.getCloseThreshold(0, data.enemyHit)) {
            log = false;
        }
        if (log) {
            double[] bins = predictor.predictBins(FORMULA.getDataPoint(data));
            return bins;
        } else {
            return new double[BINS];
        }
    }

    public void wavePassed(Lightning.BattleInfo data, int bin, boolean real) {
        if ((log || ALWAYS_LOG) && (real ^ VISITS)) {
            predictor.addData(FORMULA.getDataPoint(data), bin, DECAY_FACTOR + counter * DECAY_POWER);
            counter++;
        }
    }

}
