package dsekercioglu.mega.wfMove.move;

import dsekercioglu.mega.wfMove.Lightning;
import dsekercioglu.mega.wfMove.MoveUtils;

public class EnsembleView extends View {

    View[] predictors;
    final int BINS;

    public EnsembleView(int bins, View... predictors) {
        BINS = bins;
        this.predictors = predictors;
    }

    public double[] predict(Lightning.BattleInfo data, double hitRate) {
        double[] sumBins = new double[BINS];
        for (int i = 0; i < predictors.length; i++) {
            double[] bins = predictors[i].predict(data, hitRate);
            if (sumBins(bins) != 0) {
                sumBins = addBins(sumBins, MoveUtils.probabilizeBinValues(bins));
            }
        }
        return multiplyBin(MoveUtils.probabilizeBinValues(sumBins), 1.0 / predictors.length);
    }

    public void wavePassed(Lightning.BattleInfo data, int bin, boolean real) {
        for (int i = 0; i < predictors.length; i++) {
            predictors[i].wavePassed(data, bin, real);
        }
    }

    public double[] addBins(double[] array1, double[] array2) {
        double[] array3 = new double[array1.length];
        for (int i = 0; i < array1.length; i++) {
            array3[i] = array1[i] + array2[i];
        }
        return array3;
    }

    public double[] multiplyBin(double[] array1, double d) {
        double[] array3 = new double[array1.length];
        for (int i = 0; i < array1.length; i++) {
            array3[i] = array1[i] * d;
        }
        return array3;
    }

    public double sumBins(double[] bins) {
        double sum = 0;
        for (int i = 0; i < bins.length; i++) {
            sum += bins[i];
        }
        return sum;
    }

}
