package dsekercioglu.mega.wfMove.move.thresholds;

public class DecreasingThreshold extends Threshold {
    
    final double OPEN_THRESHOLD;
    final double CLOSE_THRESHOLD;
    final double MULTIPLIER;
    
    public DecreasingThreshold(double stdOpenThreshold, double stdCloseThreshold, double multiplier) {
        OPEN_THRESHOLD = stdOpenThreshold;
        CLOSE_THRESHOLD = stdCloseThreshold;
        MULTIPLIER = multiplier;
    }

    @Override
    public double getOpenThreshold(int round, int dataPoints) {
        return  OPEN_THRESHOLD + MULTIPLIER / (dataPoints * dataPoints + 1);
    }

    @Override
    public double getCloseThreshold(int round, int dataPoints) {
        return CLOSE_THRESHOLD + MULTIPLIER / (dataPoints * dataPoints + 1);
    }
    
}
