package ph.intelligence;
import java.util.*;
import ph.*;
import java.io.*;

// persistent robot info
public class probotInfo implements Serializable {
    
    public probotInfo(ModularRobot robot, String name) {
        this.robot=robot;
        this.name=name;
    }
    
    protected transient ModularRobot robot;
    protected String name;
    
    public void setRobot(ModularRobot robot) {this.robot = robot; }
    public String name() {return name;}
    
    /* my */
    //distance from me, velocity, acceleration, guess factor
    //private int[][][][][][] guessFactors=new int[6][2][2][37][37][31];
    private int[][][][] guessFactors=new int[6][3][4][27];
    private Vector waves=new Vector();
    private int direction=1;
    /* ---------------------------------------------------------------------- */
    
    public void bulletFiredToOther(double power) {
        robotInfo ri;
        int robotIndex=robot.otherRobotsNames.indexOf(name);
        if(robotIndex<0) return;
        ri=(robotInfo)robot.otherRobotsInfo.elementAt(robotIndex);
        double bearing=utils.normalAngle(utils.getBearing(
        robot.getX(),robot.getY(),ri.x(),ri.y()));
        bulletFired(new VirtualBullet(robot.getTime(),
        power, robot.getX(), robot.getY(), bearing),ri);
    }
    
    public void bulletFired(VirtualBullet vb, robotInfo ri) {
        double distance=utils.dist(robot.getX(),robot.getY(),ri.x(),ri.y());
        int distanceFromMe=Math.min(5,(int)distance/160);
        int acceleration=1;
        if (ri.acceleration()>0)
            acceleration=2;
        else if(ri.acceleration()<0)
            acceleration=0;
        int accelerationTimerIndex;
        double bTravelTime=distance/Wave.getBulletSpeed(vb.power());
        double time=(robot.getTime()-ri.accelerationTimer())/bTravelTime;
        if(time<0.1)
            accelerationTimerIndex=0;
        else if(time<0.3)
            accelerationTimerIndex=1;
        else if(time<1)
            accelerationTimerIndex=2;
        else
            accelerationTimerIndex=3;
        int[] stats=guessFactors[distanceFromMe][acceleration][accelerationTimerIndex];
        double absBearing=utils.normalAngle(
        utils.getBearing(vb.launchX,vb.launchY,ri.x(),ri.y()));
        if (ri.velocity() != 0)
            if (Math.sin(Math.toRadians(
            utils.normalAngle(ri.heading()-absBearing)))*ri.velocity() < 0)
                direction = -1;
            else
                direction = 1;
        waves.addElement(new Wave(vb.launchX, vb.launchY, vb.launchTime,
        vb.power, vb.heading, direction, stats));
    }
    
    public void checkHit(double enemyX, double enemyY, double enemyEnergy, long curTime) {
        for(int i=0; i<waves.size(); i++) {
            Wave w=(Wave)waves.elementAt(i);
            if(w.checkHit(enemyX,enemyY,enemyEnergy,curTime)) {
                waves.removeElementAt(i);
                i--;
            }
        }
    }
    
    public double gfAimingHeading(robotInfo ri, double power) {
        double distance=utils.dist(robot.getX(),robot.getY(),ri.x(),ri.y());
        int distanceFromMe=Math.min(5,(int)distance/160);
        int acceleration=1;
        if (ri.acceleration()>0)
            acceleration=2;
        else if(ri.acceleration()<0)
            acceleration=0;
        int accelerationTimerIndex;
        double bTravelTime=distance/Wave.getBulletSpeed(power);
        double time=(robot.getTime()-ri.accelerationTimer())/bTravelTime;
        if(time<0.1)
            accelerationTimerIndex=0;
        else if(time<0.3)
            accelerationTimerIndex=1;
        else if(time<1)
            accelerationTimerIndex=2;
        else
            accelerationTimerIndex=3;
        int[] stats=guessFactors[distanceFromMe][acceleration][accelerationTimerIndex];
        int bestindex = (stats.length-1)/2;	//initialize it to be in the middle, guessfactor 0.
        for (int i=0; i<stats.length; i++)
            if (stats[bestindex] < stats[i])
                bestindex = i;
        
        double robotX=robot.getX();
        double robotY=robot.getY();
        //this should do the opposite of the math in the WaveBullet:
        //double guessfactor = (double)(bestindex-(stats.length-1)/2)/((stats.length-1)/2);
        double guessfactor=(double)((2d*(double)bestindex)/((double)stats.length-1d))-1d;
        double angleOffset = (double)direction*guessfactor*Wave.maxEscapeAngle(power);
        double bearing=utils.normalAngle(utils.getBearing(robotX,robotY,ri.x(),ri.y()));
        return utils.normalAngle(bearing+angleOffset);
    }
    
}
