// (C) 2007 Kim, Taegyoon
// WS: wave surfing

// version 1.1: more wave surfing buffers
// version 1.1a: less wave surfing buffers, adjust last enemy energy change by bullet accordingly
// version 1.1b: more wave surfing buffers
// version 1.1c: perpendicular to the first location
// version 1.1d: rams a rammer
// version 1.1e: ramming bugfix
// version 1.1f: always flattening of weight 0.25
// version 1.1g: flattening switch
// version 1.1h: variable max velocity
// version 1.2: "correct" predictPosition
// version 1.2a: adding "randomness"
// version 1.2b: stay away
// version 1.2c: stay away at first of the round

package stelo;

import robocode.*;
import robocode.util.Utils;

import java.awt.geom.*;     // for Point2D's
import java.util.ArrayList; // for collection of waves
import java.awt.*;

public class MatchupWS extends AdvancedRobot {
    private static final int BINS = 47;
	private static final int DISTANCE_INDEXES = 5;
	private static final int VELOCITY_INDEXES = 5;
	private static final int WALL_INDEXES = 2;
	private static final int POWER_INDEXES = 4;
//    public static double _surfStats[] = new double[BINS]; // we'll use 47 bins
	private static double _surfStats1[][] = new double[DISTANCE_INDEXES][BINS];
	private static double _surfStats2[][] = new double[VELOCITY_INDEXES][BINS];
	
	private static double _surfStats3[][][] = new double[VELOCITY_INDEXES][DISTANCE_INDEXES][BINS];
	private static double _surfStats4[][][] = new double[VELOCITY_INDEXES][VELOCITY_INDEXES][BINS];
	
    private static double _surfStats5[][][][] = new double[VELOCITY_INDEXES][VELOCITY_INDEXES][DISTANCE_INDEXES][BINS];
	private static double _surfStats6[][][][][] = new double[VELOCITY_INDEXES][VELOCITY_INDEXES][DISTANCE_INDEXES][WALL_INDEXES][BINS];
	private static double _surfStats7[][][][][][] = new double[VELOCITY_INDEXES][VELOCITY_INDEXES][DISTANCE_INDEXES][WALL_INDEXES][POWER_INDEXES][BINS];
	    
    public static Point2D.Double _myLocation;     // our bot's location
    public static Point2D.Double _enemyLocation;  // enemy bot's location
	public static Point2D.Double _lastEnemyLocation;  // enemy bot's location

    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
	
	private static double lateralDirection;
	private static double lastEnemyVelocity;

    // This is a rectangle that represents an 800x600 battle field,
    // used for a simple, iterative WallSmoothing method (by Kawigi).
    // If you're not familiar with WallSmoothing, the wall stick indicates
    // the amount of space we try to always have on either end of the tank
    // (extending straight out the front or back) before touching a wall.
//    public static Rectangle2D.Double _fieldRect
//        = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);
    public static Rectangle2D.Double _fieldRect
        = new java.awt.geom.Rectangle2D.Double(25, 25, 800-25*2, 600-25*2);


    private double lastEnemyEnergy = 100.0;
    private static double enemyBulletPower = 0.1;
    private static double lastMyVelocity;

	private static final int NUM_LOGS = 2; // [0]: velocity, [1]: angleChange, [2]: distance, [3]: bearingChange, [4]: ticksSinceMyFire
	private static final int PATTERN_LENGTH = 5000;	
	private static double[][] theLog = new double[PATTERN_LENGTH][NUM_LOGS];
//	private static boolean[] fireTime = new boolean[PATTERN_LENGTH];
	private static int cursor;
	private static final int searchLength = 20; // increasing this will slow down the game. 20
	private static int pattern_size;
	private static double MAX_ESCAPE_ANGLE = 0.9;
	private static double lastEnemyHeading;
	private static double enemyDistance;
	private static double absBearing;
	private static double lastBearingOffset;
	private static int enemyFire, enemyHit;
	private static int numFire, numHit;
	private boolean enemyFiredThisRound;
		    
    public void run() {
		setColors(Color.BLUE, Color.BLUE, Color.WHITE);
		lateralDirection = 1;
		lastEnemyVelocity = 0;
		
        _enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();

        setAdjustGunForRobotTurn(true);
//        setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		// mark the between-round
		{
			cursor = (cursor + 1) % PATTERN_LENGTH;
			theLog[cursor][0] = 0.0;
			theLog[cursor][1] = 0.0;
//			fireTime[cursor] = false;
			
			if (pattern_size < PATTERN_LENGTH)
				pattern_size++;
		}		

        do {
            // basic mini-radar code
	        setAdjustRadarForGunTurn(false);
			
			setTurnGunRightRadians(Double.POSITIVE_INFINITY);
			doSurfing();
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        setAdjustRadarForGunTurn(true);
		
        _myLocation = new Point2D.Double(getX(), getY());
        _enemyLocation = (Point2D.Double) project(_myLocation, absBearing, e.getDistance());			
		
        double lateralVelocity = getVelocity()*Math.sin(e.getBearingRadians());
        absBearing = e.getBearingRadians() + getHeadingRadians();
		enemyDistance = e.getDistance();
		double enemyVelocity = e.getVelocity();
		double myVelocity = getVelocity();
				
        setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);

		{
			cursor = (cursor + 1) % PATTERN_LENGTH;
			theLog[cursor][0] = e.getVelocity();
			theLog[cursor][1] = Utils.normalRelativeAngle(e.getHeadingRadians() - lastEnemyHeading);
//			fireTime[cursor] = false;
//			out.println(cursor);
			if (pattern_size < PATTERN_LENGTH)
				pattern_size++;
		}
	
        _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));	
	
        // check energyDrop
        double energyDrop = lastEnemyEnergy - e.getEnergy();
        if (energyDrop < 3.01 && energyDrop > 0.09
            && _surfDirections.size() > 2) {
        	enemyBulletPower = energyDrop;
			enemyFiredThisRound = true;
//            EnemyWave ew = new EnemyWave();
            EnemyWave ew = new EnemyWave(this.getVelocity(), lastMyVelocity, enemyDistance, enemyBulletPower);
            ew.fireTime = getTime() - 1;
            ew.distanceTraveled = bulletVelocity(enemyBulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_lastEnemyLocation.clone(); // last tick, because that needs the previous enemy location as the source of the wave
			ew.firstLocation = (Point2D.Double)_myLocation.clone();

            _enemyWaves.add(ew);
			enemyFire++;
        }

		double hitRate = (double) numHit / numFire;
		double enemyHitRate = (double) enemyHit / enemyFire;
/*		if (enemyHitRate > 0.16) {
			if (!flattening) System.out.println("Flattening enabled.");
			flattening = true;
		} else if (enemyHitRate < 0.15) {
			if (flattening) System.out.println("Flattening disabled.");
			flattening = false;
		}
*/
        updateWaves();
        doSurfing();

		double bulletPower = 1.9; // 1.9
		System.out.println("My Hit Rate:    " + hitRate + "\nEnemy Hit Rate: " + enemyHitRate);
		if (e.getDistance() < 50 || numFire > 0 && hitRate > 0.5) bulletPower = 3.0;
		bulletPower = Math.min(getEnergy(), Math.min(bulletPower, e.getEnergy() / 4.0));
		bulletPower = limit(0.1, bulletPower, 3.0);
       
		if (!ramming && getGunHeat() / getGunCoolingRate() < 4.0 && getTime() > searchLength) {
//		if (getGunHeat() <= getGunCoolingRate()) {
//			if (e.getEnergy() <= 0.0) 
//				lastBearingOffset = 0;
//			else
				lastBearingOffset = bestBearingOffset(theLog, e, bulletPower, absBearing);
			Bullet b = setFireBullet(bulletPower);
			if (b != null) {
				numFire++;
//				fireTime[cursor] = true;
			}
		}
		setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing + lastBearingOffset - getGunHeadingRadians()));
		
	
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);		

		lastEnemyHeading = e.getHeadingRadians();		
		lastEnemyVelocity = enemyVelocity;
		lastEnemyEnergy = e.getEnergy();
		lastMyVelocity = getVelocity();
		_lastEnemyLocation = (Point2D.Double)_enemyLocation.clone();
    }

	public void onSkippedTurn(SkippedTurnEvent e) {
		System.out.println("Turn skipped at: " + getTime());
	}

	public void onPaint(java.awt.Graphics2D g) {
		g.draw(new Rectangle((int) getX() - 18, (int) getY() - 18, 36, 36));
		
        EnemyWave surfWave = null;

        for (int x = 0; _enemyWaves != null && x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

			double eX = ew.fireLocation.getX() + ew.distanceTraveled * Math.sin(ew.directAngle);
			double eY = ew.fireLocation.getY() + ew.distanceTraveled * Math.cos(ew.directAngle);

			g.draw(new Rectangle((int) eX - 8, (int) eY - 8, 16, 16));
			int maxBin = (BINS - 1) / 2;
			for (int i = 0; i < BINS; i++) {
				if (ew.buffer[EnemyWave.BUFFERS - 1][i] > ew.buffer[EnemyWave.BUFFERS - 1][maxBin]) {
					maxBin = i;
				}
			}

			double angle = ew.directAngle + maxEscapeAngle(ew.bulletVelocity) * ew.direction * (double) ((maxBin - (BINS - 1)) / 2) / ((BINS - 1) / 2);
			eX = ew.fireLocation.getX() + ew.distanceTraveled * Math.sin(angle);
			eY = ew.fireLocation.getY() + ew.distanceTraveled * Math.cos(angle);
			g.draw(new Rectangle((int) eX - 4, (int) eY - 4, 8, 8));			
        }		
	}

	private Rectangle2D fieldRectangle(double margin) { 
		return new Rectangle2D.Double(margin, margin, getBattleFieldWidth() - margin *
		 2, getBattleFieldHeight() - margin * 2);
	}

	private static int CLOSEST_SIZE;
	// statistical pattern-matcher
	private double bestBearingOffset(double[][] series, ScannedRobotEvent e, double bulletPower, double absBearing) {
		double angleThreshold = 36.0 / e.getDistance();
//		final double MAX_ESCAPE_ANGLE = maxEscapeAngle(bulletVelocity(bulletPower));
		int binSize = (int) (MAX_ESCAPE_ANGLE * 2.0 / angleThreshold) + 1;
//		final int CLOSEST_SIZE = binSize * 2 + 1;
		CLOSEST_SIZE = (int) limit(1, numFire / 2, 100);
//		System.out.println(CLOSEST_SIZE);
		int[] closestIndexes = new int[CLOSEST_SIZE];
		double[] closestDiffs = new double[CLOSEST_SIZE];
		double[] signs = new double[CLOSEST_SIZE];
		
		int count = 0, i, c;
		final double bulletSpeed = (20.0 - 3.0 * bulletPower);
		final double bulletTravelTime = enemyDistance / bulletSpeed;
		
		int[] statBin = new int[binSize];
		double metaAngle = 0.0;
//		System.out.println("binSize: " + binSize);
		Rectangle2D fieldRect = fieldRectangle(17);
				
		for (c = 0 ; c < CLOSEST_SIZE; c++) {
			closestDiffs[c] = Double.POSITIVE_INFINITY;
		}
			
		i = (PATTERN_LENGTH + cursor - searchLength) % PATTERN_LENGTH;
		while (count < pattern_size) {
//			if (fireTime[i]) {
			double diff = 0;
			double sign = 1.0;
			if (series[cursor][0] * series[i][0] < 0) {
				sign = -1; // generalize direction
			}
			for (int j = 0; j < searchLength; j++) {
				int k = (PATTERN_LENGTH + i - j) % PATTERN_LENGTH;
				int searchIndex = (PATTERN_LENGTH + cursor - j) % PATTERN_LENGTH;
				diff += Math.abs(series[searchIndex][0] - sign * series[k][0]) + // velocity
					Math.abs(series[searchIndex][1] - sign * series[k][1]) * 40.0; // maximum turning, angleChange, * 40
			}
		
			// find maximum difference index
			int maxDiffIndex = 0;
			for (c = 1; c < CLOSEST_SIZE; c++) {
				if (closestDiffs[c] > closestDiffs[maxDiffIndex])
					maxDiffIndex = c;
			}
		
			// insert into the maximum difference index
			if (diff < closestDiffs[maxDiffIndex] && Math.abs(i - cursor) > bulletTravelTime) {
				closestDiffs[maxDiffIndex] = diff;
				closestIndexes[maxDiffIndex] = (i + 1) % PATTERN_LENGTH;
				signs[maxDiffIndex] = sign;
			}	
//			}	
			count++;
			i = (PATTERN_LENGTH + i - 1) % PATTERN_LENGTH;
		}
	
		double initialEX = enemyDistance * Math.sin(absBearing);
		double initialEY = enemyDistance * Math.cos(absBearing);
		double eV = e.getVelocity();
		double enemyHeading = e.getHeadingRadians();
		
		int maxIndex = 0;
		double matchedSign = 1.0;
	
		// reconstruct enemy movement and find the most popular angle
		for (c = 0 ; c < CLOSEST_SIZE; c++) {
			double eX = initialEX;
			double eY = initialEY;
			double ww = enemyHeading;
			double v = eV;
			double db = 0.0;
			int index = closestIndexes[c];
			double sign = signs[c];
	
			do {
				db += bulletSpeed;

				eX += v * Math.sin(ww);
				eY += v * Math.cos(ww);

				ww += sign * theLog[index][1];
				v = sign * theLog[index][0];
				
				if (index + 1 != cursor) {
					index = (index + 1) % PATTERN_LENGTH;
				}
			} while (db < Point2D.distance(0, 0, eX, eY));
		
			if (fieldRect.contains(new Point2D.Double(eX + _myLocation.getX(), eY + _myLocation.getY()))) {
				double angle = Utils.normalRelativeAngle(Math.atan2(eX, eY) - absBearing);
				
				int binIndex = (int) ((angle + MAX_ESCAPE_ANGLE) / angleThreshold);
								
				statBin[binIndex]++;
				if (statBin[binIndex] > statBin[maxIndex]) {
					maxIndex = binIndex;
					matchedSign = sign;
					metaAngle = angle;
				}
			}
		}
//		System.out.println("Probability: " + (double) statBin[maxIndex] / CLOSEST_SIZE);
//		System.out.println("Matched sign: " + matchedSign);
		return metaAngle;
	}												

	private static boolean flattening;
    public void updateWaves() {
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

            ew.distanceTraveled = (getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled >
                _myLocation.distance(ew.fireLocation) + 50) {
				if (flattening) {
					logHit(ew, _myLocation, 0.25); // flatten 0.25
				}
                _enemyWaves.remove(x);
                x--;
            }
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;

        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;

            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
        }

        return surfWave;
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, calculate the index into our stat array for that factor.
    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = (absoluteBearing(ew.fireLocation, targetLocation)
            - ew.directAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / maxEscapeAngle(ew.bulletVelocity) * ew.direction;

        return (int)limit(0,
            (factor * ((BINS - 1) / 2)) + ((BINS - 1) / 2),
            BINS - 1);
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, update our stat array to reflect the danger in that area.
    public void logHit(EnemyWave ew, Point2D.Double targetLocation, double weight) {
        int index = getFactorIndex(ew, targetLocation);
//		weight /= Math.pow(2, getNumRounds() - getRoundNum());
//		weight *= (1.0 + getRoundNum());

		for (int b = 0; b < EnemyWave.BUFFERS; b++) {
	        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
//			double increment = 1.0 / (Math.pow(index - x, 2) + 1);
				double increment = weight / (Math.pow(index - x, 2) + 1);
			
            	ew.buffer[b][x] += increment;
			}
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
		enemyHit++;
	
		lastEnemyEnergy += e.getBullet().getPower() * 3;
        // If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
                e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;

            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.round(bulletVelocity(e.getBullet().getPower()) * 10)
                       == Math.round(ew.bulletVelocity * 10)) {
                    hitWave = ew;
                    break;
                }
            }

            if (hitWave != null) {
                logHit(hitWave, hitBulletLocation, 1.0);
				
                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        // If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
    	Bullet bullet = e.getHitBullet();
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
            		bullet.getX(), bullet.getY());
            EnemyWave hitWave = null;

            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.round(bulletVelocity(bullet.getPower()) * 10)
                       == Math.round(ew.bulletVelocity * 10)) {
                    hitWave = ew;
                    break;
                }
            }

            if (hitWave != null) {
                logHit(hitWave, hitBulletLocation, 1.0);

                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onBulletHit(BulletHitEvent e) {
    	lastEnemyEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
		numHit++;
    }

    public void onHitRobot(HitRobotEvent e) {
    	lastEnemyEnergy -= Rules.ROBOT_HIT_DAMAGE;
		setBackAsFront(this, e.getBearingRadians() + getHeadingRadians());
    }	

    // CREDIT: mini sized predictor from Apollon, by rozu
    // http://robowiki.net?Apollon
    public Point2D.Double predictPosition(EnemyWave surfWave, int direction, double maxVelocity) {
    	Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
    	
    	double predictedVelocity = getVelocity();
    	double predictedHeading = getHeadingRadians();
    	double maxTurning, moveAngle, moveDir;

        int counter = 0; // number of ticks in the future
        boolean intercepted = false;

/*
    	if (direction == 0) { // brake
    		while (predictedVelocity != 0.0) {
    			double nextVelocity = predictedVelocity - Math.signum(predictedVelocity) * 2.0;
    			if (nextVelocity * predictedVelocity < 0.0) nextVelocity = 0.0;
        		predictedVelocity = nextVelocity;
        		// calculate the new predicted position
        		predictedPosition = (Point2D.Double) project(predictedPosition, predictedHeading, predictedVelocity);
   			
    		}
    		return predictedPosition;
    	}
*/

    	do {
// orbit
/*	
    		moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                predictedPosition) + (direction * (FAR_HALF_PI)), direction)
                - predictedHeading;
*/
// straight
    		moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                surfWave.firstLocation) + (direction * (FAR_HALF_PI)), direction)
                - predictedHeading;


    		moveDir = 1;

    		if(Math.cos(moveAngle) < 0) {
    			moveAngle += Math.PI;
    			moveDir = -1;
    		}

    		moveAngle = Utils.normalRelativeAngle(moveAngle);

    		// maxTurning is built in like this, you can't turn more then this in one tick
    		maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
    		predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + limit(-maxTurning, moveAngle, maxTurning));

    		// this one is nice ;). if predictedVelocity and moveDir have
            // different signs you want to breack down
    		// otherwise you want to accelerate (look at the factor "2")
//    		predictedVelocity += (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
//    		predictedVelocity = limit(-maxVelocity, predictedVelocity, maxVelocity);
			if (predictedVelocity * moveDir < 0) {
				double nextVelocity = predictedVelocity + 2 * moveDir;
				if (predictedVelocity * nextVelocity < 0) 
					predictedVelocity = 0.0;
				else
					predictedVelocity = nextVelocity;
			} else if (Math.abs(predictedVelocity) > maxVelocity) {
				double nextVelocity = predictedVelocity - Math.signum(predictedVelocity) * 2.0;
				if (predictedVelocity * nextVelocity < 0) 
					predictedVelocity = 0.0;
				else
					predictedVelocity = nextVelocity;				
			} else {
				predictedVelocity += moveDir;
				predictedVelocity = limit(-maxVelocity, predictedVelocity, maxVelocity);
			}
			

    		// calculate the new predicted position
    		predictedPosition = (Point2D.Double) project(predictedPosition, predictedHeading, predictedVelocity);

            counter++;

            if (predictedPosition.distance(surfWave.fireLocation) <
                surfWave.distanceTraveled + (counter * surfWave.bulletVelocity)
                + surfWave.bulletVelocity) {
                intercepted = true;
            }
    	} while(!intercepted && counter < 500);

    	return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction, double maxVelocity) {
        int index = getFactorIndex(surfWave,
            predictPosition(surfWave, direction, maxVelocity));

        int b = EnemyWave.BUFFERS - 1;
		for (; b >= 0; b--) {
	        for (int i = 0; i < BINS; i++) {
				if (surfWave.buffer[b][i] > 0) {
//					System.out.println(b);
					return surfWave.buffer[b][index];
				}
	        }
        }
//		System.out.println(0);
        return surfWave.buffer[0][index];
    }

	private double checkDanger2(EnemyWave surfWave, Point2D.Double destination) {
        int index = getFactorIndex(surfWave,
            destination);

        int b = EnemyWave.BUFFERS - 1;
		for (; b >= 0; b--) {
	        for (int i = 0; i < BINS; i++) {
				if (surfWave.buffer[b][i] > 0) {
//					System.out.println(b);
					return surfWave.buffer[b][index];
				}
	        }
        }
//		System.out.println(0);
        return surfWave.buffer[0][index];		
	}

	private static double goingAngle;
	private static final double FAR_HALF_PI = Math.PI / 2.0; // 1.25
//	private static final double FAR_HALF_PI = 1.25; // 1.25
//	private static final double FAR_HALF_PI = Math.PI / 2.0 - 0.06;
	private static boolean ramming;
	private static double randomDirection = 1.0;
    public void doSurfing() {
//		if (enemyDistance < 250) 
//			FAR_HALF_PI = 1.25;
//		else
//			FAR_HALF_PI = Math.PI / 2.0;
        EnemyWave surfWave = getClosestSurfableWave();

		ramming = false;
        if (surfWave == null) {
			setMaxVelocity(8);
			if (_myLocation != null && _enemyLocation != null) {
				if (lastEnemyEnergy <= 0.0) { // ram the disabled enemy
					setBackAsFront(this, absoluteBearing(_myLocation, _enemyLocation));
					ramming = true;
				} else if (!enemyFiredThisRound) {
					double goAngle = absoluteBearing(_enemyLocation, _myLocation);
					goAngle = wallSmoothing(_myLocation, goAngle - (0), (int) randomDirection);
					setBackAsFront(this, goAngle);
				}
			}
			return;
		}
	
//        double goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);
        double goAngle = absoluteBearing(surfWave.fireLocation, surfWave.firstLocation);

		double v, vLeft = 8, vRight = 8;
/*
        double leastDanger = Double.POSITIVE_INFINITY;
        double dangerLeft = checkDanger(surfWave, -1);
        double dangerRight = checkDanger(surfWave, 1);
*/
		double leastDanger = Double.POSITIVE_INFINITY;
		double dangerLeft = Double.POSITIVE_INFINITY;
        double dangerRight = Double.POSITIVE_INFINITY;
//        double dangerMiddle = checkDanger(surfWave, 0);
		double cLeft, cRight;

		for (v = 8; v >= 8; v -= 0.1) {
			cLeft = checkDanger(surfWave, -1, v);
			cRight = checkDanger(surfWave, 1, v);
			if (cLeft < dangerLeft) {
				dangerLeft = cLeft;
				vLeft = v;
			}
			if (cRight < dangerRight) {
				dangerRight = cRight;
				vRight = v;
			}		
		}
	
		double bulletTravelTime = _myLocation.distance(surfWave.fireLocation) / surfWave.bulletVelocity;
		if (Math.random() < 0.05 * bulletTravelTime / 25) randomDirection = -randomDirection;
        if (dangerLeft < dangerRight || randomDirection < 0 && dangerLeft == dangerRight) {
            goAngle = wallSmoothing(_myLocation, goAngle - (FAR_HALF_PI), -1);
			goingAngle = goAngle - (FAR_HALF_PI);
            leastDanger = dangerLeft;
			v = vLeft;
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (FAR_HALF_PI), 1);
			goingAngle = goAngle + (FAR_HALF_PI);
            leastDanger = dangerRight;
			v = vRight;
        }
//        if (dangerMiddle < leastDanger) {
//        	setAhead(0.0);
//        	return;
//        }
//		System.out.println(v);

		setMaxVelocity(v);
        setBackAsFront(this, goAngle);
    }

    // This can be defined as an inner class if you want.
    static class EnemyWave {
        Point2D.Double fireLocation;
		Point2D.Double firstLocation;
        long fireTime;
        double bulletVelocity, directAngle, distanceTraveled;
        int direction;
		static final int BUFFERS = 8;
		double[][] buffer = new double[BUFFERS][];
		static double[] fastBuffer = new double[BINS];
		private static final double MAX_DISTANCE = 1000.0;

//        public EnemyWave(double velocity, double lastVelocity, double distance) {
        public EnemyWave(double velocity, double lastVelocity, double distance, double enemyBulletPower) {
            bulletVelocity = bulletVelocity(enemyBulletPower);
			int velocityIndex = (int) Math.abs(velocity / 2);
			int lastVelocityIndex = (int) Math.abs(lastVelocity / 2);
			int distanceIndex = (int)(distance / (MAX_DISTANCE / DISTANCE_INDEXES));
			int wallIndex = !_fieldRect.contains(project(_myLocation, goingAngle, 200)) ? 1 : 0;
			buffer[7] = _surfStats7[velocityIndex][lastVelocityIndex][distanceIndex][wallIndex][(int) enemyBulletPower];
			buffer[6] = _surfStats6[velocityIndex][lastVelocityIndex][distanceIndex][wallIndex];
			buffer[5] = _surfStats5[velocityIndex][lastVelocityIndex][distanceIndex];
			buffer[4] = _surfStats4[velocityIndex][lastVelocityIndex];
			buffer[3] = _surfStats3[velocityIndex][distanceIndex];
			buffer[2] = _surfStats2[velocityIndex];
			buffer[1] = _surfStats1[distanceIndex];
			buffer[0] = fastBuffer;
		}        
    }

    // CREDIT: Iterative WallSmoothing by Kawigi
    //   - return absolute angle to move at after account for WallSmoothing
    // robowiki.net?WallSmoothing
    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, 200))) {
            angle += orientation * 0.05;
        }
        return angle;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return (20D - (3D*power));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }
/*
    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle =
            Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            robot.setAhead(100);
        }
    }
*/
    public static void setBackAsFront(AdvancedRobot robot, double angle) {
        angle =
            Utils.normalRelativeAngle(angle - robot.getHeadingRadians());		
		double turnAngle = Math.atan(Math.tan(angle));
	    robot.setTurnRightRadians(turnAngle);
        robot.setAhead(angle == turnAngle ? 100 : -100);
	}
	
	static Point2D project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	
	static double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
}																											