package hapiel;
import robocode.*;
import robocode.util.*;


/**
 * Spiral - a robot by Hapiel (Netherlands)
 */
public class Spiral extends AdvancedRobot {
	int speed = 100;
	boolean hit = false;
	double previousEnergy;
	int miss = 0;
	boolean inWall = false;
	public void run() {
	
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		setAhead(speed);
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
		
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
		if (Math.random()*miss < 6){
			setTurnGunRightRadians(Utils.normalRelativeAngle(getGunTurnRemainingRadians() + 
			(e.getVelocity() * Math.sin(e.getHeadingRadians() - 
    		absoluteBearing) / 13.0)));
		} 
		setTurnRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + Math.PI/2 - getVelocity()/50));
	    
		setFire((3 - e.getDistance() / 200) * (getEnergy() / 70));// *getenery/70: 9 bytes
		
		if (previousEnergy != e.getEnergy() && !hit && Math.random() > .3) {
		speed *=-1;
		}
		previousEnergy = e.getEnergy();
		hit = false;



	}

	public void onBulletHit(BulletHitEvent e) {
		hit = true;
	}

	public void onBulletMissed (BulletMissedEvent e) {
		miss ++;
	}
	public void onHitWall(HitWallEvent e) {
	
		speed *= -1;
	}	
}
