package ags.rougedc.radar;

import static robocode.util.Utils.normalRelativeAngle;
import ags.rougedc.base.actors.RadarActor;
import ags.rougedc.robots.*;

public class BasicRadar {
    private final StatusRobot status;
    private final EnemyList enemies;
    private static final double TURN_PAST = ((2*Math.PI)/40); //36
    
    public BasicRadar(StatusRobot status, EnemyList enemies) {
        this.enemies = enemies;
        this.status = status;
    }
    
    public void run(RadarActor actor) {
        EnemyRobot target = enemies.getTarget();
        
        if (target == null) {
            // No target, spin
            actor.setTurnRadar(Double.POSITIVE_INFINITY);
        } else {
            // Target found! Focus the radar on it!
            double radarturn = normalRelativeAngle(target.getRelativeLocation().getDirection() - status.getRadarHeading());
            
            // Sweep past the target by a certain amount
            if  (radarturn >= 0)
                radarturn += TURN_PAST;
            else
                radarturn -= TURN_PAST;
            
            actor.setTurnRadar(radarturn);
        }
    }
}
