package gh.ghutils;

import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;

/**
 * GunWave
 *
 * This class represents the firing waves of my guns
 * Credit: Refactoring inspired by Dookious by Voidious
 *
 * This code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */
public class GunWave {

		public int fireTime;
		public boolean bulletWave;
		public double bulletVelocity;
		public double HOTAngle;
		public double maxEscAngle;
		public double direction;
		public Point2D.Double fireLocation	= new Point2D.Double();
		public Point2D.Double pposcw		= new Point2D.Double();
		public Point2D.Double pposccw		= new Point2D.Double();
		public int accelerationBin;
//		private int distanceBin;
		public int vlateralBin;
		public int wallProxBin;
		public int dist14Bin;
		private int minimumBin = GHUtils.GBINS - 1;
		private int maximumBin = 0;
		public int  hittedBin = -1;		// real hit (anti-surfer purposes)
		public int  bestGun;			// gun that fired this wave
		public int[] gunBin = new int[9];
		public ArrayList<Point2D.Double> pntcw = new ArrayList<Point2D.Double>();
		public ArrayList<Point2D.Double> pntccw = new ArrayList<Point2D.Double>();

	public GunWave() { }

		/**
		 * wavepasscheck: Check if wave passed the current position of the enemy
		 */
		public boolean wavepasscheck() {

			int hitbin;
			Rectangle2D.Double enemySpace;	// the space the enemy occupies
			Line2D.Double  bullet  = new Line2D.Double();
		    double waveDistance = bulletVelocity * ( TickState.currTime - fireTime);
	    	if (waveDistance > fireLocation.distance( TickState.getEnemyPos()) + 40) {
//System.out.println("Hit on bins "+minimumBin+" till "+maximumBin);
				return true;		// wave has passed, process it in stats
			}
			if (waveDistance > fireLocation.distance( TickState.getEnemyPos()) - 3 * bulletVelocity) {
				enemySpace = new Rectangle2D.Double( TickState.getEnemyPos().getX() - GHUtils.HALFBOTWIDTH,
													 TickState.getEnemyPos().getY() - GHUtils.HALFBOTWIDTH, GHUtils.BOTWIDTH, GHUtils.BOTWIDTH);
				if (maximumBin == 0) {
					hitbin = getHittedBin( TickState.getEnemyPos());
				} else {
					hitbin = minimumBin;
				}

				for (int tbin = hitbin; tbin >= 0; tbin--) {
					double tguessfactor = (double)(tbin - GHUtils.GMIDBIN) / GHUtils.GMIDBIN;
					double tangleOffset = direction * tguessfactor * maxEscAngle;
					double thead = Utils.normalRelativeAngle( HOTAngle + tangleOffset);
					bullet.setLine( GHUtils.doProjectPos( fireLocation, thead, waveDistance),
									GHUtils.doProjectPos( fireLocation, thead, waveDistance + bulletVelocity));
					if (bullet.intersects( enemySpace))
						minimumBin = tbin;
					else
						break;
				} 
				if (maximumBin != 0)
					hitbin = maximumBin;
				for (int tbin = hitbin; tbin < GHUtils.GBINS; tbin++) {
					double tguessfactor = (double)(tbin - GHUtils.GMIDBIN) / GHUtils.GMIDBIN;
					double tangleOffset = direction * tguessfactor * maxEscAngle;
					double thead = Utils.normalRelativeAngle( HOTAngle + tangleOffset);
					bullet.setLine( GHUtils.doProjectPos( fireLocation, thead, waveDistance),
									GHUtils.doProjectPos( fireLocation, thead, waveDistance + bulletVelocity));
					if (bullet.intersects( enemySpace))
						maximumBin = tbin;
					else
						break;
				} 
			}
			return false;
		}

		// gethittedbin: Return the bin that was hit
		public int getHittedBin( Point2D.Double hitLocation) {
			double hitAngle = GHUtils.doGetAngle( fireLocation, hitLocation);
			double angleDiff = Utils.normalRelativeAngle( hitAngle - HOTAngle);
			double guessFactor = Math.max(-1, Math.min(1, angleDiff / maxEscAngle)) * direction;
			return (int)Math.round( GHUtils.GMIDBIN * ( guessFactor + 1.0));
		}

		// getminbin: Get the lowest bin that was hit by the wave
		public int getminbin( ) {
			return Math.max(0, minimumBin);
		}

		// getmaxbin: Get the highest bin that was hit by the wave
		public int getmaxbin( ) {
			return Math.min(maximumBin, GHUtils.GBINS - 1);
		}

		/**
		 * getWaveDistance: return the distance the wave has travelled since firing
		 *                    for onPaint()
		 */
//		public double getWaveDistance() {
//		    return (bulletVelocity * ( TickState.currTime - fireTime));
//		}

}
