package ags.rougedc.research;

import robocode.Bullet;
import robocode.RobocodeFileOutputStream;
import robocode.AdvancedRobot;

import ags.rougedc.waves.*;
import ags.rougedc.robots.*;
import ags.utils.points.*;

import java.util.List;
import java.util.LinkedList;

/**
 * @author Alexander Schultz
 */
public class SituationRecorder {
    private final static List<Situation> list = new LinkedList<Situation>();
    private final static long key = Math.round(Math.random()*1000000); 
    
    public void recordSituation(EnemyWave wave, Bullet bullet) {
        Situation situation = new Situation();
        
        VirtualRobot me = wave.getStaticTarget();
        RelativePoint v = me.getVelocity();
        AbsolutePoint origin = wave.getOrigin();
        AbsolutePoint bulletpos = AbsolutePoint.fromXY(bullet.getX(), bullet.getY());
        
        situation.distance = origin.distance(me.getLocation());
        situation.lateralvelocity = Math.abs(v.magnitude * Math.sin(v.getDirection() - wave.getHOTAngle()));
        situation.advancingvelocity = (v.magnitude * -Math.cos(v.getDirection() - wave.getHOTAngle()));
        
        situation.guessfactor = wave.getGuessFactor(bulletpos);
        
        list.add(situation);
    }
    
    public void saveRecord(AdvancedRobot bot) {
        java.io.File file = bot.getDataFile("log_"+key+".gz");
        try {
            java.io.OutputStream filestream = new RobocodeFileOutputStream(file);
            java.io.OutputStream zipstream = new java.util.zip.GZIPOutputStream(filestream);
            java.io.ObjectOutputStream obstream = new java.io.ObjectOutputStream(zipstream);
            obstream.writeObject(list.toArray());
            obstream.flush();
            zipstream.close();
            filestream.close();
        } catch (java.io.IOException e) {
            e.printStackTrace(System.out);
        }
    }
}
