package bvh.mini;

import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class Wodan extends AdvancedRobot implements Constanten {
   //*********************************************************************
   // Definitie van variabelen
   //*********************************************************************
   private static boolean vervlakBewegingsProfiel = false;
   private static Point2D.Double doelPositie;
   private static Point2D.Double rotatiePositie;

   static double[][][][][][] guessFactors = new double[AFSTANDSEGMENTEN + 1][POSITIESEGMENTEN][VERSNELLINGSSEGMENTEN][LATERALESNELHEIDSSEGMENTEN][TRANSVERSALESNELHEIDSSEGMENTEN][(2 * GF_MIDDEN)
      + 1];

   // beweging
   private int cirkelDir = 1;
   private double xMax;
   private double yMax;
   private int GF1Hits;
   private int tijdSindsOmkerenBeweging;
   private Ellipse2D.Double maximumCirkel;

   // tegenstander
   private double doelRichting;
   private double doelEnergie;
   private double doelAfstand;
   private double doelSnelheid;
   private double doelCirkelRichting;

   // meest recente kogel
   private double kogelSnelheid = 11D;
   private long kogelVuurtijd = 0;

   //*********************************************************************
   // Definitie van methods
   //*********************************************************************

   /**
    * run: Wodan's hoofdroutine:
    */
   public void run() {
      setColors(Color.red, Color.black, Color.red);

      setAdjustGunForRobotTurn(true);
      setAdjustRadarForGunTurn(true);

      maximumCirkel = new Ellipse2D.Double(WANDAFSTAND, WANDAFSTAND,
            (xMax = getBattleFieldWidth()) - (2 * WANDAFSTAND), (yMax = getBattleFieldHeight()) - (2 * WANDAFSTAND));

      doelPositie = rotatiePositie = new Point2D.Double(doelEnergie = 100D, doelCirkelRichting = 1);

      do {
          turnRadarRightRadians(Double.POSITIVE_INFINITY);
      } while (true);
   }

   //*********************************************************************
   // Methods voor event-afhandeling:
   //*********************************************************************
   /**
    * onScannedRobot: What to do when you see another robot
    * let op: van alle scanned bots tijdens een radar-sweep wordt de dichtstbijzijnde bot doorgegegeven!
    */
   public void onScannedRobot(ScannedRobotEvent evt) {
      Point2D.Double positie = new Point2D.Double(getX(), getY());

      double deltaE;
      if (((deltaE = doelEnergie - (doelEnergie = evt.getEnergy())) > 0D) && (deltaE <= 3D)) {
         rotatiePositie = new Point2D.Double(doelPositie.x, doelPositie.y);
         kogelSnelheid = berekenKogelSnelheid(deltaE);
         kogelVuurtijd = getTime();
      }

      doelRichting = getHeadingRadians() + evt.getBearingRadians();
      doelAfstand = evt.getDistance();
      doelPositie = projecteerPositie(positie, doelRichting, doelAfstand);

      if (((getTime() - kogelVuurtijd) * kogelSnelheid) > rotatiePositie.distance(positie)) {
         rotatiePositie = doelPositie;
      }

      int lateraleSnelheidsIndex = (int) (evt.getVelocity() * Math.sin(evt.getHeadingRadians()-doelRichting)/3D);
      int transversaleSnelheidsIndex = (int)(3D-evt.getVelocity() * Math.cos(evt.getHeadingRadians() - doelRichting)/3D);

      double cirkelRichting;
      if (evt.getVelocity() != 0) {
         cirkelRichting = (lateraleSnelheidsIndex < 0) ? -1 : 1;
      } else {
         cirkelRichting = doelCirkelRichting;
      }
      doelCirkelRichting = cirkelRichting;
    
      int versnellingsIndex = (int) Math.round(doelSnelheid - (doelSnelheid = Math.abs(evt.getVelocity())));
      if (versnellingsIndex != 0) {
          versnellingsIndex = (versnellingsIndex < 0) ? 1 : 2;
      }
       
      // creeer test-golf:
      double kanonVuurkracht = (doelAfstand < 100D) ? MAXVUURKRACHT : STANDAARDVUURKRACHT;
      MicroGolf mg = new MicroGolf(new Point2D.Double(getX(), getY()),
         doelRichting, 
         berekenKogelSnelheid(kanonVuurkracht), 
         cirkelRichting, 
         guessFactors[geefAfstandIndex()]
                     [geefPositieIndex()]
                     [versnellingsIndex]
                     [Math.abs(lateraleSnelheidsIndex)]
                     [transversaleSnelheidsIndex]
         );
      navigatie(positie, rotatiePositie);
      stuurKanon(mg, kanonVuurkracht);
      stuurRadar();
   }

   public void onHitByBullet(HitByBulletEvent evt) {
      if ((doelAfstand > 250D) && (tijdSindsOmkerenBeweging > (doelAfstand / evt.getVelocity()))) {
         vervlakBewegingsProfiel = ++GF1Hits > 1;
      }
   }

   //*********************************************************************
   // Methods voor navigatie en kanonsturing:
   //*********************************************************************
   private void navigatie(Point2D.Double positie, Point2D.Double rotatiePositie) {
         //      if ( botPositie.distance(bestemming) < 15D ) {
         tijdSindsOmkerenBeweging++;

         // op willekeurige momenten van bewegingsrichting veranderen om een plat profiel
         // te krijgen: niet te vaak omdat dan een piek ontstaat op GF=0, niet te weinig
         // omdat bot dan kwetsbaar wordt voor zogenaamde Head-On targetting:
         if (((Math.abs(getHeadingRadians() - doelRichting) < EENACHTSTEPI) && (tijdSindsOmkerenBeweging > 8)) ||
               (vervlakBewegingsProfiel && (Math.random() < 0.09)) ||
               (getTime() > (kogelVuurtijd + ((0.85 * rotatiePositie.distance(positie)) / kogelSnelheid)))) {
            tijdSindsOmkerenBeweging = 0;
            cirkelDir *= -1;

            if (Math.random() < 0.002) {
               vervlakBewegingsProfiel = false;
            }
         }

         // bewegingsrichting kiezen loodrecht op richting naar doel: bij afwijking van de
         // voorkeursafstand naderen/wijken:
         // bestemming kiezen door om doel heen te draaien. Indien de nieuwe positie niet
         // binnen het slagveld valt, dan afstand/draaihoek aanpassen tot dit wel het geval is.
      Point2D.Double bestemming = null;
      int pogingen = 0;
         do {
            bestemming = projecteerPositie(rotatiePositie,
                  bepaalRichting(rotatiePositie, positie) + (cirkelDir * (EENZESTIENDEPI + (pogingen * 0.022))),
                  rotatiePositie.distance(positie) * (1.05 - (pogingen / 300.0)));
         } while ((pogingen++ < 100) && !slagveld(WANDAFSTAND).contains(bestemming));

         // controleer of draaihoek gelijk is aan minimale draaihoek:
         double hoek = Utils.normalRelativeAngle(bepaalRichting(positie, bestemming) - getHeadingRadians());
         double draaiHoek = Math.atan(Math.tan(hoek));

         // draai en verplaats robot:
         setTurnRightRadians(draaiHoek);
         setAhead(positie.distance(bestemming) * ((hoek == draaiHoek) ? 1 : (-1)));

         // eventueel snelheid minderen om sneller te kunnen draaien:
         setMaxVelocity( Math.abs(getTurnRemainingRadians()) > KWARTPI ? (90D-Math.abs(getTurnRemaining()))/7.5D : MAXIMUM_SNELHEID );
   }

   private RoundRectangle2D slagveld(double wandafstand) {
      return new RoundRectangle2D.Double(wandafstand, wandafstand, xMax - (wandafstand * 2D),
         yMax - (wandafstand * 2D), RONDING, RONDING);
   }

   //*********************************************************************
   // Kanon sturing
   //*********************************************************************
   private void stuurKanon(MicroGolf mg, double kanonVuurkracht) {
      //System.out.println("stuurKanon()");      

      /*
       * bin-smoothing + MaxGF bepalen:
       */
      int schattingGF = GF_MIDDEN;

      if (!(doelEnergie == 0 && doelSnelheid == 0)) {
         int smoothWidth = Math.max((int) Math.round(
                  ((2.0D * GF_MIDDEN + 1.0D) * Math.atan((0.5 * BOTBREEDTE) / doelAfstand)) / Math.asin(
                     MAXIMUM_SNELHEID / berekenKogelSnelheid(kanonVuurkracht))), 1);
         double[] test = new double[(2 * GF_MIDDEN) + 1];

         // window de data met een driehoekig filter:
         for (int gf = 0; gf <= (2 * GF_MIDDEN); gf++) {
            for (int j = -smoothWidth; j < smoothWidth; j++) {
               double factor = (j == 0) ? 1D : (1 / Math.abs(j));
               test[gf] += factor * mg.opzoekTabel[Math.max(0, Math.min(2 * GF_MIDDEN, gf + j))];
            }
         }

         // bin-aging en bepaal beste GF:
         for (int gf = 0; gf <= (2 * GF_MIDDEN); gf++) {
            mg.opzoekTabel[gf] *= 0.999;
            if (test[gf] > test[schattingGF]) {
               schattingGF = gf;
            }
         }
      }

      setTurnGunRightRadians(Utils.normalRelativeAngle(doelRichting - getGunHeadingRadians()
            + (mg.cirkelRichting * (schattingGF - GF_MIDDEN))));

      if (getEnergy() > kanonVuurkracht) {
         addCustomEvent(mg);

         if (setFireBullet(kanonVuurkracht) != null) {
            // extra gewicht toekennen aan test-golven die daadwerkelijk afgevuurde kogel representeren.
            mg.waarde = 1;
         }
      }
   }

    //*********************************************************************
    // Radar sturing
    //*********************************************************************
    private void stuurRadar() {
       setTurnRadarRightRadians(2.0D * Utils.normalRelativeAngle(doelRichting - getRadarHeadingRadians()));
    }
   //*********************************************************************
   // hulp methods
   //*********************************************************************
   private static Point2D.Double projecteerPositie(Point2D.Double pos, double richting, double afstand) {
      return new Point2D.Double(pos.x + (afstand * Math.sin(richting)), pos.y + (afstand * Math.cos(richting)));
   }

   private static double bepaalRichting(Point2D.Double oorsprong, Point2D.Double doel) {
      return Math.atan2((doel.x - oorsprong.x), (doel.y - oorsprong.y));
   }

    private double berekenKogelSnelheid(double kanonVuurkracht) {
       return (20D - (3D * kanonVuurkracht));
    }

    private int geefAfstandIndex() {
       return(Math.min((int)Math.round(doelAfstand/100D), AFSTANDSEGMENTEN));
    //       return(Math.min((int)Math.floor(doelAfstand/100D), AFSTANDSEGMENTEN));
    }
    private int geefPositieIndex() {
       return(maximumCirkel.contains(doelPositie) ? 0 : 1);
    //       return((new Ellipse2D.Double(0, 0, getBattleFieldWidth(), getBattleFieldHeight())).contains(doelPositie) ? ((new Ellipse2D.Double( (getBattleFieldWidth()-DIAMETERBINNENCIRKEL)/2D, (getBattleFieldHeight()+DIAMETERBINNENCIRKEL)/2D, DIAMETERBINNENCIRKEL, DIAMETERBINNENCIRKEL)).contains(doelPositie) ? 1 : 2) : 0);
    }

   //*********************************************************************
   // innerclass met de golf.
   //*********************************************************************
   class MicroGolf extends Condition {
      int waarde;
      Point2D.Double startPositie;
      double richting;
      double afstand;
      double cirkelRichting;
      double kogelSnelheid;
      double[] opzoekTabel;

      public MicroGolf(Point2D.Double positie, double doelRichting, double kogelSnelheid, double cirkelRichting,
         double[] stats) {
         this.startPositie = positie;
         this.richting = doelRichting;
         this.kogelSnelheid = kogelSnelheid;
         this.cirkelRichting = cirkelRichting * Math.asin(MAXIMUM_SNELHEID / this.kogelSnelheid) / GF_MIDDEN;
         this.opzoekTabel = stats;
         this.waarde = 1;
      }

      public boolean test() {
         double nabijheid = (afstand += kogelSnelheid) - Wodan.doelPositie.distance(startPositie);

         if (Math.abs(nabijheid) <= 20) {
            try {
               opzoekTabel[(int) Math.round(Utils.normalRelativeAngle(bepaalRichting(startPositie, Wodan.doelPositie)
                     - richting) / cirkelRichting) + GF_MIDDEN]+=waarde;
            } catch (ArrayIndexOutOfBoundsException e) {
            }
         }

          if (nabijheid >= 20) {
             removeCustomEvent(this);
          }

         return false;
      }
   }
}
