package hamilton;

public class LinearAiming extends StationaryAiming
{
	static public FiringSolution getSolution(AimingInfo someInfo)
	{
		double firepower = calculateFirepower(someInfo);
		double bulletVelocity = 20 - (3 * firepower);
		
		double timeOfFlight = someInfo.targetDistance / bulletVelocity;
		
		double averageVelocity = Calculator.getMaxForwardDistance(timeOfFlight, someInfo.getTargetVelocity()) / timeOfFlight;
		
		// System.out.println(someInfo.getTargetVelocity() + ", " + averageVelocity + ", " + estimatedTimeOfFlight);
		
		double theta = Math.asin((Math.sin(someInfo.getTargetRelativeHeading()) * averageVelocity) / bulletVelocity);
		
		double c = Math.PI - (Math.abs(theta) - Math.abs(someInfo.getTargetRelativeHeading()));

		double bulletPathDistance = Math.abs((someInfo.targetDistance * Math.sin(someInfo.getTargetRelativeHeading())) / Math.sin(c));

		double newTimeOfFlight = bulletPathDistance / bulletVelocity;
		
		double error = Math.abs(newTimeOfFlight - timeOfFlight);
		
		while (error > .1)
		{
			timeOfFlight = newTimeOfFlight;
			averageVelocity = Calculator.getMaxForwardDistance(timeOfFlight, someInfo.getTargetVelocity()) / timeOfFlight;
			theta = Math.asin((Math.sin(someInfo.getTargetRelativeHeading()) * averageVelocity) / bulletVelocity);
			c = Math.PI - (Math.abs(theta) - Math.abs(someInfo.getTargetRelativeHeading()));
			bulletPathDistance = Math.abs((someInfo.targetDistance * Math.sin(someInfo.getTargetRelativeHeading())) / Math.sin(c));
			newTimeOfFlight = bulletPathDistance / bulletVelocity;
			error = Math.abs(newTimeOfFlight - timeOfFlight);
		}

		double bearing = Calculator.normalizeAngle(someInfo.getTargetAbsoluteBearing() + theta);
		
		double xi = Math.sin(bearing) * bulletPathDistance;
		double yi = Math.cos(bearing) * bulletPathDistance;
		
		Coordinate interceptPoint =  new Coordinate (someInfo.robotCoordinates.getX() + xi, someInfo.robotCoordinates.getY() + yi);
		
		boolean validity = interceptPoint.isOnField(someInfo.r.getBattleFieldWidth() - 10, someInfo.r.getBattleFieldHeight() - 10);
		
		while (!validity && firepower > .1)
		{
			firepower *= .75;
			bulletVelocity = 20 - (3 * firepower);
			theta = Math.asin((Math.sin(someInfo.getTargetRelativeHeading()) * someInfo.targetVelocity) / bulletVelocity);

			while (error > .1)
			{
				timeOfFlight = newTimeOfFlight;
				averageVelocity = Calculator.getMaxForwardDistance(timeOfFlight, someInfo.getTargetVelocity()) / timeOfFlight;
				theta = Math.asin((Math.sin(someInfo.getTargetRelativeHeading()) * averageVelocity) / bulletVelocity);
				c = Math.PI - (Math.abs(theta) - Math.abs(someInfo.getTargetRelativeHeading()));
				bulletPathDistance = Math.abs((someInfo.targetDistance * Math.sin(someInfo.getTargetRelativeHeading())) / Math.sin(c));
				newTimeOfFlight = bulletPathDistance / bulletVelocity;
				error = Math.abs(newTimeOfFlight - timeOfFlight);
			}			
						
			bearing = Calculator.normalizeAngle(someInfo.targetAbsoluteBearing + theta);

			c = Math.PI - (Math.abs(theta) - Math.abs(someInfo.getTargetRelativeHeading()));

			bulletPathDistance = Math.abs((someInfo.targetDistance * Math.sin(someInfo.getTargetRelativeHeading())) / Math.sin(c));
		
			xi = Math.sin(bearing) * bulletPathDistance;
			yi = Math.cos(bearing) * bulletPathDistance;
		
			interceptPoint =  new Coordinate (someInfo.robotCoordinates.getX() + xi, someInfo.robotCoordinates.getY() + yi);
			validity = interceptPoint.isOnField(someInfo.r.getBattleFieldWidth() - 10, someInfo.r.getBattleFieldHeight() - 10);
		}	
		
		if (someInfo.r.getGunHeat() == .0) System.out.println(validity + " = " + interceptPoint.x + "," + interceptPoint.y);
				
		bearing = Calculator.normalizeAngle(someInfo.getTargetAbsoluteBearing() + theta);
		return new FiringSolution(bearing, firepower, validity);
	}

}
