package hamilton;

public class RandomLinearAiming extends StationaryAiming
{
	static public FiringSolution getSolution(AimingInfo someInfo)
	{
		double firepower = calculateFirepower(someInfo);
		double bulletVelocity = 20 - (3 * firepower);
		
		double theta = Math.asin((Math.sin(someInfo.getTargetRelativeHeading()) * someInfo.getTargetVelocity()) / bulletVelocity);
		
		double c = Math.PI - (Math.abs(theta) - Math.abs(someInfo.getTargetRelativeHeading()));

		double bulletPathDistance = Math.abs((someInfo.targetDistance * Math.sin(someInfo.getTargetRelativeHeading())) / Math.sin(c));

		double bearing = Calculator.normalizeAngle(someInfo.getTargetAbsoluteBearing() + theta);
		
		double xi = Math.sin(bearing) * bulletPathDistance;
		double yi = Math.cos(bearing) * bulletPathDistance;
		
		Coordinate interceptPoint =  new Coordinate (someInfo.robotCoordinates.getX() + xi, someInfo.robotCoordinates.getY() + yi);
		
		boolean validity = interceptPoint.isOnField(someInfo.r.getBattleFieldWidth(), someInfo.r.getBattleFieldHeight());
		
		while (!validity && firepower > .1)
		{
			firepower *= .75;
			bulletVelocity = 20 - (3 * firepower);
			theta = Math.asin((Math.sin(someInfo.getTargetRelativeHeading()) * someInfo.targetVelocity) / bulletVelocity);
			bearing = Calculator.normalizeAngle(someInfo.targetAbsoluteBearing + theta);

			c = Math.PI - (Math.abs(theta) - Math.abs(someInfo.getTargetRelativeHeading()));

			bulletPathDistance = Math.abs((someInfo.targetDistance * Math.sin(someInfo.getTargetRelativeHeading())) / Math.sin(c));
		
			xi = Math.sin(bearing) * bulletPathDistance;
			yi = Math.cos(bearing) * bulletPathDistance;
		
			interceptPoint =  new Coordinate (someInfo.robotCoordinates.getX() + xi, someInfo.robotCoordinates.getY() + yi);
			validity = interceptPoint.isOnField(someInfo.r.getBattleFieldWidth(), someInfo.r.getBattleFieldHeight());
		}	
				
		bearing = Calculator.normalizeAngle(someInfo.getTargetAbsoluteBearing() + (theta * Math.random()));
		return new FiringSolution(bearing, firepower, validity);
	}
	
	static public double calculateFirepower(AimingInfo someInfo)
	{
		double energyFirepower = (someInfo.aimingTarget.getEnergy() / 4) + .1;

		return Math.min(energyFirepower, (Math.random() * 3) );
	}	

}
