package m3thos.mini;

/**
 * Enemy data structure!
 * Version2 for Eva01. - smaller codesize for minibot.
 * @author  Miguel Sousa Filipe
 */
public class Enemy
{
    static private final int LINEAR = 0; // linear targeting, the most important one
    static private final int DIRECT = 1; // direct targeting, it's when linear is performing very bad.
    // eco targeting, used when both are bad performers, will shoot only half of the requests
    static private final int ECO = 2;
    public String name;                    // the present target name.
    public int fireType;                // tells us what type of fire to use against this enemy.
    public double distance;         // the present distance from target
    public double avgSpeed;         // the target's Average speed
    public long lsTime;             // the time we last seen the target.
    public double bearing, heading;
    public double energy;           // to calculate things like firepower
    private float linearShots, linearHits, directShots, directHits;
    
    /** Creates a new instance of Enemy */
    public Enemy()
    { reset(); }
    
    public void updateTargetAvgSpeed(double speed)
    {
        avgSpeed = avgSpeed * 0.70 + speed * 0.30;
    }
    
    public float getHitRatio(int type)
    {
        if (type == DIRECT)
                return directHits / directShots;
        return linearHits / linearShots;
    }

    public void incHits()
    {
        if( fireType == DIRECT )
            directHits++;
        else
            linearHits++;
    }
    
    public void incShots()
    {
        if( fireType == DIRECT ) directShots++;
        else linearShots++;
    }
            
    /**
     * calcFirePower: Method to calculate the fire power for shooting this target
     *  it uses, our energy, distance and energy of the target.
     */
    public double calcFirePower(double myEnergy)
    {
        double power, damage;
        power = (energy / 100) + (300 / distance);
        damage = myEnergy / 10;
        if( damage < 1 )
            power *= damage;
        
        if (power > 3) 
            power = 3;
//        damage = ((power > 1)? ((6 * power) -2):(4 * power)); 
//        if (energy < damage)
//        {
//            power = ((energy/4 > 1)? ((energy + 2)/6):(energy / 4));
//        }
        return power;
    }
    
    /**
	 * updateFireType()
	 * there are 3 types
	 * LINEAR - linear predictive targeting
	 * DIRECT - shots to where the target is at the moment.
	 * ECO - linear predictive targeting but only shots half the times LINEAR shots.
	 * selection is based on success (hit ratio).
	 */
	public void updateFireType()
    {
        if ( fireType == LINEAR && linearShots > 10 && getHitRatio(LINEAR) < 0.11 )
            fireType = ((getHitRatio(DIRECT) < getHitRatio(LINEAR) && directShots > 10)? ECO : DIRECT);
        else if( getHitRatio(DIRECT) < 0.11 && directShots > 10 )
			fireType = LINEAR;
    }
    
    // to reset the Enemy Structure.
    public void reset()
    {
        linearShots = 0;
        linearHits = 0;
        directShots = 0;
        directHits = 0;
        fireType = LINEAR;
        bearing = 0;
        heading = 0;
        energy = 0;
        avgSpeed = 0;
        distance = 99999;
        name = "_null_";
    }
}
