package dz;
import robocode.*;
//import java.awt.Color;

/**
 * OthoMicro - a robot by Rational Insanity
 */
public class OthoMicro extends AdvancedRobot
{
	static double enemyEnergy;
	static double bulletSpeed; //Speed of enemy's bullets.
	static double radarMove = 0.785398; // =PI/4
	static double eHeading; //Enemy's heading.
	static long lastMove; //Time of last movement.
	
	// 0 is for velocity; 1 is for heading change.
	static double pattern [][];
	static int index = 0;
	
	public void run() {
		//setColors(Color.blue,Color.yellow,Color.yellow);
		lastMove = 0;
		if(getRoundNum() == 0){
			pattern = new double[2000][2];
		}
		while(true) {
			turnRadarRightRadians(radarMove);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		//////////  Movement  //////////////
		
		double energyChange = e.getEnergy() - enemyEnergy;
		if((energyChange) >= -3 && energyChange <= -0.1){
			bulletSpeed = 20 + 3*energyChange; //Note: energychange < 0.
		}
		
		double eDist; //Distance to enemy
		double myX, myY, myHeading;
		//Period of my movement.
		double period = (eDist = e.getDistance())/bulletSpeed;
		//Move randomly.
		double move = (Math.random()*2 - 1)*period * 9;
		//Wall avoidance - approximate future position.
		double wallX = (myX = getX()) + move*Math.sin(myHeading = getHeadingRadians());
		double wallY = (myY = getY()) + move*Math.cos(myHeading);
		//Move if it is the correct time.
		if((lastMove + period) <= getTime()){
			lastMove = getTime();
			//Wall avoidance.
			if(wallX < 18 || wallX > 782 || wallY < 18 || wallY > 582){
				move = -move;
			}
			//Do move.
			setAhead(move);
		}
		
		//Stay perpendicular to enemy - this line is pulled from MyFirstRobot. :)
		setTurnLeft(90 - e.getBearing());
		
		//////////  Aiming  /////////////
		
		//Record data.
		//tempHeading is initial heading of virtual enemy.
		double tempHeading;
		//tempVelocity is initial velocity of virtual enemy.
		//Record velocity and heading change in pattern array.
		double tempVelocity = pattern[index%2000][0] = e.getVelocity();
		pattern[(index++)%2000][1] = robocode.util.Utils.normalRelativeAngle((tempHeading = e.getHeadingRadians()) - eHeading);
		eHeading = tempHeading;
		
		double power = Math.min(3,Math.min(getEnergy(),(enemyEnergy = e.getEnergy()))/4);
		
		double headingToEnemy;
		//Initial position of virtual enemy.
		double x = myX + eDist * Math.sin((headingToEnemy = (e.getBearingRadians() + myHeading))); //Head-on targeting.
		double y = myY + eDist * Math.cos(headingToEnemy);
		//Turn radar.
		radarMove = robocode.util.Utils.normalRelativeAngle(headingToEnemy - getRadarHeadingRadians());
		radarMove += (radarMove >= 0)? 0.3927 : -0.3927; // =PI/8
		
		int timeToTarget = (int)(eDist/(20 - (3 * power)));
		
		//Only use patter matcher if there is sufficient data, the gun is cool, and the enemy is not disabled.
		if(index > 120 && getGunHeat() <= 0.3 && enemyEnergy > 0){
			//Match the pattern.
			double bestError = 10000;
			int bestIndex = 0;
			int offset = (index < 2000)? 0 : index;
			for(int c = (Math.min(index,2000) - timeToTarget + offset); c >= (16 + offset) ; c--){
				double currentError = 0;
				//Calculate error.
				for(int d = 0; d < 16; d += 2){
					currentError += (Math.abs(pattern[(c - d)%2000][0] - pattern[(index-d)%2000][0]) + 30*Math.abs(pattern[(c - d)%2000][1] - pattern[(index-d)%2000][1]))/((d/2)+2);
				}
				if(currentError < bestError){
					bestIndex = c;
					bestError = currentError;
				}
			}
			
			//Calculate enemy's future position.
			for(int c = 0; c < timeToTarget; c++){
				x += tempVelocity*Math.sin(tempHeading);
				y += tempVelocity*Math.cos(tempHeading);
				tempVelocity = pattern[(bestIndex+c)%2000][0];
				tempHeading += pattern[(bestIndex+c)%2000][1];
				//Optional code - not enough room for it in this micro:
				//Improves accuracy against bots that vary their distance to their opponent.
				//timeToTarget = (int)(Math.sqrt(Math.pow((y - myY),2) + Math.pow((x - myX),2))/(20 - 3*power));
			}
			headingToEnemy = Math.atan((x - myX)/(y - myY)) + ((y < myY)? Math.PI:0);
		}
		//Turn gun.
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(headingToEnemy - getGunHeadingRadians()));
		//Fire.
		setFire(power);
	}
}
