package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class RandomPM extends AdvancedRobot {
    private static final double BULLET_POWER = 2.0;
    private static final double BULLET_VELOCITY = 20.0 - 3.0 * BULLET_POWER;
    private static final int MAX_SEARCH_PATTERN_LENGTH = 50;
    
    private static double energy;
    private static double moveAmount;
    private static String pattern = "" + 
	(char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + 
	(char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + 
	(char)1 + (char)2 + (char)3 + (char)4 + (char)5 + (char)6 + (char)7 + (char)8 + 
	(char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + 
	(char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + 
	(char)7 + (char)6 + (char)5 + (char)4 + (char)3 + (char)2 + (char)1 + (char)0 +
	(char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	(char)-1 + (char)-2 + (char)-3 + (char)-4 + (char)-5 + (char)-6 + (char)-7 + (char)-8 + 
	(char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + 
	(char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + 
	(char)-7 + (char)-6 + (char)-5 + (char)-4 + (char)-3 + (char)-2 + (char)-1 + (char)0 + 
	(char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	(char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    
    @Override
    @SuppressWarnings("empty-statement")
    public void onScannedRobot(ScannedRobotEvent e) {
	double angle;
	
	// Radar
	setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
	
	// Targeting
	int i = MAX_SEARCH_PATTERN_LENGTH;
	int matchIndex;
	
	pattern = String.valueOf((char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - (angle = getHeadingRadians() + e.getBearingRadians())))).concat(pattern);
	
	while((matchIndex = pattern.indexOf(pattern.substring(0, i--), (int)(e.getDistance() / BULLET_VELOCITY + 1.0))) < 0);
	i = (int)(e.getDistance() / BULLET_VELOCITY + 1.0);
	do { angle += Math.asin(((short)pattern.charAt(--matchIndex)) / e.getDistance()); } while (--i > 0);
	
	setTurnGunRightRadians(Utils.normalRelativeAngle(angle - getGunHeadingRadians()));
	setFire(BULLET_POWER);
	
	// Movement
	setTurnRightRadians(Math.cos(e.getBearingRadians()));
	if(energy > (energy = e.getEnergy())) {
	    setAhead(moveAmount = 1000 * (Math.random() - 0.5));
	}
    }
    
    @Override
    public void onHitWall(HitWallEvent e) {
	setAhead(moveAmount = -moveAmount);
    }
}
