package theo.simple;
import theo.simple.gun.LucidGun;
import theo.simple.radar.Radar;
import theo.simple.enemy.Enemy;
import theo.simple.surf.LucidSurf;
import robocode.*;
import java.awt.Color;
import java.util.*;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Point2D;
import java.awt.Graphics2D;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Lucid - a robot by Damij
 */
public class Lucid extends AdvancedRobot
{

	static LucidGun weapon;
	static LucidSurf dodger;
	Radar radar;
	Enemy target;
	
	public static Rectangle2D.Double playField;
	public static Point2D.Double midPoint;

	String enemyName = "";
	
	static ArrayList<Enemy> _enemyList;
	
	public static final boolean isMC = false, isTC = false;
	
	static {
		_enemyList = new ArrayList<Enemy>();
	}
	
	public void run() {
		
		if(weapon == null){
			weapon = new LucidGun(this);
		}
		

		midPoint = new Point2D.Double(super.getBattleFieldWidth()/2.0,super.getBattleFieldHeight()/2.0);
		
		if(dodger == null){
			dodger = new LucidSurf(this);
		}
		
		if(playField == null){
			playField = new Rectangle2D.Double(18d,18d,super.getBattleFieldWidth()-36d,super.getBattleFieldHeight()-36d);
		}
		
		this.radar = new Radar(this);
		
		super.setColors(Color.orange,Color.black,Color.orange);
		
		super.setAdjustRadarForGunTurn(true);
		super.setAdjustGunForRobotTurn(true);
		super.setAdjustRadarForRobotTurn(true);

		// Robot main loop
		while(true) {
			super.turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		boolean faced = false;
		Enemy scanned = new Enemy(this, e);
		for(Enemy potential : _enemyList){
			if(potential.name.equals(scanned.name)){
				faced = true;
				potential.update(e);
				break;
			}
		}
		if(!faced){
			scanned.update(e);
			_enemyList.add(scanned);
		}
		this.target = this.getClosestEnemy();
		this.radar.update(target, e);
		if(this.target!=null){
			if(!isTC)
				weapon.update(target, e);
		}
		
		this.enemyName = this.target.name;
		
		if(!isMC)
			dodger.update(target, _enemyList, e);
		
		super.execute();
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		this.dodger.onHit(e.getBullet());
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e){
		this.dodger.onHit(e.getHitBullet());
	}
	
	private Enemy getClosestEnemy(){
		double minDist = Double.POSITIVE_INFINITY, dist;
		Enemy toTarget = null;
		for(Enemy e : _enemyList){
			dist = e.distance;
			if(dist<=minDist){
				minDist = dist;
				toTarget = e;
			}
		}
		return toTarget;
	}
	
	public void onRobotDeath(RobotDeathEvent e){
		for(int i = 0; i < _enemyList.size(); i ++){
			Enemy r = (Enemy)_enemyList.get(i);
			if(r.name.equals(e.getName())){
				_enemyList.remove(r);
				i --;
			}
		}
	}
	
	public void onWin(WinEvent e){
		weapon.onWin(e);
		dodger.onWin(e);
	}
	
	public void onDeath(DeathEvent e){
		weapon.onDeath(e);
		dodger.onDeath(e);
	}
	
	public void onPaint(Graphics2D g){
		dodger.onPaint(g);
	}
}