package nat.ether.utils;

import java.awt.geom.Point2D;


/**
 * M - combination of FastTrig, java.lang.Math and robocode.util.Utils and
 * Robocode Rules.
 * 
 * The trigonometric section was created by Alexander Schultz, and improved by
 * Julian Kent.
 * 
 * The inverse trigonometric section was first created by Julian Kent, and later
 * improved by Nat Pavasant and Starrynte.
 * 
 * The angle normalization is originally from robocode.util.Utils.
 * 
 * The Robocode Rules is from the Rules class itself;
 * 
 * Other parts was created by Nat Pavasant to use in his robot.
 * 
 * @author Alexander Schultz
 * @author Flemming N. Larsen
 * @author Julian Kent
 * @author Mathew A. Nelson
 * @author Nat Pavasant
 */
public final class M {
	public static final double PI = 3.1415926535897932384626433832795D;
	public static final double TWO_PI = 6.2831853071795864769252867665590D;
	public static final double HALF_PI = 1.5707963267948966192313216916398D;
	public static final double QUARTER_PI = 0.7853981633974483096156608458199D;
	public static final double THREE_OVER_TWO_PI = 4.7123889803846898576939650749193D;

	/* Hide the constructor */
	private M() {
	}

	/* Redirect to Math class (faster version not available) */
	public static final double sqrt(double x) {
		return Math.sqrt(x);
	}

	public static final double cbrt(double x) {
		return Math.cbrt(x);
	}

	public static final double pow(double x, double a) {
		return Math.pow(x, a);
	}

	/* Other implementation */
	public static final double round(double x) {
		return Math.round(x);
	}

	public static final double floor(double x) {
		return Math.floor(x);
	}

	public static final double ceil(double x) {
		return Math.ceil(x);
	}

	public static final double sign(double x) {
		return x > 0 ? 1 : -1;
	}

	public static final double signum(double x) {
		return x == 0 ? 0 : x > 0 ? 1 : -1;
	}

	public static final double abs(double x) {
		return x < 0 ? -x : x;
	}

	public static final double sqr(double x) {
		return x * x;
	}

	public static final double cbr(double x) {
		return x * x * x;
	}

	public static final double qur(double x) {
		return x * x * x * x;
	}

	public static final double max(double a, double b) {
		return a > b ? a : b;
	}

	public static final double min(double a, double b) {
		return a < b ? a : b;
	}

	public static final double max(double a, double b, double c) {
		return max(c, max(a, b));
	}

	public static final double min(double a, double b, double c) {
		return min(c, min(a, b));
	}

	public static final double max(double a, double b, double c, double d) {
		return max(max(c, d), max(a, b));
	}

	public static final double min(double a, double b, double c, double d) {
		return min(min(c, d), min(a, b));
	}

	public static final double limit(double a, double b, double c) {
		return max(a, min(b, c));
	}

	public static final double round(double value, double nearest) {
		return M.round(value / (double) nearest) * (double) nearest;
	}

	public static final double getAngle(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY()
				- source.getY());
	}

	public static final boolean inRange(double a, double b, double c) {
		return a <= b && b <= c;
	}

	public static final boolean inRange(double q, double[] bounds) {
		return bounds[0] <= q && q <= bounds[1];
	}

	public static final Point2D project(Point2D point, double angle,
			double distance) {
		return new Point2D.Double(point.getX() + distance * Math.sin(angle), point
				.getY()
				+ distance * Math.cos(angle));
	}

	/* from robocode.util.Utils */
	public static final double NEAR_DELTA = .00001;

	public static final double normalAbsoluteAngle(double angle) {
		return (angle %= TWO_PI) >= 0 ? angle : (angle + TWO_PI);
	}

	public static final double normalRelativeAngle(double angle) {
		return (angle %= TWO_PI) >= 0 ? (angle < PI) ? angle : angle - TWO_PI
				: (angle >= -PI) ? angle : angle + TWO_PI;
	}

	public static final boolean isNear(double value1, double value2) {
		return (abs(value1 - value2) < NEAR_DELTA);
	}

	/* Robocode Rules */
	public static final double ACCELERATION = robocode.Rules.ACCELERATION;
	public static final double DECELERATION = robocode.Rules.DECELERATION;
	public static final double GUN_TURN_RATE = robocode.Rules.GUN_TURN_RATE_RADIANS;
	public static final double MAX_BULLET_POWER = robocode.Rules.MAX_BULLET_POWER;
	public static final double MAX_TURN_RATE = robocode.Rules.MAX_TURN_RATE_RADIANS;
	public static final double MAX_VELOCITY = robocode.Rules.MAX_VELOCITY;
	public static final double MIN_BULLET_POWER = robocode.Rules.MIN_BULLET_POWER;
	public static final double RADAR_SCAN_RADIUS = robocode.Rules.RADAR_SCAN_RADIUS;
	public static final double RADAR_TURN_RATE = robocode.Rules.RADAR_TURN_RATE_RADIANS;
	public static final double ROBOT_HIT_BONUS = robocode.Rules.ROBOT_HIT_BONUS;
	public static final double ROBOT_HIT_DAMAGE = robocode.Rules.ROBOT_HIT_DAMAGE;

	public static double getBulletDamage(double bulletPower) {
		return robocode.Rules.getBulletDamage(bulletPower);
	}

	public static double getBulletHitBonus(double bulletPower) {
		return robocode.Rules.getBulletHitBonus(bulletPower);
	}

	public static double getBulletSpeed(double bulletPower) {
		return robocode.Rules.getBulletSpeed(bulletPower);
	}

	public static double getGunHeat(double bulletPower) {
		return robocode.Rules.getGunHeat(bulletPower);
	}

	public static double getTurnRate(double velocity) {
		return robocode.Rules.getTurnRateRadians(velocity);
	}

	public static double getWallHitDamage(double velocity) {
		return robocode.Rules.getWallHitDamage(velocity);
	}

	public static double damageToBulletPower(double energy) {
		return (energy / 4 <= 1) ? energy / 4 : (energy + 2) / 6;
	}

	public static double getHitRegneration(double bulletPower) {
		return 3 * bulletPower;
	}
	
	public static final java.awt.geom.Ellipse2D point(Point2D pt, double size) {
		return new java.awt.geom.Ellipse2D.Double(pt.getX() - size, pt.getY() - size, 2d*size, 2d*size);
	}
}
