package myl.micro;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;

/**
 * NekoNinja - a ninja by Martin Y Lepsoy at mlepsoy@yahoo.no
 *
 * 18.12.2002 - Version 1.30 - codesize 745
 *
 * Now even the gun is based on the, soon to be released, Predator 1.50. A pattern analyzer that actually works
 * Is extremely hard to hit constantly.
 * Even SandBoxDT 1.61 and Duelist 0.1.6 will have a hard time predicting where it will go next time
 * This copy is rather messy. If you want to see a readable version, just email me and I will mail you the code
 *
 *
 * 15.12.2002 - Version 1.20 - codesize 618
 *
 * Completely new robot, now only specializes in 1v1 combat
 * Aim is a random amount of calculated aim at a distance over 400
 * No dodging anymore, movement based on Predator's successful movement
 *
 *
 * 09.11.2002 - Version 1.1 - codesize 542
 *
 * New radar management: The radar spins while we are tracking the closest target
 * Aim with average velocity
 * New dodging, better and less predictable ( I think )
 * Won't get slaughtered in melee like before ( but it's not that good :)
 *
 *
 * 14.10.2002 - Version 1.0 - codesize 534
 *
 * NekoNinja is a 1v1 specialist
 *
 */
public class NekoNinja extends AdvancedRobot
{
	static double		nextMove;								//the time before our next move
	
	final static int	storedInfo = 800;						//how many frames we store in our pattern analyzer.
																//not too large to get fresh details on target quickly,
																//but large enough to remember the opponents behavior a little while
	static double[][]	pattern = new double[storedInfo][4];	//all stored info about our enemy
	
	public void run() {
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		
		Color c = Color.darkGray.brighter();
		setColors( c , c , new Color( 162 , 244 , 89 ) );	//new and better ninja colors:-p
		
		while( true ) {
			turnRadarRightRadians( Double.POSITIVE_INFINITY );	//turn radar to find a target
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		int time;	// store time to save codesize
		double targetBearing = getHeadingRadians() + e.getBearingRadians();
		double ourX = getX();	//store own coordinates
		double ourY = getY();	//-"-
		double firePower = Math.min( 3 , 30 * getEnergy() / e.getDistance() );	//powersaving when far from target and low on energy
		//movement code
		if ( nextMove-- <= 0 ) {	//it's time to make our next move
			for ( double a = 0 ; a < 500 ; a++ ) {
				double testX;	//make random test points
				double testY;	//-"-
				double distToWall;	//check the product of the distance to the shortest walls
				double ourAngleToPoint;	//angle to the testpoint
				double turnAngle;	//calculate angle to turn to next point
				if ( ( distToWall = Math.min( testX  = Math.random() * getBattleFieldWidth(), getBattleFieldWidth() - testX ) * Math.min( testY = Math.random() * getBattleFieldHeight() , getBattleFieldHeight() - testY ) ) > 7600 ) {	//make sure the point is within the current wall tolerance (which is always 7600 in this bot which is good for a 800 x 600 battlefield)
					//use point if angle to point is a certain amount from angle to target
					double minimumAngleDifference = ( ( 500 - a ) / 500 ) * Math.PI / 6;	//minimumAngleDifference is the smallest angle difference to accept
					if ( Math.abs( angle_180( targetBearing ) - ( ourAngleToPoint = getAngle( ourX , ourY , testX , testY ) ) ) > 2 * minimumAngleDifference
					 && Math.abs( angle_180( getHeadingRadians() ) - ourAngleToPoint ) > minimumAngleDifference ) {
						//decide which direction to go to reach our point as soon as possible
						double moveDirection = 1;	//use front if next check is false
						if ( Math.abs( turnAngle = angle_180( getAngle( ourX , ourY , testX , testY ) - getHeadingRadians() ) ) > Math.PI / 2 ) {	//if angle is greater than PI / 2 in either directions
							moveDirection = - 1;						//switch direction
							turnAngle += Math.acos( moveDirection );	//and change turnangle acordingly
						}
						setTurnRightRadians( angle_180( turnAngle ) );	//make turn
						setAhead( moveDirection * Point2D.Double.distance( ourX , ourY , testX , testY ) );	//move towards point
						break;
					}
				}
			}
			//make nextMove a little before a bullet will reach you next time
			nextMove = e.getDistance() / ( 29 - 3 * firePower );	//use own firePower here to save space. The enemy is likely to use about the same power as us since firepower often is based on own energy
		}
		setMaxVelocity( getTurnRemaining() > 45 ? 0.001 : 8 );	//adjust velocity when turning to make sharper turns
		//end of movement
		//pattern analyzer
		int match = 0;
		pattern[ time = (int) getTime() % storedInfo ][0] = e.getDistance() / ( 20 - 3 * firePower );	//store time before we will use this angle in our analyzer
		pattern[ time ][1] = e.getVelocity() * Math.sin( e.getHeadingRadians() - targetBearing );	//store linear prediction angle
		pattern[ time ][2] = pattern[ time ][3] = 0;	//reset values used to store our target's actual move
		for ( int a = 0; a < storedInfo; a++ ) {
			if ( pattern[ a ][0] > 0 ) {																//if angle is under evaluation
				pattern[ a ][2] += e.getVelocity() * Math.sin( e.getHeadingRadians() - targetBearing );	//add angle to prediction
				pattern[ a ][0]--;																		//decrease time before use
				pattern[ a ][3]++;																		//increase counter for number of angles used
			}
		}
		for ( int a = 0; a < storedInfo; a++ ) {	//cycle all our stored values
			double testAngle;	//store the angle this turn to save codesize
			if ( pattern[ a ][0] < 0 && Math.abs( ( testAngle = pattern[ time ][1] ) - pattern[ a ][1] ) < Math.abs( testAngle - pattern[ match ][1] ) ) {	//if this value is better than our current match
				match = a;																											//change match to this value
			}
		}
		double linearPredictionAngle = pattern[ match ][2] / ( pattern[ match ][3] * ( 20 - 3 * firePower ) );	//prediction angle with our best match
		//end of pattern analyzer
		linearPredictionAngle = linearPredictionAngle >= 0 ? linearPredictionAngle : 0;
		setTurnGunRightRadians( angle_180( targetBearing - getGunHeadingRadians() + linearPredictionAngle ) );	//turn gun to target with an offset as predicted in our analyzer
		setTurnRadarRightRadians( Math.tan( targetBearing - getRadarHeadingRadians() ) * 3 );	//turn radar to target enemy
		if ( getEnergy() > Math.min( e.getEnergy() + firePower + 0.1 , 3.1 ) ) {	//make sure we won't kill ourself when shooting, also let the enemy run out of energy before you
			setFire( firePower );	//fire
		}
		scan();	//scan to see if our target is still here
	}
	
	//helpers
	
	public double angle_180( double ang ) {	//get the relative angle where -180 < angle < 180
		return Math.atan2( Math.sin( ang ), Math.cos( ang ) );
	}
	
	double getAngle( double x1 , double y1 , double x2 , double y2 ) {	//get the angle between two points
		return Math.atan2( x2 - x1 , y2 - y1 );
	}
}