package test;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import robocode.util.Utils;
import java.util.Random;
import java.lang.*;
import java.util.ArrayList;

/**
 * Fuzzer - a robot by me
 */
public class Fuzzer extends AdvancedRobot
{
	static double array [] [] = new double [101][2];
	static double moveArray [] [] = new double [15] [2];
	static double avoidArray [] = new double [15];
	
	static int index = 0;
	static int shotIndex = 0;
	static int avoidIndex = 0;
	
	public final static double vChangeRateCieling = .44;
	
	Random duck = new Random();
	Random move = new Random();
	
	int direction = 1;
	
	long ctime;
	double tx;
	double ty;
	double tv;
	double th;
	double tb;
	double absb;
	double td = 100000;
	String tn;
	
	long ttHit;
	long timeOfHit;
	
	double bSpeed = 0;
	double bPower;
	
	double startT;
	double endT;
	double elapsedT;
	
	double startV;
	double endV;
	double vChangeRate;
	
	double startHead;
	double endHead;
	double headChangeRate;
	
	double selectedVChangeRate;
	double selectedHeadChangeRate;
	
	double tHealth;
	double oldHealth;
	double healthDif;
	
	double ourStartV;
	double ourEndV;
	double ourVChangeRate;
	
	double wallAngle;
	double ourLastHead;
	double lastSmoothTime;
	
	double flipAvg;
	
	long theirTimeOfHit;
	long shotTime;
	long timeTillHit;
	long startMoveTime;
	
	boolean turned = false;
	boolean shot = false;
	boolean lastShotPassed = true;
	boolean vshot = false;
	boolean circled = false;
	boolean movircled = false;
	boolean avoidircled = false;
	
	int i = 0;
	int orientate = 0;
	
	public static int BINS = 47;
    public static double _surfStats[] = new double[BINS]; // we'll use 47 bins
    public Point2D.Double _myLocation;     // our bot's location
    public Point2D.Double _enemyLocation;  // enemy bot's location

    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;

	public static double _oppEnergy = 100.0;
	
	public static Rectangle2D.Double _fieldRect
        = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);
    public static double WALL_STICK = 160;

	Point2D.Double p;
	
	public RoundRectangle2D.Double playField;
	
	public double gainedFromShots = 35;
	public double lostToShots = 0;
	
	/**
	 * run: Fuzzer's default behavior
	*/
	public void run() {
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		_enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();
		
		setColors(new Color(161, 220, 243), new Color(167, 237, 172), new Color(255, 129, 180));
		setTurnRadarLeft(Double.POSITIVE_INFINITY);
		ttHit = 0;
		timeOfHit = 0;
		vshot = false;
		orientate = 0;
		
		playField = new RoundRectangle2D.Double( 36, 36,
	    getBattleFieldWidth() - 72, getBattleFieldHeight() - 72, 36, 36);
		
		if(getRoundNum()%5 == 0){
			index = 0;
			circled = false;
		}
		
		gainedFromShots = 35;
		lostToShots = 0;
		
		while(true) {
			doScanner();
			//timeOfHit = Math.round((td/11)+startT);
			ttHit = timeOfHit - getTime();
			
			if(index>99){
			circled = true;
			index = 0;}
			
			if(shotIndex>14){
			movircled = true;
			shotIndex = 0;}
			
			if(avoidIndex>14){
			avoidircled = true;
			avoidIndex = 0;}
			
			timeTillHit = theirTimeOfHit - getTime();
			if(timeTillHit <= 0)
			lastShotPassed = true;
			
			doGun();
			
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if((e.getDistance() < td)||(tn == e.getName())){
			
			if(tn != e.getName()){
				index = 0;
				circled = false;
			}
			//out.println(getTime()/3-2 + " " + i);
			i++;
			//See if they shot
			tHealth = e.getEnergy();
			healthDif = oldHealth - tHealth;
			if(healthDif <= 3 && healthDif > 0 && lastShotPassed){
				shot = true;
				shotTime = getTime();
				theirTimeOfHit = Math.round(getTimeToHit(tx, ty, healthDif));
				lastShotPassed = false;
			}
			else{
				shot = false;
			}
			//////
		_myLocation = new Point2D.Double(getX(), getY());

        double lateralVelocity = getVelocity()*Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + getHeadingRadians();

        setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);

        _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));


        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09
            && _surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone(); // last tick

            _enemyWaves.add(ew);
        }

		_oppEnergy = e.getEnergy();

        // update after EnemyWave detection, because that needs the previous
        // enemy location as the source of the wave
        _enemyLocation = project(_myLocation, absBearing, e.getDistance());

			///////
			
			oldHealth = e.getEnergy();

			tn = e.getName();
			ctime = getTime();
			tx = getX() + (Math.sin(getHeadingRadians() + e.getBearingRadians()) * e.getDistance());
			ty = getY() + (Math.cos(getHeadingRadians() + e.getBearingRadians()) * e.getDistance());
			tv = e.getVelocity();
			th = e.getHeadingRadians();
			td = e.getDistance();
			tb = e.getBearing();
			
			absb = (getHeadingRadians() + e.getBearingRadians());
			
			if(e.getEnergy() != 0){
				bPower = (((8/e.getVelocity()) + (2/(e.getDistance()/getBattleFieldWidth())) + (getEnergy()/e.getEnergy())) / 3);
			}
			else{
				bPower = .1;
			}
			if(bPower > 3) bPower = 3;
			else if(bPower < .1) bPower = .1;
			
			bSpeed = 20 - (3*bPower);
			
			//If they shot
			if(shot){
				ourStartV = getVelocity();
				double ourStartHead = getHeading();
				double shotTime = getTime();
				moveArray [shotIndex] [0] = shotTime;
				moveArray [shotIndex] [1] = ourStartHead;
				shotIndex++;
			}
			//if(orientate == 0){
			if(e.getBearing()>0)
			setTurnRight((e.getBearing() - 90));
			else if(e.getBearing()<=0)
			setTurnRight((e.getBearing() + 90));
			orientate++;
			//}

		doVGun();
		updateWaves();
        doSurfing();
		doGun();

			execute();
		}
	}
	///////////////////
	public void updateWaves() {
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

            ew.distanceTraveled = (getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled >
                _myLocation.distance(ew.fireLocation) + 50) {
                _enemyWaves.remove(x);
                x--;
            }
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;

        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;

            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
        }

        return surfWave;
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, calculate the index into our stat array for that factor.
    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = (absoluteBearing(ew.fireLocation, targetLocation)
            - ew.directAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / maxEscapeAngle(ew.bulletVelocity) * ew.direction;

        return (int)limit(0,
            (factor * ((BINS - 1) / 2)) + ((BINS - 1) / 2),
            BINS - 1);
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, update our stat array to reflect the danger in that area.
    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = getFactorIndex(ew, targetLocation);

        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            _surfStats[x] += 1.0 / (Math.pow(index - x, 2) + 1);
        }
    }

    // CREDIT: mini sized predictor from Apollon, by rozu
    // http://robowiki.net?Apollon
    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
    	Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
    	double predictedVelocity = getVelocity();
    	double predictedHeading = getHeadingRadians();
    	double maxTurning, moveAngle, moveDir;

        int counter = 0; // number of ticks in the future
        boolean intercepted = false;

    	do {
    		moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                predictedPosition) + (direction * (Math.PI/2)), direction)
                - predictedHeading;
    		moveDir = 1;

    		if(Math.cos(moveAngle) < 0) {
    			moveAngle += Math.PI;
    			moveDir = -1;
    		}

    		moveAngle = Utils.normalRelativeAngle(moveAngle);

    		// maxTurning is built in like this, you can't turn more then this in one tick
    		maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
    		predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + limit(-maxTurning, moveAngle, maxTurning));

    		// this one is nice ;). if predictedVelocity and moveDir have
            // different signs you want to breack down
    		// otherwise you want to accelerate (look at the factor "2")
    		predictedVelocity += (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
    		predictedVelocity = limit(-8, predictedVelocity, 8);

    		// calculate the new predicted position
    		predictedPosition = project(predictedPosition, predictedHeading, predictedVelocity);

            counter++;

            if (predictedPosition.distance(surfWave.fireLocation) <
                surfWave.distanceTraveled + (counter * surfWave.bulletVelocity)
                + surfWave.bulletVelocity) {
                intercepted = true;
            }
    	} while(!intercepted && counter < 500);

    	return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = getFactorIndex(surfWave,
            predictPosition(surfWave, direction));

        return _surfStats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = getClosestSurfableWave();

        if (surfWave == null) { return; }

        double dangerLeft = checkDanger(surfWave, -1);
        double dangerRight = checkDanger(surfWave, 1);

        double goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);
        if (dangerLeft < dangerRight) {
            goAngle = wallSmoothing(_myLocation, goAngle - (Math.PI/2), -1);
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (Math.PI/2), 1);
        }

        setBackAsFront(this, goAngle);
    }
	///////////////
	
	public void doVGun(){
		
		if(ttHit < 0 && vshot == false){
			startT = getTime();
			startV = tv;
			startHead = th;
			timeOfHit = Math.round((td/bSpeed)+startT);
			ttHit = timeOfHit - getTime();
			vshot = true;
		}
		
		if(ttHit<=0 && vshot == true){
			endT = getTime();
			endHead = th;
			endV = tv;
			elapsedT = endT - startT;
			vChangeRate = (endV - startV)/elapsedT;
			if(endHead-startHead>0)
			headChangeRate = (endHead - startHead)/elapsedT;
			//System.out.println((endHead - startHead)/elapsedT);}
			else{
			endHead+=2*Math.PI;
			headChangeRate = (endHead - startHead)/elapsedT;
			//System.out.println(" " + (endHead - startHead)/elapsedT);
			}
			
			array [index] [0] = vChangeRate;
			array [index] [1] = headChangeRate;
			
			/*for(int rows = 0; rows < index; rows++){
				//Prints all of the collected data so far
				System.out.println(array[rows][0]+" "+array[rows][1]);
			}*/
			//System.out.println();
			
			index ++;
			
			vshot = false;
			
			execute();
		}
	}
	
	public void doGun(){
		
		double radius = 0;
		//out.println(radius);
		double totHeadChange = 0;
		double totVChange = 0;
		double dif = 0;
		
		double nextX = tx;
		double nextY = ty;

		double dataTaken = index;
		
		if(circled == true)
		dataTaken = 100;
		
		//This puts 'rand' between 0 and index ( or 100 )
		int rand = new Long(Math.round(duck.nextDouble()*dataTaken)).intValue();
		
		selectedVChangeRate = array [ rand ] [ 0 ];
		selectedHeadChangeRate = array [ rand ] [ 1 ];

		dif = getTimeToHit(nextX, nextY);
		
		if(selectedHeadChangeRate!=0){
			radius = tv/selectedHeadChangeRate;
		}

		if(radius == 0){
			for(int i = 0; i < 10; i ++){
				dif = getTimeToHit(nextX, nextY);
				totVChange = selectedVChangeRate * dif;
				nextX = tx + (Math.sin(th) * (tv + totVChange) * dif);
				nextY = ty + (Math.cos(th) * (tv + totVChange) * dif);
			}
		}
		else {
			for(int i = 0; i < 10; i ++){
				dif = getTimeToHit(nextX, nextY);
				totHeadChange = selectedHeadChangeRate * dif;
				nextY = ty + (Math.sin(th + totHeadChange) * radius) - (Math.sin(th) * radius);
				nextX = tx + (Math.cos(th) * radius) - (Math.cos(th + totHeadChange) * radius);
			}
		}
		
				
		if(getGunHeat()==0 && getEnergy() - bPower > .1 && getGunTurnRemaining() == 0 && gainedFromShots > lostToShots){
			setFire(bPower);
		}
		
		double gunOffset = getGunHeadingRadians() - (Math.PI/2 - Math.atan2(nextY - getY(),nextX -  getX()));
		setTurnGunLeftRadians(NormaliseBearing(gunOffset));
		
		execute();
	}
	
	public void onBulletHit(BulletHitEvent e){
		gainedFromShots += 6;
	}
	
	public void onBulletMissed(BulletMissedEvent e){
		lostToShots += 1;
	}
	
	public double getTimeToHit(double x, double y){
		double xsq = (getX()-tx)*(getX()-tx);
		double ysq = (ty - getY())*(ty - getY());
		double dist = Math.sqrt(xsq + ysq);
		double time = dist/bSpeed;
		return time;
	}
	
	public double getTimeToHit(double x, double y, double bPower){
		double bSpeed = 3*bPower;
		bSpeed = 20 - bSpeed;
		double xsq = (getX()-tx)*(getX()-tx);
		double ysq = (ty - getY())*(ty - getY());
		double dist = Math.sqrt(xsq + ysq);
		double time = dist/bSpeed;
		return time;
	}
	
	public double fix(double angle){
		if(angle<0)
		angle+=360;
		if(angle>360)
		angle-=360;
		return angle;
	}
	
	void doScanner()
		{
		double radarOffset = 0;
			if(getTime() - ctime > 4){
				radarOffset = 4*Math.PI;
			}
			else{
			radarOffset = getRadarHeadingRadians() - (Math.PI/2 - Math.atan2(ty - getY(),tx - getX())); 

			radarOffset = NormaliseBearing(radarOffset);
			if (radarOffset < 0)
				radarOffset -= Math.PI/10;
			else {
				radarOffset += Math.PI/10; 
		}
	}
		setTurnRadarLeftRadians(radarOffset);
	}
	
	double NormaliseBearing(double ang) {
		if (ang > Math.PI)
			ang -= 2*Math.PI;
		if (ang < -Math.PI)
			ang += 2*Math.PI;
		return ang;
	}
	
	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		
		double tbSpeed = 20-(3*e.getPower());
		double timeElapse = Math.round(td/tbSpeed);
		double timeOfShot = getTime() - timeElapse;
		
		// If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
                e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;

            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.round(bulletVelocity(e.getBullet().getPower()) * 10)
                       == Math.round(ew.bulletVelocity * 10)) {
                    hitWave = ew;
                    break;
                }
            }

            if (hitWave != null) {
                logHit(hitWave, hitBulletLocation);

                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
		
	}

class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity, directAngle, distanceTraveled;
        int direction;

        public EnemyWave() { }
    }

    // CREDIT: Iterative WallSmoothing by Kawigi
    //   - return absolute angle to move at after account for WallSmoothing
    // robowiki.net?WallSmoothing
    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, 160))) {
            angle += orientation*0.05;
        }
        return angle;
    }

    // CREDIT: from CassiusClay, by PEZ
    //   - returns point length away from sourceLocation, at angle
    // robowiki.net?CassiusClay
    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }

    // got this from RaikoMicro, by Jamougha, but I think it's used by many authors
    //  - returns the absolute angle (in radians) from source to target points
    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return (20D - (3D*power));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle =
            Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            robot.setAhead(100);
        }
    }
}