package suh.micro;

import java.awt.Color;
import robocode.*;
import robocode.util.Utils;

public class MirrorPM extends AdvancedRobot {
    public static final int MAX_SEARCH_PATTERN_LENGTH = 50;
    
    private static String history = "" + 
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	    (char)1 + (char)2 + (char)3 + (char)4 + (char)5 + (char)6 + (char)7 + (char)8 +
	    (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 +
	    (char)8 + (char)7 + (char)6 + (char)5 + (char)4 + (char)3 + (char)2 + (char)1 +
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	    (char)-1 + (char)-2 + (char)-3 + (char)-4 + (char)-5 + (char)-6 + (char)-7 + (char)-8 +
	    (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 +
	    (char)-8 + (char)-7 + (char)-6 + (char)-5 + (char)-4 + (char)-3 + (char)-2 + (char)-1 +
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0;
    
    @Override
    public void run() {
	setColors(Color.BLACK, Color.BLACK, Color.BLACK);
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    scan();
	}
    }
    
    @Override
    @SuppressWarnings("empty-statement")
    public void onScannedRobot(ScannedRobotEvent e) {
	double angle;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((angle = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Movement
	goTo(getBattleFieldWidth() - (getX() + e.getDistance() * Math.sin(angle)),  
		getBattleFieldHeight() - (getY() + e.getDistance() * Math.cos(angle)));
	
	// Targeting
	double power = Math.min(15.0 * getEnergy() / e.getDistance(), e.getEnergy() / 4.0);
	double velocity = Rules.getBulletSpeed(power);
	int i = MAX_SEARCH_PATTERN_LENGTH;
	int matchIndex;
	
	history = String.valueOf((char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - angle))).concat(history);
	
	while((matchIndex = history.indexOf(history.substring(0, i--), (int)(e.getDistance() / velocity + 1.0))) < 0);
	i = (int)(e.getDistance() / velocity + 1.0);
	do { angle += Math.asin(((short)history.charAt(--matchIndex)) / e.getDistance()); } while (--i > 0);
	
	setTurnGunRightRadians(Utils.normalRelativeAngle(angle - getGunHeadingRadians()));
	setFire(power);
    }
    
    private void goTo(double x, double y) {
	double angle, turnAngle;
	setTurnRightRadians(turnAngle = Math.atan(Math.tan(angle = Utils.normalRelativeAngle(Math.atan2(x = x - getX(), y = y - getY()) - getHeadingRadians()))));
	setAhead((angle == turnAngle) ? Math.hypot(x, y) : -Math.hypot(x, y));
    }
}
