package rc.yoda.utils;

import java.awt.geom.Point2D;

/**
 * VirtualBullet - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * VirtualBullet.java : v1.0 -- 2007/05/12
 */ 

/**
 * VirutalBullet that contains the
 * atributtes needed to update and track
 * a Virtual Bullet for Gun Stats
 *
 * @author Robert Codd
 * @version v1.0
 */
public class VirtualBullet
{
	/**
	 * The name of the Gun that fired this Virtual Bullet
	 */
	public String gunName;
	
	/**
	 * The current location of this Virtual Bullet 
	 */
	public Point2D.Double location;
	
	/**
	 * The heading in radians this Virtual Bullet is travlling
	 */
	public double heading;
	
	/**
	 * The velocity this Virtual Bullet is travelling
	 */
	public double velocity;
	
	/**
	 * Whether this Virtual bullet is also reconized by Robocode as a bullet
	 */
	public boolean real;
	
	/** 
     * Class constructor specifying the Name of the firing Gun, the VirtualBullets initial location,
	 * the VirtuaBullets heading and velocity and whether it was fire by the robot
     */
	public VirtualBullet(String gunName, Point2D.Double location, double heading, double velocity, boolean real) {
		this.gunName = gunName;
		this.location = location;
		this.heading = heading;
		this.velocity = velocity;
		this.real = real;
	}

	/**
	 * Advances the location of this VirtualBullet one tick in the furture
	 */
	public void update() {
		location = YUtils.project(location, heading, velocity);
	}
}
