/*
 * GrayCode - Utility class for neural nets of Robocode bots.
 * Copyright (C) 2002  Joachim Hofer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * You can contact the author via email (qohnil@johoop.de) or write to
 * Joachim Hofer, Feldstr. 12, D-91052 Erlangen, Germany.
 */

package qohnil.neural.util;

public class GrayCode {

    public static int encode(int src) {
        int tgt = 0;

        for (int factor = 1 << 20; factor > 0; factor >>= 1) {
            if (src >= factor) {
                tgt += factor;
                tgt += encode((factor << 1) - 1 - src);
                return tgt;
            }
        }
        return src;
    }

    public static int decode(int src) {
        int tgt = 0;

        for (int factor = 1 << 20; factor > 0; factor >>= 1) {
            if (src >= factor) {
                tgt += factor;
                tgt += decode((src - factor) ^ (factor >> 1));
                return tgt;
            }
        }
        return src;
    }
}
