package apv;
import robocode.*;
import java.awt.geom.*;

/** NanoLauLectrik -  by Albert Prez 
* v 0.6	I managed to put a pattern matcher in a Nano... 
* v 0.7 New pattern matcher with fixed length. Previous one was too bugous and didn't fit after fixing
* v 0.8 More bugs fixed
*		Now compatible with java 1.3
* v 0.9 Again, only compatible with 1.4
* 		Improved pattern matcher:
*			Codesize reduced - I included some very good improvements Mike made on his bot (Moebious)
*			Now, it uses the perp. velocity for the matching (like Moebious)
*			Now, it matches the closer pattern in the time, so it caches changes in behaviour
*			Variable pattern-size pattern matcher !!!! into a nanobot !!!
*		Reduced main loop bucle
*		Eliminated AdjustRadarForGunTurn
*		Other minor improvements to reduce code size
* v 1.0	Reduced pattern matcher code size thanks to Kuuran's trick in NanoSatan
*		Added some more complex oscillatory movement

* TheCannibal v 1.0 - Just an experimental Cannibal movement
*             v 1.1 - Improved pattern matcher
*                     Power management  
*/		  

public class NanoLauLectrikTheCannibal extends AdvancedRobot {

	static StringBuffer pattern = new StringBuffer();
			
	public void run() {	turnRadarRightRadians(Double.POSITIVE_INFINITY); }		
	
	//The idea of using a method to declare the variables is from PEZ
	public void onScannedRobot(ScannedRobotEvent e) { 
		brain(e, 0, 30, getHeadingRadians() + e.getBearingRadians(), e.getDistance(), 0);  
	}
		
	private void brain (ScannedRobotEvent e, int pointer, int len, double targetBearing, double distance, double lateraldistance) {
		//ENEMY DATA & MOVEMENT	
		pattern.insert(0,(char)(pointer = (int) (e.getVelocity() * Math.sin(e.getHeadingRadians()-targetBearing))));
		setAhead(pointer * 200);
		setTurnRightRadians(e.getBearingRadians()+Math.PI/2);
		//AIMING & FIRING
		double power = Math.min(Math.min(1200.0/distance, getEnergy()/3.0),3.0);
		//targetBearing -= getGunHeadingRadians();
		try {
		//the ideas of using the String to store the values needed to reproduce the movement, instead of an array,
		//and of storing the data in the inverse order is from Kawigi's FunkyChicken.	
			do { pointer = pattern.indexOf(pattern.substring(0,len),100); } while (--len*pointer < -1);			
			len = 1;	
			while ((20-3*power)*len++<Point2D.distance(0,0,distance,lateraldistance) && e.getEnergy()>0) {
				lateraldistance += (byte) pattern.charAt(pointer-len);		 
			} 
			//do {
			//	lateraldistance += (byte) pattern.charAt(pointer-len);		 
			//} while ((20-3*power)*len++<Point2D.distance(0,0,distance,lateraldistance) && e.getEnergy()>0)
		} catch (Exception ex) {}
		setTurnGunRightRadians(Math.sin(targetBearing - getGunHeadingRadians() + Math.atan(lateraldistance/distance))); 
		//setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(Math.atan(lateraldistance/distance) + targetBearing)); 
		setFire(power); 
		//RADAR
		setTurnRadarLeftRadians(getRadarTurnRemaining());
	} 
			
}

										