package gadsky;

import robocode.ScannedRobotEvent;
import robocode.Rules;

public final class Enemy {
	public final long time;
	public final double bodyAngle;
	public final double distance;
	public final double velocity;
	private final double offsetAngle;
	public final Vector2D offset;
	public final Vector2D position;
	public final Vector2D speed;
	public double energy;
	public final double iWillFireIn;

	public double bodyAngleChange = 0.0;
	public double acceleration = 0.0;

	public Enemy(Gadsky robot, ScannedRobotEvent e, Enemy previous) {
		time = robot.my.time;
		bodyAngle = Tools.normalize(e.getHeadingRadians());
		distance = e.getDistance();
		velocity = e.getVelocity();
		offsetAngle = robot.my.bodyAngle - e.getBearingRadians();
		offset = Vector2D.EX.rotated(offsetAngle).mul(distance);
		position = robot.my.position.add(offset);
		speed = Vector2D.EX.rotated(bodyAngle).mul(velocity);
		energy = e.getEnergy();
		iWillFireIn = robot.my.iWillFireIn;

		if (previous != null) {
			bodyAngleChange = bodyAngle - previous.bodyAngle;
			acceleration = velocity - previous.velocity;
		}

	}
}
