package suh.targeting;

import robocode.*;
import suh.util.Utility;

public class BasicFireManager extends FireManager {
    public BasicFireManager(AdvancedRobot self) {
	super(self);
    }
    
    @Override
    public double getPower(ScannedRobotEvent e) {
	return Utility.limit(0.1, 
		Math.min(
		    600.0/e.getDistance() + (self.getEnergy() - e.getEnergy())/20.0, 
		    Math.min(self.getEnergy()/10.0, e.getEnergy()/4.0)
		), 
		3.0);
    }
}
