package squidM;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;
/**
 * TentalceMeleeNano - a robot by (your name here)
 */
public class TentalceMeleeNano extends AdvancedRobot
{
	
	static final double GUN_FACTOR = 30;
	static final int AIM_START = 10;
	static final double AIM_FACTOR = 1.008;
	static final int FIRE_FACTOR = 7;
					
	static double xForce;
	static double yForce;
	static double lastDistance;
	/**
	 * run: TentalceMeleeNano's default behavior
	 */
	public void run() {
		// Initialization of the robot should be put here

		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:

		setColors(Color.red,Color.black,Color.pink); // body,gun,radar

		// Robot main loop
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) 
	{

	setTurnRadarLeftRadians(getRadarTurnRemaining());
		// Get our turn angle - factor in distance from each wall every time so we get
		// pushed towards the center when close to the walls.  This took a long time to come up with.
		setTurnRightRadians(Utils.normalRelativeAngle(
			Math.atan2(xForce + 1/getX() - 1/(getBattleFieldWidth() - getX()), 
					   yForce + 1/getY() - 1/(getBattleFieldHeight() - getY()))
						- getHeadingRadians()) );

		// Move ahead depending on how much turn is needed.
		setAhead(240 - Math.abs(getTurnRemaining()));
		
					double P = 2.4; 
	double bV = 20 - (P * 3); 
	double aB = getHeadingRadians() + e.getBearingRadians();
 setTurnGunRightRadians
(Utils.normalRelativeAngle(aB - getGunHeadingRadians() + (e.getVelocity() * Math.sin(e.getHeadingRadians() - aB) / bV)));
	fire(P);			
	}						
	

}
